/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.security.SslContexts;
import com.tplink.smb.ecsp.transport.api.transport.AbstractClient;
import com.tplink.smb.ecsp.transport.netty.ChannelLoggingHandler;
import com.tplink.smb.ecsp.transport.netty.NettyChannel;
import com.tplink.smb.ecsp.transport.netty.NettyEventLoopFactory;
import com.tplink.smb.ecsp.transport.netty.NettyTcpClientHandler;
import com.tplink.smb.ecsp.transport.netty.RttyCodecAdapter;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RttyNettyTcpClient
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(RttyNettyTcpClient.class);
    private EventLoopGroup nioEventLoopGroup;
    private Bootstrap bootstrap;
    private Channel channel;

    public RttyNettyTcpClient(URL url, com.tplink.smb.ecsp.transport.api.ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    protected void doOpen() {
        final NettyTcpClientHandler nettyTcpClientHandler = new NettyTcpClientHandler(this.getUrl(), (com.tplink.smb.ecsp.transport.api.ChannelHandler)this);
        this.bootstrap = new Bootstrap();
        int num = new Random().nextInt() % 73;
        this.nioEventLoopGroup = NettyEventLoopFactory.eventLoopGroup(1, "tcp-client-" + num);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.nioEventLoopGroup)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).channel(NettyEventLoopFactory.socketChannelClass());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.max(3000, this.getConnectTimeout()));
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                RttyNettyTcpClient.this.initSslHandlerIfNeed(ch);
                ChannelPipeline pipeline = ch.pipeline();
                RttyCodecAdapter rttyCodecAdapter = new RttyCodecAdapter(RttyNettyTcpClient.this.getUrl(), (com.tplink.smb.ecsp.transport.api.ChannelHandler)RttyNettyTcpClient.this);
                pipeline.addLast(new ChannelHandler[]{rttyCodecAdapter.getDefaultDecoder()});
                pipeline.addLast(new ChannelHandler[]{rttyCodecAdapter.getDefaultEncoder()});
                pipeline.addLast("logging", (ChannelHandler)new ChannelLoggingHandler());
                pipeline.addLast("handler", (ChannelHandler)nettyTcpClientHandler);
            }
        });
    }

    private void initSslHandlerIfNeed(SocketChannel ch) {
        if (this.getUrl().getParameter("ssl-enabled", false)) {
            SSLContext clientSslContext = SslContexts.buildSslContext((String)this.getUrl().getParameter("ssl-cert"), (String)this.getUrl().getParameter("ssl-cert-pwd"), (String)this.getUrl().getParameter("ssl-keystore"), (String)this.getUrl().getParameter("ssl-keystore-pwd"), (String)this.getUrl().getParameter("ssl-protocol", "TLSv1.2"));
            if (clientSslContext == null) {
                log.warn("create clientSSLContext error, protocol:{}, port: {}", (Object)this.getUrl().getProtocol(), (Object)this.getUrl().getPort());
                return;
            }
            SSLEngine sslEngine = clientSslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            log.debug("ssl enabled Protocols: {}", (Object)Arrays.toString(sslEngine.getEnabledProtocols()));
            ch.pipeline().addFirst("negotiation", (ChannelHandler)new SslHandler(sslEngine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() throws RemotingException {
        block6: {
            long start = System.currentTimeMillis();
            ChannelFuture future = this.bootstrap.connect((SocketAddress)this.getConnectAddress());
            try {
                boolean ret = future.awaitUninterruptibly((long)this.getConnectTimeout(), TimeUnit.MILLISECONDS);
                if (ret && future.isSuccess()) {
                    this.updateChannel(future.channel());
                    break block6;
                }
                if (future.cause() != null) {
                    throw new RemotingException((com.tplink.smb.ecsp.transport.api.Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + ", error message is:" + future.cause().getMessage(), future.cause());
                }
                throw new RemotingException((com.tplink.smb.ecsp.transport.api.Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client ");
            }
            finally {
                if (!this.isConnected()) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannel(Channel newChannel) {
        block13: {
            try {
                Channel oldChannel = this.channel;
                if (oldChannel == null) break block13;
                try {
                    log.info("Close old netty channel {},  on create new netty channel {}", (Object)oldChannel, (Object)newChannel);
                    oldChannel.close();
                }
                finally {
                    NettyChannel.removeChannelIfDisconnected(oldChannel);
                }
            }
            finally {
                if (this.isClosed()) {
                    try {
                        log.info("Close new netty channel {}, because the client closed.", (Object)newChannel);
                        newChannel.close();
                    }
                    finally {
                        this.channel = null;
                        NettyChannel.removeChannelIfDisconnected(newChannel);
                    }
                } else {
                    this.channel = newChannel;
                }
            }
        }
    }

    public Single<Boolean> send(Object message, boolean sent) {
        com.tplink.smb.ecsp.transport.api.Channel socketChannel;
        if (this.isNeedReconnect() && !this.isConnected()) {
            try {
                this.connect();
            }
            catch (RemotingException e) {
                return Single.error((Throwable)new RemotingException((com.tplink.smb.ecsp.transport.api.Channel)this, "message can not send, cause channel is not connected . url:" + this.getUrl()));
            }
        }
        if (Objects.isNull(socketChannel = this.getChannel()) || !socketChannel.isConnected()) {
            return Single.error((Throwable)new RemotingException((com.tplink.smb.ecsp.transport.api.Channel)this, "message can not send, cause channel is closed . url:" + this.getUrl()));
        }
        return socketChannel.send(message, sent);
    }

    protected void doDisConnect() {
        NettyChannel.removeChannelIfDisconnected(this.channel);
    }

    protected void doClose() {
        if (this.nioEventLoopGroup != null) {
            this.nioEventLoopGroup.shutdownGracefully();
        }
    }

    protected com.tplink.smb.ecsp.transport.api.Channel getChannel() {
        Channel c = this.channel;
        if (c == null) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), (com.tplink.smb.ecsp.transport.api.ChannelHandler)this);
    }

    Channel getNettyChannel() {
        return this.channel;
    }

    public boolean canHandleIdle() {
        return true;
    }

    public com.tplink.smb.ecsp.transport.api.ChannelHandler getChannelHandler() {
        return this.getHandler();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }
}

