/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import com.tplink.smb.ecsp.transport.netty.NettyChannel;
import com.tplink.smb.rtty.protocol.packet.RttyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RttyCodecAdapter {
    private static final Logger log = LoggerFactory.getLogger(RttyCodecAdapter.class);
    private final URL url;
    private final com.tplink.smb.ecsp.transport.api.ChannelHandler handler;

    public RttyCodecAdapter(URL url, com.tplink.smb.ecsp.transport.api.ChannelHandler handler) {
        this.url = url;
        this.handler = handler;
    }

    public ChannelHandler getDefaultEncoder() {
        return new RttyInternalEncoder();
    }

    public ChannelHandler getDefaultDecoder() {
        return new RttyInternalDecoder();
    }

    private class RttyInternalEncoder
    extends MessageToMessageEncoder<RttyPacket> {
        private RttyInternalEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, RttyPacket msg, List<Object> out) {
            if (Objects.isNull(msg)) {
                throw new IllegalArgumentException("RTTY Encoder error: msg is null");
            }
            NettyChannel.getOrAddChannel(ctx.channel(), RttyCodecAdapter.this.url, RttyCodecAdapter.this.handler);
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeBytes(msg.pack());
            out.add(buf);
        }
    }

    private class RttyInternalDecoder
    extends ByteToMessageDecoder {
        private RttyInternalDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) {
            try {
                NettyChannel.getOrAddChannel(ctx.channel(), RttyCodecAdapter.this.url, RttyCodecAdapter.this.handler);
                int payloadReadableLength = input.readableBytes();
                byte rttyType = input.getByte(input.readerIndex());
                short rttyPayloadNeededLength = input.getShort(input.readerIndex() + 1);
                if (payloadReadableLength < 3 + rttyPayloadNeededLength) {
                    log.debug("rtty payload length: {}, needed length :{}, rtty type: {}, wait for next frame", new Object[]{payloadReadableLength, rttyPayloadNeededLength, rttyType});
                    ServerMonitor.incTcpPacketDisassembleDecodeFailedCounter();
                    return;
                }
                rttyType = input.readByte();
                rttyPayloadNeededLength = input.readShort();
                ByteBuffer byteBuffer = ByteBuffer.allocate(rttyPayloadNeededLength);
                input.readBytes(byteBuffer);
                byteBuffer.rewind();
                RttyPacket rttyPacket = this.buildRttyPacket(rttyType, rttyPayloadNeededLength, byteBuffer);
                out.add(rttyPacket);
            }
            catch (Exception e) {
                log.warn("rtty decode error: {}", (Object)e.getMessage());
            }
        }

        private RttyPacket buildRttyPacket(byte rttyType, short payloadLen, ByteBuffer payload) {
            return RttyPacket.builder().typeField(rttyType).lengthField(payloadLen).payload(payload).build();
        }
    }
}

