/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.TransConstants;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.transport.AbstractServer;
import com.tplink.smb.ecsp.transport.netty.NettyCodecAdapter;
import com.tplink.smb.ecsp.transport.netty.NettyEventLoopFactory;
import com.tplink.smb.ecsp.transport.netty.NettyFutureTransformer;
import com.tplink.smb.ecsp.transport.netty.NettyUdpHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUdpServer
extends AbstractServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(NettyUdpServer.class);
    private Bootstrap udpBootstrap;
    private Channel channel;
    private EventLoopGroup bossGroup;

    NettyUdpServer(URL url, com.tplink.smb.ecsp.transport.api.ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    protected void doOpen() {
        NettyUdpHandler nettyServerHandler = new NettyUdpHandler((com.tplink.smb.ecsp.transport.api.ChannelHandler)this);
        ChannelFuture channelFuture = this.doOpenUdpServer(nettyServerHandler);
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    private ChannelFuture doOpenUdpServer(final NettyUdpHandler nettyServerHandler) {
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getParameter("io-threads", TransConstants.DEFAULT_IO_THREADS), "netty-udp-server");
        this.udpBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.udpBootstrap.group(this.bossGroup)).channel(NettyEventLoopFactory.datagramChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).option(ChannelOption.SO_BROADCAST, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)0xD00000);
        this.udpBootstrap.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) {
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyUdpServer.this.getUrl(), (com.tplink.smb.ecsp.transport.api.ChannelHandler)NettyUdpServer.this);
                ch.pipeline().addLast("decoder", adapter.getUdpDecoder()).addLast("encoder", adapter.getUdpEncoder()).addLast("handler", (ChannelHandler)nettyServerHandler);
            }
        });
        return this.udpBootstrap.bind((SocketAddress)this.getBindAddress());
    }

    public Single<Boolean> send(Object message, boolean sent) {
        if (this.channel == null) {
            log.info("channel of udp server is null");
            return Single.error((Throwable)new RemotingException(this.getLocalAddress(), null, "netty channel of udp server is null"));
        }
        return NettyFutureTransformer.transformNettySendMessage(this.channel, this.getUrl(), message, sent);
    }

    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.udpBootstrap != null) {
                this.bossGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<com.tplink.smb.ecsp.transport.api.Channel> getChannels() {
        return new HashSet<com.tplink.smb.ecsp.transport.api.Channel>();
    }

    public com.tplink.smb.ecsp.transport.api.Channel getChannel(InetSocketAddress remoteAddress) {
        return null;
    }

    public int getConnections() {
        return 0;
    }

    public void kickChannels(int kickBatchNum, int kickIntervalMs, int restTimeMs) {
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public com.tplink.smb.ecsp.transport.api.ChannelHandler getChannelHandler() {
        return this.getHandler();
    }
}

