/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.util.NetUtils;
import com.tplink.smb.ecsp.transport.api.Client;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.transport.AbstractEndpoint;
import com.tplink.smb.ecsp.transport.netty.NettyCodecAdapter;
import com.tplink.smb.ecsp.transport.netty.NettyEventLoopFactory;
import com.tplink.smb.ecsp.transport.netty.NettyFutureTransformer;
import com.tplink.smb.ecsp.transport.netty.NettyUdpHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUdpClient
extends AbstractEndpoint
implements Client {
    private static final Logger log = LoggerFactory.getLogger(NettyUdpClient.class);
    private static final EventLoopGroup NIO_EVENT_LOOP_GROUP = NettyEventLoopFactory.eventLoopGroup(1, "netty-udp-client");
    private Bootstrap bootstrap;
    private Channel channel;

    public NettyUdpClient(URL url, com.tplink.smb.ecsp.transport.api.ChannelHandler handler) {
        super(url, handler);
        try {
            this.doOpen();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            this.close();
        }
    }

    protected void doOpen() {
        final NettyUdpHandler nettyTcpClientHandler = new NettyUdpHandler((com.tplink.smb.ecsp.transport.api.ChannelHandler)this);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(NIO_EVENT_LOOP_GROUP)).channel(NettyEventLoopFactory.datagramChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).option(ChannelOption.SO_BROADCAST, (Object)true);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) {
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyUdpClient.this.getUrl(), (com.tplink.smb.ecsp.transport.api.ChannelHandler)NettyUdpClient.this);
                ch.pipeline().addLast("decoder", adapter.getUdpDecoder()).addLast("encoder", adapter.getUdpEncoder()).addLast("handler", (ChannelHandler)nettyTcpClientHandler);
            }
        });
        ChannelFuture future = this.bootstrap.bind(0);
        future.syncUninterruptibly();
        this.channel = future.channel();
        log.info("Start {}, export {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getLocalAddress());
    }

    public Single<Boolean> send(Object message, boolean sent) {
        if (this.channel == null) {
            log.info("channel of udp client to  remote address: " + this.getRemoteAddress() + " is null ");
            return Single.error((Throwable)new RemotingException(this.getLocalAddress(), this.getRemoteAddress(), "netty channel of udp client is null"));
        }
        return NettyFutureTransformer.transformNettySendMessage(this.channel, this.getUrl(), message, sent);
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(NetUtils.filterLocalHost((String)this.getUrl().getHost()), this.getUrl().getPort());
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void close() {
        NIO_EVENT_LOOP_GROUP.shutdownGracefully();
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.bootstrap != null) {
                NIO_EVENT_LOOP_GROUP.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isConnected() {
        return false;
    }

    public com.tplink.smb.ecsp.transport.api.ChannelHandler getChannelHandler() {
        return this.getHandler();
    }

    public void reconnect() {
    }
}

