/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.protocol.DebugUtils;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.Client;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.Transporter;
import com.tplink.smb.ecsp.transport.api.TransporterType;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.netty.NettyTcpClient;
import com.tplink.smb.ecsp.transport.netty.NettyTcpServer;
import com.tplink.smb.ecsp.transport.netty.NettyUdpClient;
import com.tplink.smb.ecsp.transport.netty.NettyUdpServer;
import com.tplink.smb.ecsp.transport.netty.RttyNettyTcpClient;
import com.tplink.smb.ecsp.transport.netty.RttyNettyTcpServer;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Map;

public class NettyTransporter
implements Transporter {
    private static final PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;

    public Server bind(URL url, ChannelHandler handler) throws RemotingException {
        switch (TransporterType.fromString((String)url.getProtocol())) {
            case UDP: {
                return new NettyUdpServer(url, handler);
            }
            case RTTY: {
                return new RttyNettyTcpServer(url, handler);
            }
        }
        return new NettyTcpServer(url, handler);
    }

    public Client connect(URL url, ChannelHandler handler) throws RemotingException {
        switch (TransporterType.fromString((String)url.getProtocol())) {
            case UDP: {
                return new NettyUdpClient(url, handler);
            }
            case RTTY: {
                return new RttyNettyTcpClient(url, handler);
            }
        }
        return new NettyTcpClient(url, handler);
    }

    public long usedHeapMemory() {
        return allocator.metric().usedHeapMemory();
    }

    public long usedDirectMemory() {
        return allocator.metric().usedDirectMemory();
    }

    public void setMaskMessageMap(Map<String, Map<String, PIIMaskStrategy>> maskMessageMap) {
        DebugUtils.setMaskMessageMap(maskMessageMap);
    }
}

