/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.util.NetUtils;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.CodecTypeEnum;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.TransConstants;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.security.SslContexts;
import com.tplink.smb.ecsp.transport.api.transport.AbstractServer;
import com.tplink.smb.ecsp.transport.api.util.UrlUtils;
import com.tplink.smb.ecsp.transport.netty.EcspLengthFrameDecoder;
import com.tplink.smb.ecsp.transport.netty.NettyCodecAdapter;
import com.tplink.smb.ecsp.transport.netty.NettyEventLoopFactory;
import com.tplink.smb.ecsp.transport.netty.NettyTcpServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpServer
extends AbstractServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(NettyTcpServer.class);
    private Map<String, com.tplink.smb.ecsp.transport.api.Channel> channels;
    private ServerBootstrap tcpBootstrap;
    private Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventExecutorGroup executorGroup;
    private SSLContext serverSslContext;
    private ExecutorService kickExecutorService;

    NettyTcpServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    protected void doOpen() {
        NettyTcpServerHandler nettyTcpServerHandler = new NettyTcpServerHandler(this.getUrl(), (ChannelHandler)this);
        this.channels = nettyTcpServerHandler.getChannels();
        ChannelFuture channelFuture = this.doOpenTcpServer(nettyTcpServerHandler);
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    private ChannelFuture doOpenTcpServer(final NettyTcpServerHandler nettyTcpServerHandler) {
        this.tcpBootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "netty-tcp-server-boss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getParameter("io-threads", TransConstants.DEFAULT_IO_THREADS), "netty-tcp-server-worker");
        this.executorGroup = new DefaultEventExecutorGroup(this.getUrl().getParameter("executor-threads", TransConstants.DEFAULT_EXECUTOR_THREADS), (ThreadFactory)new DefaultThreadFactory("tcp-message-executor"), this.getUrl().getParameter("executor-queue-size", 200000), RejectedExecutionHandlers.reject());
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.tcpBootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).option(ChannelOption.SO_BACKLOG, (Object)this.getUrl().getParameter("backlog", 1024))).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.IP_TOS, (Object)160).childOption(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.tcpBootstrap.childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                NettyTcpServer.this.initSslHandlerIfNeed(ch);
                ChannelPipeline pipeline = ch.pipeline();
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyTcpServer.this.getUrl(), (ChannelHandler)NettyTcpServer.this);
                int maxFrameLength = NettyTcpServer.this.getUrl().getParameter("max-frame-length", 0x100000);
                pipeline.addLast("length-filed-decoder", (io.netty.channel.ChannelHandler)new EcspLengthFrameDecoder(maxFrameLength, 0, 4, 0, 4));
                pipeline.addLast("decoder", adapter.getDefaultDecoder());
                String codecType = NettyTcpServer.this.getUrl().getParameter("codec", CodecTypeEnum.ECSP.getType());
                CodecTypeEnum codecTypeEnum = CodecTypeEnum.getByType((String)codecType);
                if (CodecTypeEnum.FILE.equals((Object)codecTypeEnum)) {
                    pipeline.addLast("encoder", adapter.getFileEncoder());
                } else {
                    pipeline.addLast("length-filed-encoder", (io.netty.channel.ChannelHandler)new LengthFieldPrepender(4));
                    pipeline.addLast("encoder", adapter.getDefaultEncoder());
                }
                NettyTcpServer.this.initIdleStateHandlerIfNeed(ch);
                ch.pipeline().addLast(NettyTcpServer.this.executorGroup, "handler", (io.netty.channel.ChannelHandler)nettyTcpServerHandler);
            }
        });
        return this.tcpBootstrap.bind((SocketAddress)this.getBindAddress());
    }

    private void initSslHandlerIfNeed(SocketChannel ch) {
        if (this.getUrl().getParameter("ssl-enabled", false)) {
            if (this.serverSslContext == null) {
                this.serverSslContext = SslContexts.buildSslContext((String)this.getUrl().getParameter("ssl-cert"), (String)this.getUrl().getParameter("ssl-cert-pwd"), (String)this.getUrl().getParameter("ssl-keystore"), (String)this.getUrl().getParameter("ssl-keystore-pwd"), (String)this.getUrl().getParameter("ssl-protocol", "TLSv1.2"));
            }
            if (this.serverSslContext == null) {
                log.warn("create serverSSLContext error, protocol:{}, port: {}", (Object)this.getUrl().getProtocol(), (Object)this.getUrl().getPort());
                return;
            }
            SSLEngine sslEngine = this.serverSslContext.createSSLEngine();
            if (this.getUrl().getParameter("tls-1.3-enable", false)) {
                sslEngine.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.3"});
            } else {
                sslEngine.setEnabledProtocols(new String[]{"TLSv1.2"});
            }
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.getUrl().getParameter("ssl-client-auth", false));
            SslHandler sslHandler = new SslHandler(sslEngine);
            sslHandler.setHandshakeTimeoutMillis(30000L);
            log.trace("ssl enabled Protocols: {}", (Object)Arrays.toString(sslEngine.getEnabledProtocols()));
            ch.pipeline().addFirst("negotiation", (io.netty.channel.ChannelHandler)sslHandler);
        }
    }

    private void initIdleStateHandlerIfNeed(SocketChannel ch) {
        if (this.canHandleIdle()) {
            int idleTimeout = UrlUtils.getIdleTimeout((URL)this.getUrl());
            ch.pipeline().addLast("server-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS));
        }
    }

    public Single<Boolean> send(Object message, boolean sent) {
        log.warn("tcp server do not support send message without channel. local address = {}", (Object)this.getLocalAddress());
        return Single.error((Throwable)new RemotingException(this.getLocalAddress(), null, "tcp server do not support send message without channel."));
    }

    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.getChannels().forEach(channel1 -> {
                try {
                    channel1.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.tcpBootstrap != null) {
                this.bossGroup.shutdownGracefully();
                this.workerGroup.shutdownGracefully();
                this.executorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
            if (this.kickExecutorService != null) {
                this.kickExecutorService.shutdown();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<com.tplink.smb.ecsp.transport.api.Channel> getChannels() {
        HashSet<com.tplink.smb.ecsp.transport.api.Channel> chs = new HashSet<com.tplink.smb.ecsp.transport.api.Channel>();
        this.channels.values().forEach(channel1 -> {
            if (channel1.isConnected()) {
                chs.add((com.tplink.smb.ecsp.transport.api.Channel)channel1);
            } else {
                this.channels.remove(NetUtils.toAddressString((InetSocketAddress)channel1.getRemoteAddress()));
            }
        });
        return chs;
    }

    public com.tplink.smb.ecsp.transport.api.Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }

    public int getConnections() {
        return this.channels != null ? this.channels.size() : 0;
    }

    public void kickChannels(int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        this.startClose();
        if (this.kickExecutorService == null) {
            this.kickExecutorService = Executors.newSingleThreadExecutor();
        }
        this.kickExecutorService.execute(() -> this.doBatchKickChannels(kickBatchNum, kickIntervalMs, restTimeMs));
    }

    private void doBatchKickChannels(int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        int kickNum = 0;
        Iterator<Map.Entry<String, com.tplink.smb.ecsp.transport.api.Channel>> it = this.channels.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry<String, com.tplink.smb.ecsp.transport.api.Channel> channelEntry = it.next();
                if (channelEntry.getValue().isConnected()) {
                    channelEntry.getValue().close();
                    ++kickNum;
                }
                it.remove();
                if (kickNum >= kickBatchNum) {
                    log.debug("batch kick {} devices done, remain = {}, rest {}ms", new Object[]{kickNum, this.channels.size(), restTimeMs});
                    Thread.sleep(restTimeMs);
                    kickNum = 0;
                } else {
                    Thread.sleep(kickIntervalMs);
                }
                if (!this.channels.isEmpty()) continue;
                log.info("kick all channels done, wait graceful shutdown this server...");
                this.kickExecutorService.shutdownNow();
                this.kickExecutorService = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean canHandleIdle() {
        return true;
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public ChannelHandler getChannelHandler() {
        return this.getHandler();
    }
}

