/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import io.netty.handler.traffic.GlobalChannelTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyGlobalTrafficShapingHandler
extends GlobalChannelTrafficShapingHandler {
    private static final Logger log = LoggerFactory.getLogger(NettyGlobalTrafficShapingHandler.class);
    private final int bindPort;
    private Long throughputWrittenByte = 0L;
    private Long throughputReadByte = 0L;

    NettyGlobalTrafficShapingHandler(int bindPort, ScheduledExecutorService executor, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(executor, writeLimit, readLimit, 0L, 0L, checkInterval, maxTime);
        this.bindPort = bindPort;
    }

    protected void doAccounting(TrafficCounter counter) {
        for (TrafficCounter tc : this.channelTrafficCounters()) {
            this.throughputWrittenByte = this.throughputWrittenByte + (tc.getRealWriteThroughput() >> 10);
            this.throughputReadByte = this.throughputReadByte + (tc.lastReadThroughput() >> 10);
        }
        log.trace("{} QueuesSize: {}, WrittenThroughputByte: {} KB, ReadThroughputByte: {} KB", new Object[]{this.toString(), this.queuesSize(), this.throughputWrittenByte, this.throughputReadByte});
        ServerMonitor.getNettyTrafficQueueSize((int)this.bindPort).getAndSet(this.queuesSize());
        ServerMonitor.getNettyTrafficWriteThroughput((int)this.bindPort).getAndSet(this.throughputWrittenByte);
        ServerMonitor.getNettyTrafficReadThroughput((int)this.bindPort).getAndSet(this.throughputReadByte);
        this.throughputWrittenByte = 0L;
        this.throughputReadByte = 0L;
        super.doAccounting(counter);
    }
}

