/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.protocol.packet.EcspPacket;
import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.reactivex.Single;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyFutureTransformer {
    private static final Logger log = LoggerFactory.getLogger(NettyFutureTransformer.class);

    private NettyFutureTransformer() {
    }

    static Single<Boolean> transformNettySendMessage(@NonNull Channel channel, @NonNull URL url, @NonNull Object message, boolean sent) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!sent) {
            NettyFutureTransformer.send(channel, message);
            return Single.just((Object)true);
        }
        ReplaySubject sendResultSubject = ReplaySubject.create();
        NettyFutureTransformer.sendWithSubject(channel, message, (Subject<Boolean>)sendResultSubject);
        int timeout = url.getPositiveParameter("timeout", 30000);
        return sendResultSubject.firstOrError().timeout((long)timeout, TimeUnit.MILLISECONDS);
    }

    private static void send(@NonNull Channel channel, @NonNull Object message) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        NettyFutureTransformer.sendWithSubject(channel, message, null);
    }

    private static void sendWithSubject(@NonNull Channel channel, @NonNull Object message, Subject<Boolean> subject) {
        Timer writeTimer;
        long messageLength;
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        boolean subjectNotNull = Objects.nonNull(subject);
        long startTime = System.nanoTime();
        if (!channel.isWritable()) {
            ChannelOutboundBuffer outboundBuffer = channel.unsafe().outboundBuffer();
            if (outboundBuffer != null) {
                log.warn("channel {} unWritable, bytes that can be written out is: {}.", (Object)channel, (Object)outboundBuffer.nioBufferSize());
                ServerMonitor.incHighWaterMarkCounter();
            } else {
                log.warn("channel {} unWritable, and outboundBuffer is null.", (Object)channel);
                ServerMonitor.incChannelDisconnectCounter();
            }
            NettyFutureTransformer.subjectWriteResult(subject, subjectNotNull, false);
            return;
        }
        if (message instanceof EcspPacket) {
            messageLength = ((EcspPacket)message).getLengthField();
            writeTimer = ServerMonitor.getServerWriteEcspTimer();
        } else {
            messageLength = message instanceof byte[] ? (long)((byte[])message).length : 0L;
            writeTimer = ServerMonitor.getServerWriteFileTimer();
        }
        channel.writeAndFlush(message).addListener(future -> {
            if (future.isCancelled()) {
                log.info("send message isCancelled, bytes length = {}", (Object)messageLength);
                ServerMonitor.incWriteTaskCanceledCounter();
                NettyFutureTransformer.subjectWriteResult(subject, subjectNotNull, false);
                return;
            }
            if (future.isSuccess()) {
                writeTimer.record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                NettyFutureTransformer.subjectWriteResult(subject, subjectNotNull, true);
                return;
            }
            Throwable t = future.cause();
            log.warn("send message fail, bytes length = {}, throwable: {}", (Object)messageLength, (Object)t);
            if (t != null && subjectNotNull) {
                if (t instanceof TimeoutException) {
                    ServerMonitor.incWriteTimeoutExceptionCounter();
                } else {
                    ServerMonitor.incWriteExceptionCounter();
                }
                subject.onError(t);
            }
        });
    }

    private static void subjectWriteResult(Subject<Boolean> subject, boolean subjectNotNull, boolean writeResult) {
        if (subjectNotNull) {
            subject.onNext((Object)writeResult);
        }
    }
}

