/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.transport.netty.socket.EcspNioServerSocketChannel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;

public class NettyEventLoopFactory {
    public static EventLoopGroup eventLoopGroup(int threads, String threadFactoryName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadFactoryName, true);
        return NettyEventLoopFactory.useEpoll() ? new EpollEventLoopGroup(threads, (ThreadFactory)threadFactory) : new NioEventLoopGroup(threads, (ThreadFactory)threadFactory);
    }

    public static Class<? extends SocketChannel> socketChannelClass() {
        return NettyEventLoopFactory.useEpoll() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> datagramChannelClass() {
        return NettyEventLoopFactory.useEpoll() ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    public static Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return NettyEventLoopFactory.useEpoll() ? EpollServerSocketChannel.class : EcspNioServerSocketChannel.class;
    }

    private static boolean useEpoll() {
        String osName = System.getProperty("os.name");
        boolean isLinuxPlatform = osName.toLowerCase(Locale.ROOT).contains("linux");
        return isLinuxPlatform && Epoll.isAvailable();
    }

    private NettyEventLoopFactory() {
    }
}

