/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.transport.AbstractEndpoint;
import com.tplink.smb.ecsp.transport.netty.NettyCodecAdapter;
import com.tplink.smb.ecsp.transport.netty.NettyFutureTransformer;
import com.tplink.smb.ecsp.transport.netty.NettyTcpClient;
import io.netty.channel.ChannelPipeline;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyChannel
extends AbstractEndpoint
implements Channel {
    private static final Logger log = LoggerFactory.getLogger(NettyChannel.class);
    private static final ConcurrentMap<io.netty.channel.Channel, NettyChannel> CHANNEL_MAP = new ConcurrentHashMap<io.netty.channel.Channel, NettyChannel>();
    private final io.netty.channel.Channel channel;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final AtomicBoolean reinitDone = new AtomicBoolean(false);
    private final AtomicBoolean reiniting = new AtomicBoolean(false);

    private NettyChannel(io.netty.channel.Channel channel, URL url, ChannelHandler handler) {
        super(url, handler);
        if (channel == null) {
            throw new IllegalArgumentException("netty channel == null;");
        }
        this.channel = channel;
    }

    static NettyChannel getOrAddChannel(io.netty.channel.Channel ch, URL url, ChannelHandler handler) {
        if (ch == null) {
            return null;
        }
        NettyChannel ret = (NettyChannel)((Object)CHANNEL_MAP.get(ch));
        if (ret == null) {
            NettyChannel nettyChannel = new NettyChannel(ch, url, handler);
            if (ch.isActive()) {
                nettyChannel.markActive(true);
                ret = CHANNEL_MAP.putIfAbsent(ch, nettyChannel);
            }
            if (ret == null) {
                ret = nettyChannel;
            }
        }
        return ret;
    }

    static void removeChannelIfDisconnected(io.netty.channel.Channel ch) {
        NettyChannel nettyChannel;
        if (ch != null && !ch.isActive() && (nettyChannel = (NettyChannel)((Object)CHANNEL_MAP.remove(ch))) != null) {
            nettyChannel.markActive(false);
        }
    }

    static void removeChannel(io.netty.channel.Channel ch) {
        NettyChannel nettyChannel;
        if (ch != null && (nettyChannel = (NettyChannel)((Object)CHANNEL_MAP.remove(ch))) != null) {
            nettyChannel.markActive(false);
        }
    }

    public boolean isConnected() {
        return !this.isClosed() && this.active.get();
    }

    boolean isActive() {
        return this.active.get();
    }

    void markActive(boolean isActive) {
        this.active.set(isActive);
    }

    public synchronized Single<Boolean> send(Object message, boolean sent) {
        if (this.isClosed()) {
            return Single.error((Throwable)new RemotingException((Channel)this, "failed to send message " + (message == null ? "" : message.getClass().getName()) + ", cause: Channel closed. channel: " + this.getLocalAddress() + " -> " + this.getRemoteAddress()));
        }
        if (this.reiniting.get()) {
            return Single.error((Throwable)new RemotingException((Channel)this, "failed to send message " + (message == null ? "" : message.getClass().getName()) + ", cause: reiniting for channel: " + this.getLocalAddress() + " -> " + this.getRemoteAddress()));
        }
        return NettyFutureTransformer.transformNettySendMessage(this.channel, this.getUrl(), message, sent);
    }

    public synchronized boolean reinitRc4Handler(byte[] key) {
        if (this.isClosed()) {
            log.info("failed to reInit Handlers, cause: channel {} -> {} is closed", (Object)this.getLocalAddress(), (Object)this.getRemoteAddress());
            return false;
        }
        if (this.reinitDone.get()) {
            log.debug("channel {} -> {} has reinit ok, return true", (Object)this.getLocalAddress(), (Object)this.getRemoteAddress());
            return true;
        }
        try {
            this.reiniting.set(true);
            log.debug("start reinit rc4 handler for channel {} -> {} ", (Object)this.getLocalAddress(), (Object)this.getRemoteAddress());
            ChannelPipeline pipeline = this.channel.pipeline();
            NettyCodecAdapter adapter = new NettyCodecAdapter(this.getUrl(), this.getChannelHandler());
            pipeline.replace("decoder", "decoder", adapter.getDefaultDecoder());
            pipeline.replace("length-filed-decoder", "length-filed-decoder", adapter.getEncryptDecoder(key));
            pipeline.replace("encoder", "encoder", adapter.getDefaultEncoder());
            pipeline.replace("length-filed-encoder", "length-filed-encoder", adapter.getEncryptEncoder(key));
        }
        catch (Exception e) {
            this.reiniting.set(false);
            NettyChannel.removeChannelIfDisconnected(this.channel);
            log.info("reInit Handlers for channel {} -> {} error: {}", new Object[]{this.getLocalAddress(), this.getRemoteAddress(), e.getMessage(), e});
            return false;
        }
        this.reiniting.set(false);
        this.reinitDone.set(true);
        return true;
    }

    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            log.debug("Close netty channel {}", (Object)this.channel);
            this.channel.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NettyTcpClient) {
            NettyTcpClient client = (NettyTcpClient)((Object)obj);
            return this.channel.equals(client.getNettyChannel());
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NettyChannel other = (NettyChannel)((Object)obj);
        if (this.channel == null) {
            return other.channel == null;
        }
        return this.channel.equals(other.channel);
    }

    public ChannelHandler getChannelHandler() {
        return this.getHandler();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public String toString() {
        return this.getLocalAddress() + " -> " + this.getRemoteAddress();
    }
}

