/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.transport.api.monitor.ServerMonitor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcspLengthFrameDecoder
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(EcspLengthFrameDecoder.class);
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private long tooLongFrameLength;
    private long bytesToDiscard;

    EcspLengthFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        this(maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, true);
    }

    private EcspLengthFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        this(ByteOrder.BIG_ENDIAN, maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, failFast);
    }

    private EcspLengthFrameDecoder(ByteOrder byteOrder, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder");
        }
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength");
        ObjectUtil.checkPositiveOrZero((int)lengthFieldOffset, (String)"lengthFieldOffset");
        ObjectUtil.checkPositiveOrZero((int)initialBytesToStrip, (String)"initialBytesToStrip");
        if (lengthFieldOffset > maxFrameLength - lengthFieldLength) {
            throw new IllegalArgumentException("maxFrameLength (" + maxFrameLength + ") must be equal to or greater than lengthFieldOffset (" + lengthFieldOffset + ") + lengthFieldLength (" + lengthFieldLength + ").");
        }
        this.byteOrder = byteOrder;
        this.maxFrameLength = maxFrameLength;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
        this.lengthFieldEndOffset = lengthFieldOffset + lengthFieldLength;
        this.initialBytesToStrip = initialBytesToStrip;
        this.failFast = failFast;
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        Object decoded = this.decode(ctx, in);
        if (decoded != null) {
            out.add(decoded);
        }
    }

    private Object decode(ChannelHandlerContext ctx, ByteBuf in) {
        if (this.discardingTooLongFrame) {
            long discardBytes = this.bytesToDiscard;
            int localBytesToDiscard = (int)Math.min(discardBytes, (long)in.readableBytes());
            in.skipBytes(localBytesToDiscard);
            this.bytesToDiscard = discardBytes -= (long)localBytesToDiscard;
            this.failIfNecessary(ctx, false);
        }
        if (in.readableBytes() < this.lengthFieldEndOffset) {
            log.debug("Buf readable bytes {} is too little, wait for next encrypt frame", (Object)in.readableBytes());
            ServerMonitor.incTcpPacketDisassembleDecodeFailedCounter();
            return null;
        }
        int actualLengthFieldOffset = in.readerIndex() + this.lengthFieldOffset;
        long frameLength = this.getUnadjustedFrameLength(in, actualLengthFieldOffset, this.lengthFieldLength, this.byteOrder);
        if (frameLength < 0L) {
            in.skipBytes(this.lengthFieldEndOffset);
            ServerMonitor.incTcpDecodeFailedCounter();
            log.warn("negative pre-adjustment length field: {}", (Object)frameLength);
            ctx.channel().close();
            return null;
        }
        if ((frameLength += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
            in.skipBytes(this.lengthFieldEndOffset);
            ServerMonitor.incTcpDecodeFailedCounter();
            log.warn("Adjusted frame length ({}) is less than lengthFieldEndOffset: {}", (Object)frameLength, (Object)this.lengthFieldEndOffset);
            ctx.channel().close();
            return null;
        }
        if (frameLength > (long)this.maxFrameLength) {
            long discard = frameLength - (long)in.readableBytes();
            this.tooLongFrameLength = frameLength;
            if (discard >= 0L) {
                this.discardingTooLongFrame = true;
                this.bytesToDiscard = discard;
                in.skipBytes(in.readableBytes());
            } else {
                in.skipBytes((int)frameLength);
            }
            this.failIfNecessary(ctx, true);
            return null;
        }
        int frameLengthInt = (int)frameLength;
        if (in.readableBytes() < frameLengthInt) {
            return null;
        }
        if (this.initialBytesToStrip > frameLengthInt) {
            in.skipBytes((int)frameLength);
            ServerMonitor.incTcpDecodeFailedCounter();
            log.warn("Adjusted frame length ({}) is less than initialBytesToStrip: {}", (Object)frameLength, (Object)this.initialBytesToStrip);
            ctx.channel().close();
            return null;
        }
        in.skipBytes(this.initialBytesToStrip);
        int readerIndex = in.readerIndex();
        int actualFrameLength = frameLengthInt - this.initialBytesToStrip;
        ByteBuf frame = this.extractFrame(in, readerIndex, actualFrameLength);
        in.readerIndex(readerIndex + actualFrameLength);
        return frame;
    }

    private long getUnadjustedFrameLength(ByteBuf buf, int offset, int length, ByteOrder order) {
        long frameLength;
        buf = buf.order(order);
        if (length == 4) {
            frameLength = buf.getUnsignedInt(offset);
        } else {
            log.info("unsupported lengthFieldLength: {}, expected: 4", (Object)this.lengthFieldLength);
            frameLength = -1L;
        }
        return frameLength;
    }

    private void failIfNecessary(ChannelHandlerContext ctx, boolean firstDetectionOfTooLongFrame) {
        if (this.bytesToDiscard != 0L) {
            if (this.failFast && firstDetectionOfTooLongFrame) {
                this.fail(ctx, this.tooLongFrameLength);
            }
        } else {
            long localTooLongFrameLength = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            if (!this.failFast || firstDetectionOfTooLongFrame) {
                this.fail(ctx, localTooLongFrameLength);
            }
        }
    }

    private ByteBuf extractFrame(ByteBuf buffer, int index, int length) {
        return buffer.retainedSlice(index, length);
    }

    private void fail(ChannelHandlerContext ctx, long frameLength) {
        ServerMonitor.incTcpDecodeFailedCounter();
        if (frameLength > 0L) {
            log.warn("Adjusted frame length exceeds {} : {} - discarded", (Object)this.maxFrameLength, (Object)frameLength);
        } else {
            log.warn("Adjusted frame length exceeds {} - discarded", (Object)this.maxFrameLength);
        }
        ctx.channel().close();
    }
}

