/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.subsystem.api.internal.dto;

import com.tplink.smb.omada.global.common.vaild.NumberSet;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class IPAccessRuleItemDTO {
    private String id;
    private String centralId;
    @NotNull
    @NumberSet(value={0, 1, 2}, message="Ip Access Rule parameter [ipAccessType] should be 0 or 1 or 2")
    private Integer ipAccessType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid single ip address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid single ip address.") String singleIpAddress;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid single subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid single subnet mask.") String singleSubnetMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range start address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range start address.") String ipRangeStart;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range end address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range end address.") String ipRangeEnd;
    private Boolean currentIp;
    @NotNull
    private String description;

    public static IPAccessRuleItemDTOBuilder builder() {
        return new IPAccessRuleItemDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getCentralId() {
        return this.centralId;
    }

    public Integer getIpAccessType() {
        return this.ipAccessType;
    }

    public String getSingleIpAddress() {
        return this.singleIpAddress;
    }

    public String getSingleSubnetMask() {
        return this.singleSubnetMask;
    }

    public String getIpRangeStart() {
        return this.ipRangeStart;
    }

    public String getIpRangeEnd() {
        return this.ipRangeEnd;
    }

    public Boolean getCurrentIp() {
        return this.currentIp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCentralId(String centralId) {
        this.centralId = centralId;
    }

    public void setIpAccessType(Integer ipAccessType) {
        this.ipAccessType = ipAccessType;
    }

    public void setSingleIpAddress(String singleIpAddress) {
        this.singleIpAddress = singleIpAddress;
    }

    public void setSingleSubnetMask(String singleSubnetMask) {
        this.singleSubnetMask = singleSubnetMask;
    }

    public void setIpRangeStart(String ipRangeStart) {
        this.ipRangeStart = ipRangeStart;
    }

    public void setIpRangeEnd(String ipRangeEnd) {
        this.ipRangeEnd = ipRangeEnd;
    }

    public void setCurrentIp(Boolean currentIp) {
        this.currentIp = currentIp;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "IPAccessRuleItemDTO(id=" + this.getId() + ", centralId=" + this.getCentralId() + ", ipAccessType=" + this.getIpAccessType() + ", singleIpAddress=" + this.getSingleIpAddress() + ", singleSubnetMask=" + this.getSingleSubnetMask() + ", ipRangeStart=" + this.getIpRangeStart() + ", ipRangeEnd=" + this.getIpRangeEnd() + ", currentIp=" + this.getCurrentIp() + ", description=" + this.getDescription() + ")";
    }

    public IPAccessRuleItemDTO() {
    }

    public IPAccessRuleItemDTO(String id, String centralId, Integer ipAccessType, String singleIpAddress, String singleSubnetMask, String ipRangeStart, String ipRangeEnd, Boolean currentIp, String description) {
        this.id = id;
        this.centralId = centralId;
        this.ipAccessType = ipAccessType;
        this.singleIpAddress = singleIpAddress;
        this.singleSubnetMask = singleSubnetMask;
        this.ipRangeStart = ipRangeStart;
        this.ipRangeEnd = ipRangeEnd;
        this.currentIp = currentIp;
        this.description = description;
    }

    public static class IPAccessRuleItemDTOBuilder {
        private String id;
        private String centralId;
        private Integer ipAccessType;
        private String singleIpAddress;
        private String singleSubnetMask;
        private String ipRangeStart;
        private String ipRangeEnd;
        private Boolean currentIp;
        private String description;

        IPAccessRuleItemDTOBuilder() {
        }

        public IPAccessRuleItemDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public IPAccessRuleItemDTOBuilder centralId(String centralId) {
            this.centralId = centralId;
            return this;
        }

        public IPAccessRuleItemDTOBuilder ipAccessType(Integer ipAccessType) {
            this.ipAccessType = ipAccessType;
            return this;
        }

        public IPAccessRuleItemDTOBuilder singleIpAddress(String singleIpAddress) {
            this.singleIpAddress = singleIpAddress;
            return this;
        }

        public IPAccessRuleItemDTOBuilder singleSubnetMask(String singleSubnetMask) {
            this.singleSubnetMask = singleSubnetMask;
            return this;
        }

        public IPAccessRuleItemDTOBuilder ipRangeStart(String ipRangeStart) {
            this.ipRangeStart = ipRangeStart;
            return this;
        }

        public IPAccessRuleItemDTOBuilder ipRangeEnd(String ipRangeEnd) {
            this.ipRangeEnd = ipRangeEnd;
            return this;
        }

        public IPAccessRuleItemDTOBuilder currentIp(Boolean currentIp) {
            this.currentIp = currentIp;
            return this;
        }

        public IPAccessRuleItemDTOBuilder description(String description) {
            this.description = description;
            return this;
        }

        public IPAccessRuleItemDTO build() {
            return new IPAccessRuleItemDTO(this.id, this.centralId, this.ipAccessType, this.singleIpAddress, this.singleSubnetMask, this.ipRangeStart, this.ipRangeEnd, this.currentIp, this.description);
        }

        public String toString() {
            return "IPAccessRuleItemDTO.IPAccessRuleItemDTOBuilder(id=" + this.id + ", centralId=" + this.centralId + ", ipAccessType=" + this.ipAccessType + ", singleIpAddress=" + this.singleIpAddress + ", singleSubnetMask=" + this.singleSubnetMask + ", ipRangeStart=" + this.ipRangeStart + ", ipRangeEnd=" + this.ipRangeEnd + ", currentIp=" + this.currentIp + ", description=" + this.description + ")";
        }
    }
}

