/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.subsystem.api.internal.dto;

import com.tplink.smb.omada.global.common.vaild.NumberSet;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class IPAccessRuleDTO {
    private String id;
    private String centralId;
    @NotNull
    @NumberSet(value={0, 1, 2}, message="Ip Access Rule parameter [ipAccessType] should be 0 or 1 or 2")
    private Integer ipAccessType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid single ip address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid single ip address.") String singleIpAddress;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid single subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid single subnet mask.") String singleSubnetMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range start address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range start address.") String ipRangeStart;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range end address.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range end address.") String ipRangeEnd;
    private String protocolVersion;
    private String description;

    public static IPAccessRuleDTOBuilder builder() {
        return new IPAccessRuleDTOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getCentralId() {
        return this.centralId;
    }

    public Integer getIpAccessType() {
        return this.ipAccessType;
    }

    public String getSingleIpAddress() {
        return this.singleIpAddress;
    }

    public String getSingleSubnetMask() {
        return this.singleSubnetMask;
    }

    public String getIpRangeStart() {
        return this.ipRangeStart;
    }

    public String getIpRangeEnd() {
        return this.ipRangeEnd;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCentralId(String centralId) {
        this.centralId = centralId;
    }

    public void setIpAccessType(Integer ipAccessType) {
        this.ipAccessType = ipAccessType;
    }

    public void setSingleIpAddress(String singleIpAddress) {
        this.singleIpAddress = singleIpAddress;
    }

    public void setSingleSubnetMask(String singleSubnetMask) {
        this.singleSubnetMask = singleSubnetMask;
    }

    public void setIpRangeStart(String ipRangeStart) {
        this.ipRangeStart = ipRangeStart;
    }

    public void setIpRangeEnd(String ipRangeEnd) {
        this.ipRangeEnd = ipRangeEnd;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "IPAccessRuleDTO(id=" + this.getId() + ", centralId=" + this.getCentralId() + ", ipAccessType=" + this.getIpAccessType() + ", singleIpAddress=" + this.getSingleIpAddress() + ", singleSubnetMask=" + this.getSingleSubnetMask() + ", ipRangeStart=" + this.getIpRangeStart() + ", ipRangeEnd=" + this.getIpRangeEnd() + ", protocolVersion=" + this.getProtocolVersion() + ", description=" + this.getDescription() + ")";
    }

    public IPAccessRuleDTO() {
    }

    public IPAccessRuleDTO(String id, String centralId, Integer ipAccessType, String singleIpAddress, String singleSubnetMask, String ipRangeStart, String ipRangeEnd, String protocolVersion, String description) {
        this.id = id;
        this.centralId = centralId;
        this.ipAccessType = ipAccessType;
        this.singleIpAddress = singleIpAddress;
        this.singleSubnetMask = singleSubnetMask;
        this.ipRangeStart = ipRangeStart;
        this.ipRangeEnd = ipRangeEnd;
        this.protocolVersion = protocolVersion;
        this.description = description;
    }

    public static class IPAccessRuleDTOBuilder {
        private String id;
        private String centralId;
        private Integer ipAccessType;
        private String singleIpAddress;
        private String singleSubnetMask;
        private String ipRangeStart;
        private String ipRangeEnd;
        private String protocolVersion;
        private String description;

        IPAccessRuleDTOBuilder() {
        }

        public IPAccessRuleDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public IPAccessRuleDTOBuilder centralId(String centralId) {
            this.centralId = centralId;
            return this;
        }

        public IPAccessRuleDTOBuilder ipAccessType(Integer ipAccessType) {
            this.ipAccessType = ipAccessType;
            return this;
        }

        public IPAccessRuleDTOBuilder singleIpAddress(String singleIpAddress) {
            this.singleIpAddress = singleIpAddress;
            return this;
        }

        public IPAccessRuleDTOBuilder singleSubnetMask(String singleSubnetMask) {
            this.singleSubnetMask = singleSubnetMask;
            return this;
        }

        public IPAccessRuleDTOBuilder ipRangeStart(String ipRangeStart) {
            this.ipRangeStart = ipRangeStart;
            return this;
        }

        public IPAccessRuleDTOBuilder ipRangeEnd(String ipRangeEnd) {
            this.ipRangeEnd = ipRangeEnd;
            return this;
        }

        public IPAccessRuleDTOBuilder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public IPAccessRuleDTOBuilder description(String description) {
            this.description = description;
            return this;
        }

        public IPAccessRuleDTO build() {
            return new IPAccessRuleDTO(this.id, this.centralId, this.ipAccessType, this.singleIpAddress, this.singleSubnetMask, this.ipRangeStart, this.ipRangeEnd, this.protocolVersion, this.description);
        }

        public String toString() {
            return "IPAccessRuleDTO.IPAccessRuleDTOBuilder(id=" + this.id + ", centralId=" + this.centralId + ", ipAccessType=" + this.ipAccessType + ", singleIpAddress=" + this.singleIpAddress + ", singleSubnetMask=" + this.singleSubnetMask + ", ipRangeStart=" + this.ipRangeStart + ", ipRangeEnd=" + this.ipRangeEnd + ", protocolVersion=" + this.protocolVersion + ", description=" + this.description + ")";
        }
    }
}

