/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.core.eventcenter.a;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.eventcenter.api.EventV2;
import com.tplink.smb.eventcenter.api.GenericEventHandler;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.EapInsightInformDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.OsgInsightInformDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.OswInsightInformDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.h.d;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.insight.a.a;
import com.tplink.smb.omada.insight.api.internal.eventcenter.DeviceInformDTO;
import com.tplink.smb.omada.insight.core.a.c;
import com.tplink.smb.omada.judgement.a.e;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class f
implements GenericEventHandler<EventV2<com.tplink.smb.omada.device.gateway.a.d.b.a>> {
    @Generated
    private static final Logger a = LogManager.getLogger(f.class);
    @Autowired
    private com.tplink.smb.omada.insight.a.a b;
    private Cache<String, Boolean> c = CacheBuilder.newBuilder().maximumSize(650L).expireAfterAccess(160L, TimeUnit.SECONDS).build();
    @Autowired
    private c d;
    @Autowired
    private com.tplink.smb.omada.insight.api.c.a e;
    @Autowired
    private e f;

    public void a(EventV2<com.tplink.smb.omada.device.gateway.a.d.b.a> event) {
        DeviceInformDTO<?> deviceInformDTO;
        if (!this.f.a("health") && !this.f.a("abnormal")) {
            return;
        }
        com.tplink.smb.omada.device.gateway.a.d.b.a deviceInform = (com.tplink.smb.omada.device.gateway.a.d.b.a)event.getMessage();
        try {
            deviceInformDTO = this.a(deviceInform);
        }
        catch (d e2) {
            String deviceType = Optional.ofNullable(deviceInform).map(com.tplink.smb.omada.device.gateway.a.d.b.a::d).orElse("");
            a.info("Failed to handle {} inform json because json exception.", (Object)deviceType, (Object)e2);
            this.b.a(deviceType, a.a.b);
            return;
        }
        if (Objects.isNull(deviceInformDTO)) {
            return;
        }
        if (!deviceInformDTO.validate()) {
            a.warn("fist transform error, omadacId: {}, siteId: {}", (Object)deviceInformDTO.getOmadacId(), (Object)deviceInformDTO.getSiteId());
            return;
        }
        a.debug("received device inform message from eventCenter: {}, omadacId = {}, siteId = {}", new Supplier[]{() -> PIIJacksonUtil.parseToStr((Object)event.getMessage()), () -> deviceInformDTO.getOmadacId(), () -> deviceInformDTO.getSiteId()});
        if (this.d(deviceInformDTO)) {
            return;
        }
        if (this.b(deviceInformDTO) || this.c(deviceInformDTO)) {
            return;
        }
        this.a(deviceInformDTO);
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)deviceInformDTO.getDeviceType());
        deviceInformDTO.setDeviceType(deviceTypeEnum.b());
        DomainEventBusHolder.getPublisher().publish(deviceInformDTO);
    }

    private void a(DeviceInformDTO deviceInformDTO) {
        this.e.a(deviceInformDTO.getOmadacId(), deviceInformDTO.getSiteId());
    }

    private boolean b(DeviceInformDTO deviceInformDTO) {
        if (EcspVersion.isEcspVersion1((String)deviceInformDTO.getEcspVersion())) {
            a.debug("skip publish domain inform for low version device {}", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.d((String)deviceInformDTO.getDeviceMac())});
            return true;
        }
        if (this.d.a(deviceInformDTO.getOmadacId(), deviceInformDTO.getSiteId()).booleanValue() && !deviceInformDTO.getSupportAnomaly().booleanValue()) {
            a.debug("skip publish domain inform for omadacId:{}, siteId: {} is pro and device {} does not support anomaly event", (Object)deviceInformDTO.getOmadacId(), (Object)deviceInformDTO.getSiteId(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceInformDTO.getDeviceMac()));
            return true;
        }
        return false;
    }

    private boolean c(DeviceInformDTO deviceInformDTO) {
        String timestampCacheKey = deviceInformDTO.getDeviceMac() + "-" + deviceInformDTO.getTimestamp();
        if (T.a((String)timestampCacheKey)) {
            return true;
        }
        if (Boolean.TRUE.equals(this.c.getIfPresent((Object)timestampCacheKey))) {
            a.debug("skip publish domain inform for {}, cause duplicate ", (Object)timestampCacheKey);
            return true;
        }
        this.c.put((Object)timestampCacheKey, (Object)Boolean.TRUE);
        return false;
    }

    private boolean d(DeviceInformDTO deviceInformDTO) {
        return System.currentTimeMillis() - deviceInformDTO.getTimestamp() > 60000L;
    }

    private DeviceInformDTO<?> a(com.tplink.smb.omada.device.gateway.a.d.b.a deviceInform) {
        DeviceInformDTO deviceInformDTO;
        switch (DeviceTypeEnum.b((String)deviceInform.d())) {
            case a: {
                deviceInformDTO = new EapInsightInformDTO().setInformBody((Object)((EapInformBody)x.a((Map)deviceInform.i(), EapInformBody.class)));
                break;
            }
            case b: {
                deviceInformDTO = new OsgInsightInformDTO().setInformBody((Object)((OsgInformBody)x.a((Map)deviceInform.i(), OsgInformBody.class)));
                break;
            }
            case c: {
                deviceInformDTO = new OswInsightInformDTO().setInformBody((Object)((OswInformBody)x.a((Map)deviceInform.i(), OswInformBody.class)));
                break;
            }
            case d: {
                a.info("skip olt inform.");
                return null;
            }
            default: {
                a.warn("unknown device type: {}, mac: {}", (Object)deviceInform.d(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceInform.e()));
                return null;
            }
        }
        deviceInformDTO.setEcspVersion(deviceInform.b());
        deviceInformDTO.setDeviceType(deviceInform.d());
        deviceInformDTO.setOmadacId(deviceInform.g());
        deviceInformDTO.setSiteId(deviceInform.h());
        deviceInformDTO.setDeviceMac(deviceInform.e());
        deviceInformDTO.setDeviceName(deviceInform.f());
        deviceInformDTO.setTimestamp(deviceInform.j());
        deviceInformDTO.setSupportAnomaly(deviceInform.n());
        if (Objects.nonNull(deviceInform.k())) {
            com.tplink.smb.omada.insight.api.internal.eventcenter.a oswInfo = new com.tplink.smb.omada.insight.api.internal.eventcenter.a();
            oswInfo.a(deviceInform.k().b());
            oswInfo.a(deviceInform.k().a());
            deviceInformDTO.setOswInfo(oswInfo);
        }
        a.debug("inform dto after transforming from device-gateway: {}", new Supplier[]{() -> PIIJacksonUtil.parseToStr((Object)deviceInformDTO)});
        return deviceInformDTO;
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((EventV2<com.tplink.smb.omada.device.gateway.a.d.b.a>)((EventV2)object));
    }
}

