/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.core.eventcenter.a;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.EapInsightInformDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osg.OsgInsightInformDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.OswInsightInformDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.a.a;
import com.tplink.smb.omada.insight.api.internal.eventcenter.DeviceInformDTO;
import com.tplink.smb.omada.insight.core.a.c;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class d
implements EventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    private a b;
    private static Cache<String, Boolean> c = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterAccess(160L, TimeUnit.SECONDS).build();
    @Autowired
    private c d;
    @Autowired
    private com.tplink.smb.omada.insight.api.c.a e;

    public void handleEvent(@Nonnull Event event) {
        DeviceInformDTO deviceInformDTO;
        DeviceTypeEnum quickFilterDeviceType = this.a(event.getFilterKey());
        try {
            if (quickFilterDeviceType == null) {
                return;
            }
            switch (quickFilterDeviceType) {
                case a: {
                    deviceInformDTO = (DeviceInformDTO)x.a((String)((String)event.getMessage()), EapInsightInformDTO.class);
                    break;
                }
                case c: {
                    deviceInformDTO = (DeviceInformDTO)x.a((String)((String)event.getMessage()), OswInsightInformDTO.class);
                    break;
                }
                case b: {
                    deviceInformDTO = (DeviceInformDTO)x.a((String)((String)event.getMessage()), OsgInsightInformDTO.class);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (com.tplink.smb.omada.common.h.d e2) {
            String deviceType = Optional.ofNullable(quickFilterDeviceType).map(DeviceTypeEnum::b).orElse("");
            a.info("Failed to handle {} inform json because json exception.", (Object)deviceType, (Object)e2);
            this.b.a(deviceType, a.a.b);
            return;
        }
        if (!deviceInformDTO.validate()) {
            a.warn("fist transform error, omadacId: {}, siteId: {}", (Object)deviceInformDTO.getOmadacId(), (Object)deviceInformDTO.getSiteId());
            return;
        }
        a.debug("received device inform message from eventCenter: {}, omadacId = {}, siteId = {}", new Object[]{event.getMessage(), deviceInformDTO.getOmadacId(), deviceInformDTO.getSiteId()});
        if (this.d(deviceInformDTO)) {
            return;
        }
        if (this.b(deviceInformDTO) || this.c(deviceInformDTO)) {
            return;
        }
        this.a(deviceInformDTO);
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)deviceInformDTO.getDeviceType());
        deviceInformDTO.setDeviceType(deviceTypeEnum.b());
        DomainEventBusHolder.getPublisher().publish((DomainEvent)deviceInformDTO);
    }

    private void a(DeviceInformDTO deviceInformDTO) {
        this.e.a(deviceInformDTO.getOmadacId(), deviceInformDTO.getSiteId());
    }

    private boolean b(DeviceInformDTO deviceInformDTO) {
        if (EcspVersion.isEcspVersion1((String)deviceInformDTO.getEcspVersion()) || !Boolean.TRUE.equals(deviceInformDTO.getSupportAnomaly())) {
            a.debug("skip publish domain inform for low version device {}", (Object)deviceInformDTO.getDeviceMac());
            return true;
        }
        return !Boolean.TRUE.equals(this.d.a(deviceInformDTO.getOmadacId(), deviceInformDTO.getSiteId()));
    }

    private boolean c(DeviceInformDTO deviceInformDTO) {
        String timestampCacheKey = deviceInformDTO.getDeviceMac() + "-" + deviceInformDTO.getTimestamp();
        if (T.a((String)timestampCacheKey)) {
            return true;
        }
        if (Boolean.TRUE.equals(c.getIfPresent((Object)timestampCacheKey))) {
            a.debug("skip publish domain inform for {}, cause duplicate ", (Object)timestampCacheKey);
            return true;
        }
        c.put((Object)timestampCacheKey, (Object)Boolean.TRUE);
        return false;
    }

    private boolean d(DeviceInformDTO deviceInformDTO) {
        return System.currentTimeMillis() - deviceInformDTO.getTimestamp() > 60000L;
    }

    @Nullable
    private DeviceTypeEnum a(String filterKey) {
        if (filterKey == null) {
            return null;
        }
        return DeviceTypeEnum.b((String)filterKey);
    }
}

