/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.port.mongo.a;

import com.mongodb.client.MongoCollection;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.dpi.api.internal.dto.DpiClientStatDTO;
import com.tplink.smb.omada.client.dpi.port.mongo.a.c;
import com.tplink.smb.omada.client.dpi.port.mongo.a.d;
import com.tplink.smb.omada.client.dpi.port.mongo.dpistat.DpiClientStatPO;
import com.tplink.smb.omada.client.dpi.port.mongo.h;
import com.tplink.smb.omada.common.mongo.repository.s;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public abstract class b<P extends DpiClientStatPO>
extends s<P>
implements h {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    protected MongoCollection<DpiClientStatPO> a(String collection) {
        return this.mongoTemplate.getDb().getCollection(collection, DpiClientStatPO.class);
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return DpiClientStatPO.INDEX_DEFINITIONS;
    }

    public List<DpiClientStatDTO> a(String omadacId, String siteId, Long statSec) {
        Long queryStartTime = statSec - 86400L;
        Long queryEndTime = statSec;
        ArrayList poList = new ArrayList();
        Query query = Query.query((CriteriaDefinition)d.a(omadacId, siteId, statSec));
        this.iteratorCollectionsByTimeAsc(queryStartTime, queryEndTime, collectionName -> {
            List tempList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)tempList)) {
                poList.addAll(tempList);
            }
        });
        return poList.stream().map(c::a).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, DpiClientStatDTO> a(String omadacId, String siteId, Long startSec, Long endSec, List<String> clientMacs) {
        HashMap<String, DpiClientStatDTO> resultMap = new HashMap<String, DpiClientStatDTO>();
        Aggregation aggregation = d.d(omadacId, siteId, startSec, endSec, clientMacs);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> {
            try {
                List tempList = this.mongoTemplate.aggregate(aggregation, collectionName, DpiClientStatDTO.class).getMappedResults();
                if (CollectionUtils.isEmpty((Collection)tempList)) {
                    return;
                }
                for (DpiClientStatDTO statDTO : tempList) {
                    if (Objects.isNull(statDTO.getMac())) continue;
                    String clientMac = statDTO.getMac();
                    statDTO.setTraffic(Long.valueOf(statDTO.getUp() + statDTO.getDown()));
                    statDTO.setTotalPacket(Long.valueOf(statDTO.getUpPacket() + statDTO.getDownPacket()));
                    DpiClientStatDTO oldStat = (DpiClientStatDTO)resultMap.get(clientMac);
                    if (Objects.isNull(oldStat)) {
                        resultMap.put(clientMac, statDTO);
                        continue;
                    }
                    oldStat.mergeOtherWithSameClientMac(statDTO);
                }
            }
            catch (Exception e2) {
                a.warn("fail to get data from {} for : ", collectionName, (Object)e2);
            }
        });
        a.debug("find client stat from omadacId : {} siteId : {} between {} and {} , result size is {}", new Object[]{omadacId, siteId, startSec, endSec, resultMap.size()});
        if (CollectionUtils.isEmptyMap(resultMap)) {
            return Collections.emptyMap();
        }
        return resultMap;
    }

    public void a(String omadacId, Long time) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("time").lt((Object)time));
        this.iteratorCollectionsByTimeAsc(0L, time, collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void a(String omadacId, String siteId, Long startSec, Long endSec) {
        Criteria criteria = d.a(omadacId, siteId, startSec, endSec);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("deleted", (Object)true);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, collectionName));
    }
}

