/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.port.mongo.a;

import com.mongodb.client.MongoCollection;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.dpi.api.internal.dto.ApplicationClientTrafficDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.ApplicationTotalTrafficDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.CategoryTotalTrafficDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.DpiApplicationStatDTO;
import com.tplink.smb.omada.client.dpi.port.mongo.a.c;
import com.tplink.smb.omada.client.dpi.port.mongo.d;
import com.tplink.smb.omada.client.dpi.port.mongo.dpistat.DpiApplicationStatPO;
import com.tplink.smb.omada.common.mongo.repository.s;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public abstract class a<P extends DpiApplicationStatPO>
extends s<P>
implements d {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    protected MongoCollection<DpiApplicationStatPO> a(String collection) {
        return this.mongoTemplate.getDb().getCollection(collection, DpiApplicationStatPO.class);
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return DpiApplicationStatPO.INDEX_DEFINITIONS;
    }

    public List<DpiApplicationStatDTO> a(String omadacId, String siteId, Long statSec) {
        Long queryStartTime = statSec - 86400L;
        Long queryEndTime = statSec;
        ArrayList poList = new ArrayList();
        Query query = Query.query((CriteriaDefinition)com.tplink.smb.omada.client.dpi.port.mongo.a.d.a(omadacId, siteId, statSec));
        this.iteratorCollectionsByTimeAsc(queryStartTime, queryEndTime, collectionName -> {
            List tempList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)tempList)) {
                poList.addAll(tempList);
            }
        });
        return poList.stream().map(c::a).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DpiApplicationStatDTO> a(String omadacId, String siteId, Long startSec, Long endSec, List<Integer> familyIds) {
        HashMap resultMap = new HashMap();
        Aggregation aggregation = com.tplink.smb.omada.client.dpi.port.mongo.a.d.a(omadacId, siteId, startSec, endSec, familyIds);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> {
            try {
                List tempList = this.mongoTemplate.aggregate(aggregation, collectionName, DpiApplicationStatDTO.class).getMappedResults();
                if (CollectionUtils.isEmpty((Collection)tempList)) {
                    return;
                }
                for (DpiApplicationStatDTO statDTO : tempList) {
                    if (Objects.isNull(statDTO.getApplicationId())) continue;
                    statDTO.setTraffic(Long.valueOf(statDTO.getUp() + statDTO.getDown()));
                    statDTO.setTotalPacket(Long.valueOf(statDTO.getUpPacket() + statDTO.getDownPacket()));
                    List allClients = statDTO.getAllClientTraffics().stream().map(Map::keySet).collect(Collectors.toList());
                    statDTO.setAllClients(allClients);
                    String applicationKey = this.a(statDTO.getFamilyId(), statDTO.getApplicationId());
                    DpiApplicationStatDTO oldStat = (DpiApplicationStatDTO)resultMap.get(applicationKey);
                    if (Objects.isNull(oldStat)) {
                        resultMap.put(applicationKey, statDTO);
                        continue;
                    }
                    oldStat.mergeOtherWithSameApplicationId(statDTO);
                }
            }
            catch (Exception e2) {
                a.warn("fail to get data from {} for : ", collectionName, (Object)e2);
            }
        });
        a.debug("find application stat from omadacId : {} siteId : {} between {} and {} , result size is {}", new Object[]{omadacId, siteId, startSec, endSec, resultMap.size()});
        if (CollectionUtils.isEmptyMap(resultMap)) {
            return Collections.emptyList();
        }
        return new ArrayList<DpiApplicationStatDTO>(resultMap.values());
    }

    public Map<Integer, CategoryTotalTrafficDTO> a(String omadacId, String siteId, Long startSec, Long endSec) {
        HashMap<Integer, CategoryTotalTrafficDTO> resultMap = new HashMap<Integer, CategoryTotalTrafficDTO>();
        Aggregation aggregation = com.tplink.smb.omada.client.dpi.port.mongo.a.d.b(omadacId, siteId, startSec, endSec);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> {
            try {
                List tempList = this.mongoTemplate.aggregate(aggregation, collectionName, CategoryTotalTrafficDTO.class).getMappedResults();
                if (CollectionUtils.isEmpty((Collection)tempList)) {
                    return;
                }
                for (CategoryTotalTrafficDTO statDTO : tempList) {
                    if (Objects.isNull(statDTO.getFamilyId())) continue;
                    Integer familyId = statDTO.getFamilyId();
                    CategoryTotalTrafficDTO oldStat = (CategoryTotalTrafficDTO)resultMap.get(familyId);
                    if (Objects.isNull(oldStat)) {
                        resultMap.put(familyId, statDTO);
                        continue;
                    }
                    oldStat.mergerOtherWithSameFamilyId(statDTO);
                }
            }
            catch (Exception e2) {
                a.warn("fail to get data from {} for : ", collectionName, (Object)e2);
            }
        });
        a.debug("aggregate category total traffic from omadacId : {} siteId : {} between {} and {} , result size is {}", new Object[]{omadacId, siteId, startSec, endSec, resultMap.size()});
        return resultMap;
    }

    public Map<Integer, ApplicationTotalTrafficDTO> b(String omadacId, String siteId, Long startSec, Long endSec, List<Integer> familyIds) {
        HashMap<Integer, ApplicationTotalTrafficDTO> resultMap = new HashMap<Integer, ApplicationTotalTrafficDTO>();
        Aggregation aggregation = com.tplink.smb.omada.client.dpi.port.mongo.a.d.b(omadacId, siteId, startSec, endSec, familyIds);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> {
            try {
                List tempList = this.mongoTemplate.aggregate(aggregation, collectionName, ApplicationTotalTrafficDTO.class).getMappedResults();
                if (CollectionUtils.isEmpty((Collection)tempList)) {
                    return;
                }
                for (ApplicationTotalTrafficDTO statDTO : tempList) {
                    if (Objects.isNull(statDTO.getApplicationId())) continue;
                    statDTO.setTraffic(Long.valueOf(statDTO.getUp() + statDTO.getDown()));
                    List allClients = statDTO.getAllClientTraffics().stream().map(Map::keySet).collect(Collectors.toList());
                    statDTO.setAllClients(allClients);
                    Integer applicationId = statDTO.getApplicationId();
                    ApplicationTotalTrafficDTO oldStat = (ApplicationTotalTrafficDTO)resultMap.get(applicationId);
                    if (Objects.isNull(oldStat)) {
                        resultMap.put(applicationId, statDTO);
                        continue;
                    }
                    oldStat.mergerOtherWithSameApplicationId(statDTO);
                }
            }
            catch (Exception e2) {
                a.warn("fail to get data from {} for : ", collectionName, (Object)e2);
            }
        });
        a.debug("aggregate application total traffic from omadacId : {} siteId : {} between {} and {} , result size is {}", new Object[]{omadacId, siteId, startSec, endSec, resultMap.size()});
        return resultMap;
    }

    public Map<String, ApplicationTotalTrafficDTO> c(String omadacId, String siteId, Long startSec, Long endSec, List<Integer> familyIds) {
        HashMap<String, ApplicationTotalTrafficDTO> resultMap = new HashMap<String, ApplicationTotalTrafficDTO>();
        Aggregation aggregation = com.tplink.smb.omada.client.dpi.port.mongo.a.d.c(omadacId, siteId, startSec, endSec, familyIds);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> {
            try {
                List tempList = this.mongoTemplate.aggregate(aggregation, collectionName, ApplicationTotalTrafficDTO.class).getMappedResults();
                if (CollectionUtils.isEmpty((Collection)tempList)) {
                    return;
                }
                for (ApplicationTotalTrafficDTO statDTO : tempList) {
                    if (Objects.isNull(statDTO.getApplicationId())) continue;
                    statDTO.setTraffic(Long.valueOf(statDTO.getUp() + statDTO.getDown()));
                    List allClients = statDTO.getAllClientTraffics().stream().map(Map::keySet).collect(Collectors.toList());
                    statDTO.setAllClients(allClients);
                    String applicationKey = this.a(statDTO.getFamilyId(), statDTO.getApplicationId());
                    ApplicationTotalTrafficDTO oldStat = (ApplicationTotalTrafficDTO)resultMap.get(applicationKey);
                    if (Objects.isNull(oldStat)) {
                        resultMap.put(applicationKey, statDTO);
                        continue;
                    }
                    oldStat.mergerOtherWithSameApplicationId(statDTO);
                }
            }
            catch (Exception e2) {
                a.warn("fail to get data from {} for : ", collectionName, (Object)e2);
            }
        });
        a.debug("aggregate category application total traffic from omadacId : {} siteId : {} between {} and {} , result size is {}", new Object[]{omadacId, siteId, startSec, endSec, resultMap.size()});
        return resultMap;
    }

    public List<ApplicationClientTrafficDTO> a(String omadacId, String siteId, Long startSec, Long endSec, List<Integer> familyIds, List<Integer> applicationIds) {
        ArrayList<ApplicationClientTrafficDTO> applicationClientTrafficList = new ArrayList<ApplicationClientTrafficDTO>();
        Aggregation aggregation = com.tplink.smb.omada.client.dpi.port.mongo.a.d.a(omadacId, siteId, startSec, endSec, familyIds, applicationIds);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> {
            try {
                List tempList = this.mongoTemplate.aggregate(aggregation, collectionName, ApplicationClientTrafficDTO.class).getMappedResults();
                if (CollectionUtils.isEmpty((Collection)tempList)) {
                    return;
                }
                applicationClientTrafficList.addAll(tempList);
            }
            catch (Exception e2) {
                a.warn("fail to get data from {} for : ", collectionName, (Object)e2);
            }
        });
        a.debug("aggregate application client traffic from omadacId : {} siteId : {} between {} and {} , result size is {}", new Object[]{omadacId, siteId, startSec, endSec, applicationClientTrafficList.size()});
        return applicationClientTrafficList;
    }

    public void a(String omadacId, Long time) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("time").lt((Object)time));
        this.iteratorCollectionsByTimeAsc(0L, time, collectionName -> this.mongoTemplate.remove(query, collectionName));
    }

    public void b(String omadacId, String siteId, Long startSec, Long endSec) {
        Criteria criteria = com.tplink.smb.omada.client.dpi.port.mongo.a.d.a(omadacId, siteId, startSec, endSec);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("deleted", (Object)true);
        this.iteratorCollectionsByTimeAsc(startSec, endSec, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, collectionName));
    }

    private String a(Integer familyId, Integer applicationId) {
        return familyId + ":" + applicationId;
    }
}

