/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.auth.portal;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.service.impl.b;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalPO;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V51330TOV51400)
public class PortalCompatibleV51330TOV51400
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalCompatibleV51330TOV51400.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final b dbCompatibleCacheService = b.a();
    private static final PortalCompatibleV51330TOV51400 instance = new PortalCompatibleV51330TOV51400();

    private PortalCompatibleV51330TOV51400() {
    }

    public static PortalCompatibleV51330TOV51400 getInstance() {
        return instance;
    }

    public void dbCompatible(String omadacId, d operationType) {
        long startMs = System.currentTimeMillis();
        log.info("Upgrading portals of omadac:{} from v5.13.30 to v5.14.0...", (Object)omadacId);
        try {
            this.doDeleteFacebookWiFiPortals(omadacId);
            log.info("Finished upgrade portals. cost: {}ms.", (Object)(System.currentTimeMillis() - startMs));
        }
        catch (Exception ex) {
            log.warn("Failed to upgrade portals.", (Throwable)ex);
        }
    }

    public void configSyncDevices(String omadacId, d operationType) {
        List pos = this.portalMaintRepository.findFacebookPortalsByOmadacId(omadacId);
        Set siteIds = pos.stream().map(PortalPO::getSiteId).collect(Collectors.toSet());
        HashSet deviceMacs = new HashSet();
        for (String siteId : siteIds) {
            List devicePOList = this.deviceMaintRepository.findByOmadacIdAndSiteId(omadacId, siteId);
            deviceMacs.addAll(devicePOList.stream().filter(devicePO -> DeviceTypeEnum.a.b().equalsIgnoreCase(devicePO.getType()) || DeviceTypeEnum.b.b().equalsIgnoreCase(devicePO.getType())).map(DevicePO::getMac).collect(Collectors.toSet()));
        }
        log.info("Facebook portal configured sites {}, deviceMacs {}", siteIds, deviceMacs);
        if (CollectionUtils.isEmpty(deviceMacs)) {
            return;
        }
        this.dbCompatibleCacheService.a(omadacId, deviceMacs);
    }

    private void doDeleteFacebookWiFiPortals(String omadacId) {
        List pos = this.portalMaintRepository.findFacebookPortalsByOmadacId(omadacId);
        if (CollectionUtils.isEmpty((Collection)pos)) {
            return;
        }
        for (PortalPO portalPO : pos) {
            List networks;
            String siteId = portalPO.getSiteId();
            String portalId = portalPO.getId();
            log.debug("Deleting Facebook WiFi portals: omadacId: {}, siteId: {}, portalId: {}", new Object[]{omadacId, siteId, portalId});
            List ssids = this.ssidMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId), portalId);
            if (!CollectionUtils.isEmpty((Collection)ssids)) {
                ssids.forEach(ssidPO -> ssidPO.setPortalEnable(Boolean.valueOf(false)).setPortalUrl(null).setPortalHttpsRedirectEnable(null).setPortalAuthType(null).setPortalId(null));
                this.ssidMaintMongoRepository.a(ssids);
            }
            if (CollectionUtils.isEmpty((Collection)(networks = this.lanNetworkMaintMongoRepository.b(new c(omadacId), new com.tplink.smb.omada.maintenance.common.b.a.a.d(siteId), portalId)))) continue;
            networks.forEach(lanNetwork -> lanNetwork.setPortalEnable(Boolean.valueOf(false)).setPortalUrl(null).setPortalHttpsRedirectEnable(null).setPortalAuthType(null).setPortalId(null));
            this.lanNetworkMaintMongoRepository.a(networks);
        }
        this.portalMaintRepository.deleteFacebookWiFiFAPs(omadacId);
        this.portalMaintRepository.deletePortals(pos);
    }
}

