/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.compatible.unit.globaldata;

import com.google.common.collect.Lists;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.logmanager.api.internal.dto.ClearAlertCacheRequestDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.api.internal.e;
import com.tplink.smb.omada.logmanager.port.mongo.data.OmadaLogUpgradeDTO;
import com.tplink.smb.omada.logmanager.port.mongo.data.m;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.compatible.d;
import com.tplink.smb.omada.maintenance.compatible.f;
import com.tplink.smb.omada.maintenance.compatible.h;
import com.tplink.smb.omada.maintenance.compatible.unit.globaldata.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

@com.tplink.smb.omada.maintenance.compatible.a.c(a=f.V50905TOV51000)
public class OmadaLogCompatibleV50905TOV51000
implements h {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadaLogCompatibleV50905TOV51000.class);
    private final m omadaLogMaintMongoRepository = m.a();
    private final e logManagerInternalApiService = (e)com.tplink.smb.omada.common.spring.a.b(e.class);
    private static final OmadaLogCompatibleV50905TOV51000 instance = new OmadaLogCompatibleV50905TOV51000();
    private final g siteMaintMongoRepository = g.a();

    private OmadaLogCompatibleV50905TOV51000() {
    }

    public static OmadaLogCompatibleV50905TOV51000 getInstance() {
        return instance;
    }

    public void dbCompatible(String omadacId, d operationType) {
        if (OmadacType.s()) {
            return;
        }
        log.info("Start upgrade Omada log from V50905 TO V51000");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Drop old indexes for omada log from V50900 TO V51100");
        this.omadaLogMaintMongoRepository.a(new c(omadacId));
        stopWatch.stop();
        stopWatch.start("Create temp indexes for omada log from V50900 TO V51100");
        this.omadaLogMaintMongoRepository.b(new c(omadacId));
        stopWatch.stop();
        stopWatch.start("Upgrade Omada log data from V50905 TO V51000");
        Set logCollectionNames = this.omadaLogMaintMongoRepository.c(omadacId);
        List<String> siteIds = this.siteMaintMongoRepository.a(new c(omadacId)).stream().map(BaseSitePO::getId).collect(Collectors.toList());
        this.upgradeOmadaLog(omadacId, logCollectionNames, siteIds);
        b.a((Runnable)RunnableWrapper.of((Runnable)new a(omadacId)), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        stopWatch.stop();
        log.info("Omada Log Upgraded Total time:{} s", (Object)stopWatch.getTotalTimeSeconds());
        log.info("Omada Log Upgraded time details:{}", (Object)stopWatch.prettyPrint());
        this.clearLogNotificationCache(omadacId, siteIds);
    }

    public void configSyncDevices(String omadacId, d operationType) {
    }

    private void clearLogNotificationCache(String omadacId, List<String> siteIds) {
        this.logManagerInternalApiService.b(ClearAlertCacheRequestDTO.builder().omadacId(omadacId).build());
        for (String siteId : siteIds) {
            this.logManagerInternalApiService.c(ClearAlertCacheRequestDTO.builder().omadacId(omadacId).siteId(siteId).build());
        }
    }

    private void upgradeOmadaLog(String omadacId, Set<String> logCollectionNames, List<String> siteIds) {
        if (CollectionUtil.isEmpty(logCollectionNames) || CollectionUtil.isEmpty(siteIds)) {
            log.info("Do not Upgrade Omada log data from V50905 TO V51000");
            return;
        }
        for (String collectionName : logCollectionNames) {
            this.upgradeGlobalOmadaLog(omadacId, collectionName);
            this.upgradeSiteOmadaLog(omadacId, collectionName, siteIds);
        }
    }

    private void upgradeGlobalOmadaLog(String omadacId, String collectionName) {
        long siteStartTime = System.currentTimeMillis();
        OmadaLogDTO omadacDTO = OmadaLogDTO.builder().omadacId(omadacId).siteId(null).build();
        OperationResponse alertSetResponse = this.logManagerInternalApiService.c(omadacDTO);
        OperationResponse eventSetResponse = this.logManagerInternalApiService.d(omadacDTO);
        if (alertSetResponse.success() && eventSetResponse.success()) {
            Set alertKeys = (Set)alertSetResponse.getResult();
            Set eventKeys = (Set)eventSetResponse.getResult();
            this.omadaLogMaintMongoRepository.a(new c(omadacId), collectionName, alertKeys, eventKeys);
            log.info("upgrade global omada log from V50900 TO V51100 in {},spend time:{} s", (Object)collectionName, (Object)((System.currentTimeMillis() - siteStartTime) / 1000L));
        }
    }

    private void upgradeSiteOmadaLog(String omadacId, String collectionName, List<String> siteIds) {
        List sitePartition = Lists.partition(siteIds, (int)5);
        for (List siteList : sitePartition) {
            long siteStartTime = System.currentTimeMillis();
            ArrayList<OmadaLogUpgradeDTO> omadaLogUpgradeList = new ArrayList<OmadaLogUpgradeDTO>(5);
            for (String siteId : siteList) {
                OmadaLogDTO siteDTO = OmadaLogDTO.builder().omadacId(omadacId).siteId(siteId).build();
                OperationResponse alertSetResponse = this.logManagerInternalApiService.c(siteDTO);
                OperationResponse eventSetResponse = this.logManagerInternalApiService.d(siteDTO);
                if (!alertSetResponse.success() || !eventSetResponse.success()) {
                    log.warn("Failed to upgrade site:{} omada log", (Object)siteId);
                    continue;
                }
                omadaLogUpgradeList.add(OmadaLogUpgradeDTO.builder().siteId(siteId).alertKeys((Set)alertSetResponse.getResult()).eventKeys((Set)eventSetResponse.getResult()).build());
            }
            this.omadaLogMaintMongoRepository.a(omadacId, collectionName, omadaLogUpgradeList);
            log.info("upgrade siteList:{} from V50900 TO V51100 in {}, spend time:{} s", new Object[]{collectionName, x.a((Object)siteList), (System.currentTimeMillis() - siteStartTime) / 1000L});
        }
    }
}

