/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.api.triggers;

import com.tplink.smb.component.schedule.api.ScheduleTrigger;
import com.tplink.smb.component.schedule.api.TimeZoneEnum;
import com.tplink.smb.component.schedule.api.exception.ScheduleException;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTrigger
implements ScheduleTrigger {
    private static final Logger log = LoggerFactory.getLogger(CronTrigger.class);
    private String cron;
    private TimeZone timeZone;

    public static CronTrigger by(String cron, TimeZone timeZone) {
        return new CronTrigger(cron, timeZone);
    }

    public static CronTrigger by(String cron, String timezoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(TimeZoneEnum.getStaticTimeZoneId(timezoneId));
        return new CronTrigger(cron, timeZone);
    }

    public static CronTrigger by(String cron) {
        return new CronTrigger(cron, null);
    }

    public long getNextTimeAfterNow() {
        return this.getNextTimeAfter(new Date());
    }

    public long getNextTimeAfter(Date time) {
        try {
            CronExpression cronExpression = new CronExpression(this.cron);
            cronExpression.setTimeZone(this.timeZone);
            Date nextValidTime = cronExpression.getNextValidTimeAfter(time);
            return nextValidTime.getTime();
        }
        catch (ParseException e) {
            log.error("invalid cron {} ", (Object)this.cron, (Object)e);
            throw new ScheduleException("invalid cron expression " + this.cron);
        }
    }

    public String getCron() {
        return this.cron;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public CronTrigger(String cron, TimeZone timeZone) {
        this.cron = cron;
        this.timeZone = timeZone;
    }

    public CronTrigger() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CronTrigger)) {
            return false;
        }
        CronTrigger other = (CronTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CronTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    public String toString() {
        return "CronTrigger(cron=" + this.getCron() + ", timeZone=" + this.getTimeZone() + ")";
    }
}

