/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.api;

import com.tplink.smb.component.schedule.api.MisfireStrategy;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import java.util.TimeZone;

public class ScheduleTaskFactory {
    private ScheduleTaskFactory() {
    }

    public static ScheduleTask.ScheduleTaskBuilder singleTaskBuilder(Long timestamp) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(MisfireStrategy.EXECUTE_ONCE).withTimestampTrigger(timestamp).withDeleteAfterExecuted(Boolean.TRUE);
    }

    public static ScheduleTask.ScheduleTaskBuilder nonperiodicScheduleTaskBuilder(Long timestamp) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(MisfireStrategy.EXECUTE_ONCE).withTimestampTrigger(timestamp).withDeleteAfterExecuted(Boolean.FALSE);
    }

    public static ScheduleTask.ScheduleTaskBuilder fixedScheduleTaskBuilder(Integer fixedRate, MisfireStrategy misfireStrategy) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(misfireStrategy).withFixedRateTrigger(fixedRate).withDeleteAfterExecuted(Boolean.FALSE);
    }

    public static ScheduleTask.ScheduleTaskBuilder fixedScheduleTaskBuilder(Integer fixedRate, Integer delay, MisfireStrategy misfireStrategy) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(misfireStrategy).withFixedRateTrigger(fixedRate, delay).withDeleteAfterExecuted(Boolean.FALSE);
    }

    public static ScheduleTask.ScheduleTaskBuilder calendarScheduleTaskBuilder(String cron, MisfireStrategy misfireStrategy) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(misfireStrategy).withCronTrigger(cron).withDeleteAfterExecuted(Boolean.FALSE);
    }

    public static ScheduleTask.ScheduleTaskBuilder calendarScheduleTaskBuilder(String cron, String timezoneId, MisfireStrategy misfireStrategy) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(misfireStrategy).withCronTrigger(cron, timezoneId).withDeleteAfterExecuted(Boolean.FALSE);
    }

    public static ScheduleTask.ScheduleTaskBuilder calendarScheduleTaskBuilder(String cron, TimeZone timeZone, MisfireStrategy misfireStrategy) {
        return new ScheduleTask.ScheduleTaskBuilder().withMisfireStrategy(misfireStrategy).withCronTrigger(cron, timeZone).withDeleteAfterExecuted(Boolean.FALSE);
    }
}

