/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.api;

import com.tplink.smb.component.schedule.api.MisfireStrategy;
import com.tplink.smb.component.schedule.api.ScheduleTrigger;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.schedule.api.triggers.CronTrigger;
import com.tplink.smb.component.schedule.api.triggers.FixedRateTrigger;
import com.tplink.smb.component.schedule.api.triggers.TimestampTrigger;
import java.util.Map;
import java.util.TimeZone;
import lombok.NonNull;

public class ScheduleTask {
    private TaskKey taskKey;
    private String handlerName;
    private Map<String, Object> dataMap;
    private ScheduleTrigger scheduleTrigger;
    private Boolean enableSharding;
    private Integer shardingSize;
    private Integer shardBatchSize;
    private Long shardBatchDelayMill;
    private MisfireStrategy misfireStrategy;
    private Boolean deleteAfterExecuted;

    public static ScheduleTaskBuilder builder() {
        return new ScheduleTaskBuilder();
    }

    public ScheduleTask(@NonNull TaskKey taskKey, @NonNull ScheduleTrigger scheduleTrigger) {
        if (taskKey == null) {
            throw new NullPointerException("taskKey is marked non-null but is null");
        }
        if (scheduleTrigger == null) {
            throw new NullPointerException("scheduleTrigger is marked non-null but is null");
        }
        this.taskKey = taskKey;
        this.scheduleTrigger = scheduleTrigger;
        this.misfireStrategy = MisfireStrategy.DO_NOTHING;
    }

    public ScheduleTask setTaskKey(TaskKey taskKey) {
        this.taskKey = taskKey;
        return this;
    }

    public ScheduleTask setHandlerName(String handlerName) {
        this.handlerName = handlerName;
        return this;
    }

    public ScheduleTask setDataMap(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public ScheduleTask setScheduleTrigger(ScheduleTrigger scheduleTrigger) {
        this.scheduleTrigger = scheduleTrigger;
        return this;
    }

    public ScheduleTask setEnableSharding(Boolean enableSharding) {
        this.enableSharding = enableSharding;
        return this;
    }

    public ScheduleTask setShardingSize(Integer shardingSize) {
        this.shardingSize = shardingSize;
        return this;
    }

    public ScheduleTask setShardBatchSize(Integer shardBatchSize) {
        this.shardBatchSize = shardBatchSize;
        return this;
    }

    public ScheduleTask setShardBatchDelayMill(Long shardBatchDelayMill) {
        this.shardBatchDelayMill = shardBatchDelayMill;
        return this;
    }

    public ScheduleTask setDeleteAfterExecuted(Boolean deleteAfterExecuted) {
        this.deleteAfterExecuted = deleteAfterExecuted;
        return this;
    }

    public ScheduleTask setMisfireStrategy(MisfireStrategy misfireStrategy) {
        this.misfireStrategy = misfireStrategy;
        return this;
    }

    public TaskKey getTaskKey() {
        return this.taskKey;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public ScheduleTrigger getScheduleTrigger() {
        return this.scheduleTrigger;
    }

    public Boolean getEnableSharding() {
        return this.enableSharding;
    }

    public Integer getShardingSize() {
        return this.shardingSize;
    }

    public Integer getShardBatchSize() {
        return this.shardBatchSize;
    }

    public Long getShardBatchDelayMill() {
        return this.shardBatchDelayMill;
    }

    public MisfireStrategy getMisfireStrategy() {
        return this.misfireStrategy;
    }

    public Boolean getDeleteAfterExecuted() {
        return this.deleteAfterExecuted;
    }

    public String toString() {
        return "ScheduleTask(taskKey=" + this.getTaskKey() + ", handlerName=" + this.getHandlerName() + ", dataMap=" + this.getDataMap() + ", scheduleTrigger=" + this.getScheduleTrigger() + ", enableSharding=" + this.getEnableSharding() + ", shardingSize=" + this.getShardingSize() + ", shardBatchSize=" + this.getShardBatchSize() + ", shardBatchDelayMill=" + this.getShardBatchDelayMill() + ", misfireStrategy=" + (Object)((Object)this.getMisfireStrategy()) + ", deleteAfterExecuted=" + this.getDeleteAfterExecuted() + ")";
    }

    public ScheduleTask() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleTask)) {
            return false;
        }
        ScheduleTask other = (ScheduleTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableSharding = this.getEnableSharding();
        Boolean other$enableSharding = other.getEnableSharding();
        if (this$enableSharding == null ? other$enableSharding != null : !((Object)this$enableSharding).equals(other$enableSharding)) {
            return false;
        }
        Integer this$shardingSize = this.getShardingSize();
        Integer other$shardingSize = other.getShardingSize();
        if (this$shardingSize == null ? other$shardingSize != null : !((Object)this$shardingSize).equals(other$shardingSize)) {
            return false;
        }
        Integer this$shardBatchSize = this.getShardBatchSize();
        Integer other$shardBatchSize = other.getShardBatchSize();
        if (this$shardBatchSize == null ? other$shardBatchSize != null : !((Object)this$shardBatchSize).equals(other$shardBatchSize)) {
            return false;
        }
        Long this$shardBatchDelayMill = this.getShardBatchDelayMill();
        Long other$shardBatchDelayMill = other.getShardBatchDelayMill();
        if (this$shardBatchDelayMill == null ? other$shardBatchDelayMill != null : !((Object)this$shardBatchDelayMill).equals(other$shardBatchDelayMill)) {
            return false;
        }
        Boolean this$deleteAfterExecuted = this.getDeleteAfterExecuted();
        Boolean other$deleteAfterExecuted = other.getDeleteAfterExecuted();
        if (this$deleteAfterExecuted == null ? other$deleteAfterExecuted != null : !((Object)this$deleteAfterExecuted).equals(other$deleteAfterExecuted)) {
            return false;
        }
        TaskKey this$taskKey = this.getTaskKey();
        TaskKey other$taskKey = other.getTaskKey();
        if (this$taskKey == null ? other$taskKey != null : !((Object)this$taskKey).equals(other$taskKey)) {
            return false;
        }
        String this$handlerName = this.getHandlerName();
        String other$handlerName = other.getHandlerName();
        if (this$handlerName == null ? other$handlerName != null : !this$handlerName.equals(other$handlerName)) {
            return false;
        }
        Map<String, Object> this$dataMap = this.getDataMap();
        Map<String, Object> other$dataMap = other.getDataMap();
        if (this$dataMap == null ? other$dataMap != null : !((Object)this$dataMap).equals(other$dataMap)) {
            return false;
        }
        ScheduleTrigger this$scheduleTrigger = this.getScheduleTrigger();
        ScheduleTrigger other$scheduleTrigger = other.getScheduleTrigger();
        if (this$scheduleTrigger == null ? other$scheduleTrigger != null : !this$scheduleTrigger.equals(other$scheduleTrigger)) {
            return false;
        }
        MisfireStrategy this$misfireStrategy = this.getMisfireStrategy();
        MisfireStrategy other$misfireStrategy = other.getMisfireStrategy();
        return !(this$misfireStrategy == null ? other$misfireStrategy != null : !((Object)((Object)this$misfireStrategy)).equals((Object)other$misfireStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduleTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableSharding = this.getEnableSharding();
        result = result * 59 + ($enableSharding == null ? 43 : ((Object)$enableSharding).hashCode());
        Integer $shardingSize = this.getShardingSize();
        result = result * 59 + ($shardingSize == null ? 43 : ((Object)$shardingSize).hashCode());
        Integer $shardBatchSize = this.getShardBatchSize();
        result = result * 59 + ($shardBatchSize == null ? 43 : ((Object)$shardBatchSize).hashCode());
        Long $shardBatchDelayMill = this.getShardBatchDelayMill();
        result = result * 59 + ($shardBatchDelayMill == null ? 43 : ((Object)$shardBatchDelayMill).hashCode());
        Boolean $deleteAfterExecuted = this.getDeleteAfterExecuted();
        result = result * 59 + ($deleteAfterExecuted == null ? 43 : ((Object)$deleteAfterExecuted).hashCode());
        TaskKey $taskKey = this.getTaskKey();
        result = result * 59 + ($taskKey == null ? 43 : ((Object)$taskKey).hashCode());
        String $handlerName = this.getHandlerName();
        result = result * 59 + ($handlerName == null ? 43 : $handlerName.hashCode());
        Map<String, Object> $dataMap = this.getDataMap();
        result = result * 59 + ($dataMap == null ? 43 : ((Object)$dataMap).hashCode());
        ScheduleTrigger $scheduleTrigger = this.getScheduleTrigger();
        result = result * 59 + ($scheduleTrigger == null ? 43 : $scheduleTrigger.hashCode());
        MisfireStrategy $misfireStrategy = this.getMisfireStrategy();
        result = result * 59 + ($misfireStrategy == null ? 43 : ((Object)((Object)$misfireStrategy)).hashCode());
        return result;
    }

    public static class ScheduleTaskBuilder {
        private TaskKey taskKey;
        private String handlerName;
        private Map<String, Object> dataMap;
        private ScheduleTrigger scheduleTrigger;
        private Boolean enableSharding = false;
        private Integer shardingSize;
        private Integer shardBatchSize;
        private Long shardBatchDelayMill;
        private MisfireStrategy misfireStrategy = MisfireStrategy.DO_NOTHING;
        private Boolean deleteAfterExecuted;

        public ScheduleTaskBuilder withIdentity(String name) {
            this.taskKey = TaskKey.of(name);
            return this;
        }

        public ScheduleTaskBuilder withIdentity(String name, String param) {
            this.taskKey = TaskKey.of(name, param);
            return this;
        }

        public ScheduleTaskBuilder forHandler(String handlerName) {
            this.handlerName = handlerName;
            return this;
        }

        public ScheduleTaskBuilder withDataMap(Map<String, Object> dataMap) {
            this.dataMap = dataMap;
            return this;
        }

        public ScheduleTaskBuilder withTimestampTrigger(Long timestamp) {
            this.scheduleTrigger = TimestampTrigger.by(timestamp);
            return this;
        }

        public ScheduleTaskBuilder withCronTrigger(String cron) {
            this.scheduleTrigger = CronTrigger.by(cron);
            return this;
        }

        public ScheduleTaskBuilder withCronTrigger(String cron, String timezoneId) {
            this.scheduleTrigger = CronTrigger.by(cron, timezoneId);
            return this;
        }

        public ScheduleTaskBuilder withCronTrigger(String cron, TimeZone timeZone) {
            this.scheduleTrigger = CronTrigger.by(cron, timeZone);
            return this;
        }

        public ScheduleTaskBuilder withFixedRateTrigger(Integer fixedRate) {
            this.scheduleTrigger = FixedRateTrigger.by(fixedRate);
            return this;
        }

        public ScheduleTaskBuilder withFixedRateTrigger(Integer fixedRate, Integer delay) {
            this.scheduleTrigger = FixedRateTrigger.by(fixedRate, delay);
            return this;
        }

        public ScheduleTaskBuilder withEnableSharding(Integer shardingSize) {
            this.enableSharding = true;
            this.shardingSize = shardingSize;
            return this;
        }

        public ScheduleTaskBuilder withEnableSharding(Integer shardingSize, Integer shardBatchSize, Long shardBatchDelayMill) {
            this.enableSharding = true;
            this.shardingSize = shardingSize;
            this.shardBatchSize = shardBatchSize;
            this.shardBatchDelayMill = shardBatchDelayMill;
            return this;
        }

        public ScheduleTaskBuilder withDisableSharding() {
            this.enableSharding = false;
            this.shardBatchSize = null;
            this.shardBatchDelayMill = null;
            return this;
        }

        public ScheduleTaskBuilder withMisfireStrategy(MisfireStrategy misfireStrategy) {
            this.misfireStrategy = misfireStrategy;
            return this;
        }

        ScheduleTaskBuilder withDeleteAfterExecuted(Boolean deleteAfterExecuted) {
            this.deleteAfterExecuted = deleteAfterExecuted;
            return this;
        }

        public ScheduleTask build() {
            return new ScheduleTask(this.taskKey, this.scheduleTrigger).setHandlerName(this.handlerName).setDataMap(this.dataMap).setEnableSharding(this.enableSharding).setShardingSize(this.shardingSize).setShardBatchSize(this.shardBatchSize).setShardBatchDelayMill(this.shardBatchDelayMill).setDeleteAfterExecuted(this.deleteAfterExecuted).setMisfireStrategy(this.misfireStrategy);
        }
    }
}

