/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.inform.osw;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.manage.InformKey;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigRespBody;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.device.manage.message.inform.InformResolveResult;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformFdb;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswClient;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswLag;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswPort;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswAlertInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswCfgResultsInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswDDMInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformDhcpInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformMulticastInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformRouting;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformVrrpInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInfromArpInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswLLDPInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswLoopbackStatus;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPortPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswSysLog;
import com.tplink.smb.omada.device.manage.message.inform.osw.mlag.OswMlagInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.stp.OswStpInfo;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OswInformKeyEnum implements InformKey<OswInformBody>
{
    ADDITIONAL_PROPERTIES("addtional", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            log.debug("unknow inform key message {} on switch {} with omadac {}.", new Object[]{content, mac, omadacId});
            Map<String, Object> additionalProperties = informBody.getAdditionalProperties();
            if (additionalProperties == null) {
                additionalProperties = new HashMap<String, Object>();
                informBody.setAdditionalProperties(additionalProperties);
            }
            additionalProperties.put(informKey, content);
            return true;
        }
    }
    ,
    NEED_REPLAY("needReply", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, Integer.class, informBody::setNeedReply, e2 -> {
                log.warn("Failed trans osw needReplay for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_INFORM_DEVICE("deviceInfo", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswInformDeviceInfo.class, informBody::setDeviceInfo, e2 -> {
                log.warn("Failed trans osw OswInformDeviceInfo for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSW_PORT("port", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOswPort.class, informBody::setPort, e2 -> {
                log.warn("Failed trans osw InformOswPort for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSW_LAG("lag", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOswLag.class, informBody::setLag, e2 -> {
                log.warn("Failed trans osw InformOswLag for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_FDB("fdb", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformFdb.class, informBody::setFdb, e2 -> {
                log.warn("Failed trans osw InformFdb for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_POE_STATUS("poe", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            try {
                OswPoeStatus oswPoeStatus = (OswPoeStatus)x.a((String)x.a((Object)content), OswPoeStatus.class);
                if (oswPoeStatus != null && oswPoeStatus.getBase() != null && !oswPoeStatus.getBase().equals(0.0)) {
                    Optional.ofNullable(oswPoeStatus.getTotal()).ifPresent(total -> oswPoeStatus.setTotal(total / oswPoeStatus.getBase()));
                    Optional.ofNullable(oswPoeStatus.getRemain()).ifPresent(remain -> oswPoeStatus.setRemain(remain / oswPoeStatus.getBase()));
                    Optional.ofNullable(oswPoeStatus.getRemainPercent()).ifPresent(remainPercent -> oswPoeStatus.setRemainPercent(remainPercent / oswPoeStatus.getBase()));
                    if (!CollectionUtil.isEmpty(oswPoeStatus.getPorts())) {
                        for (OswPortPoeStatus oswPortPoeStatus : oswPoeStatus.getPorts()) {
                            Optional.ofNullable(oswPortPoeStatus.getPower()).ifPresent(power -> oswPortPoeStatus.setPower(power / oswPoeStatus.getBase()));
                            Optional.ofNullable(oswPortPoeStatus.getVoltage()).ifPresent(voltage -> oswPortPoeStatus.setVoltage(voltage / oswPoeStatus.getBase()));
                            Optional.ofNullable(oswPortPoeStatus.getCurrent()).ifPresent(current -> oswPortPoeStatus.setCurrent(current / oswPoeStatus.getBase()));
                            if (CollectionUtil.isEmpty(oswPortPoeStatus.getPeriodPower())) continue;
                            List<Double> periodPowers = oswPortPoeStatus.getPeriodPower().stream().filter(periodPower -> periodPower != null).map(periodPower -> periodPower / oswPoeStatus.getBase()).collect(Collectors.toList());
                            oswPortPoeStatus.setPeriodPower(periodPowers);
                        }
                    }
                }
                informBody.setPoe(oswPoeStatus);
                return true;
            }
            catch (Exception e2) {
                log.warn("Failed trans osw OswPoeStatus for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
                return false;
            }
        }
    }
    ,
    INFORM_OSW_CLIENT("client", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOswClient.class, informBody::setClient, e2 -> {
                log.warn("Failed trans osw InformOswClient for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_LOOPBACK_STATUS("loopback", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswLoopbackStatus.class, informBody::setLoopback, e2 -> {
                log.warn("Failed trans osw OswLoopbackStatus for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_SYS_LOG("log", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswSysLog.class, informBody::setSystemLog, e2 -> {
                log.warn("Failed trans osw OswSysLog for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_INFORM_ROUTING("routingTable", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswInformRouting.class, informBody::setRoutingTable, e2 -> {
                log.warn("Failed trans osw OswInformRouting for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_INFORMM_ULTICAST_INFO("multicast", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswInformMulticastInfo.class, informBody::setMulticastInfo, e2 -> {
                log.warn("Failed trans osw OswInformMulticastInfo for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_INFROM_ARP_INFO("arp", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswInfromArpInfo.class, informBody::setArpInfo, e2 -> {
                log.warn("Failed trans osw OswInfromArpInfo for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_INFORM_DHCP_INFO("dhcp", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswInformDhcpInfo.class, informBody::setDhcpInfo, e2 -> {
                log.warn("Failed trans osw OswInformDhcpInfo for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_LLDP_INFO("lldp", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswLLDPInfo.class, informBody::setLldp, e2 -> {
                log.warn("Failed trans osw lldp infor for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_VRRP_INFO("vrrp", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, OswInformVrrpInfo.class, informBody::setVrrpInfo, e2 -> {
                log.warn("Failed trans osw OswInformVrrpInfo for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_ALERT_INFO("alertInfo", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswAlertInfo.class, informBody::setAlertInfo, e2 -> {
                log.warn("Failed trans osw alertInfo for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_LAST_CFG_RESULT("lastCfgResult", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswConfigRespBody.class, informBody::setLastCfgResult, e2 -> {
                log.warn("Failed trans osw lastCfgResult inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_MLAG_INFO("mlag", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswMlagInfo.class, informBody::setMlag, e2 -> {
                log.warn("Failed trans osw mlag inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_DDM_INFO("ddm", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswDDMInfo.class, informBody::setDdmInfo, e2 -> {
                log.warn("Failed trans osw DDM info for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_STP_INFO("stpInform", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswStpInfo.class, informBody::setStpInfo, e2 -> {
                log.warn("Failed trans osw stp info for mac {} on omadac {} with errorMsg {}.", new Object[]{a.d((String)mac), omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSW_CFG_RESULTS("cfgResults", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OswInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OswCfgResultsInfo.class, informBody::setOswCfgResultsInfo, e2 -> {
                log.warn("Failed trans osw cfgResults inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    };

    @Generated
    private static final Logger log;
    static final Map<String, OswInformKeyEnum> KEY_ENUM_MAP;
    private String key;
    private boolean negligible;

    @Nonnull
    public static InformResolveResult<OswInformBody> resolveInform(Map informMap, String omadacId, String mac) {
        try {
            return new InformResolveResult<OswInformBody>((OswInformBody)x.a((Map)informMap, OswInformBody.class), Collections.emptyMap());
        }
        catch (Exception e2) {
            log.warn("Transform inform error for Switch {} on {}", new Object[]{mac, omadacId, e2});
            if (CollectionUtils.isEmpty((Map)informMap)) {
                log.trace("Empty osw inform body for {} {}. ", (Object)mac, (Object)omadacId);
                return new InformResolveResult<OswInformBody>();
            }
            Set informKeys = informMap.keySet();
            if (CollectionUtils.isEmpty(informKeys)) {
                log.trace("Empty osw inform keys for {} {}. ", (Object)mac, (Object)omadacId);
                return new InformResolveResult<OswInformBody>();
            }
            HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
            OswInformBody oswInformBody = new OswInformBody();
            for (Object key : informKeys) {
                OswInformKeyEnum informKeyEnum = OswInformKeyEnum.resolve(key);
                if (informKeyEnum.transformMessage(informMap.get(key), omadacId, mac, key.toString(), oswInformBody, errorMap) || informKeyEnum.isNegligible()) continue;
                log.warn("Transform inform error for osw device {} on {} on key {} and message {}.", new Object[]{mac, omadacId, key, informMap.get(key)});
                return new InformResolveResult<OswInformBody>();
            }
            return new InformResolveResult<OswInformBody>(oswInformBody, errorMap);
        }
    }

    @Nonnull
    public static InformResolveResult<OswInformBody> resolveInformInKeySet(Map informMap, @Nonnull Set<OswInformKeyEnum> keyEnums, String omadacId, String mac) {
        if (CollectionUtils.isEmpty((Map)informMap)) {
            log.trace("Empty osw inform body in part resolve for {} {}. ", (Object)mac, (Object)omadacId);
            return new InformResolveResult<OswInformBody>();
        }
        OswInformBody oswInformBody = new OswInformBody();
        HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
        for (OswInformKeyEnum keyEnum : keyEnums) {
            if (!informMap.containsKey(keyEnum.key()) || keyEnum.transformMessage(informMap.get(keyEnum.key), omadacId, mac, keyEnum.key, oswInformBody, errorMap) || keyEnum.isNegligible()) continue;
            log.warn("Transform inform error for switch device {} on {} on key {} and message {}.", new Object[]{mac, omadacId, keyEnum.key(), informMap.get(keyEnum.key)});
            return new InformResolveResult<OswInformBody>();
        }
        return new InformResolveResult<OswInformBody>(oswInformBody, errorMap);
    }

    public static OswInformKeyEnum resolve(Object key) {
        return Optional.ofNullable(KEY_ENUM_MAP.get(key.toString())).orElse(ADDITIONAL_PROPERTIES);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public boolean isNegligible() {
        return this.negligible;
    }

    private OswInformKeyEnum(String key, boolean negligible) {
        this.key = key;
        this.negligible = negligible;
    }

    static {
        log = LoggerFactory.getLogger(OswInformKeyEnum.class);
        KEY_ENUM_MAP = Arrays.stream(OswInformKeyEnum.values()).collect(Collectors.toMap(OswInformKeyEnum::key, value -> value));
    }
}

