/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.inform.osg;

import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.manage.InformKey;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgConfigureRespBody;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.inform.InformResolveResult;
import com.tplink.smb.omada.device.manage.message.inform.ap.voip.CallLogInform;
import com.tplink.smb.omada.device.manage.message.inform.ap.voip.VoiceMailUsbOnOffInform;
import com.tplink.smb.omada.device.manage.message.inform.osg.DhcpClientInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformApplicationTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformArp;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformClientTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgAbnormalDetection;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgClient;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgDDns;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgNetTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPort;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPortTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPortalDuration;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformPortForwardingStats;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformQosData;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformSdWanStats;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformSslVpn;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformVpnStats;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformWireguardStats;
import com.tplink.smb.omada.device.manage.message.inform.osg.IpsThreatInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgCfgResultsInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgInformRouting;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgLLDPInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgLteInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgSysLog;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OsgInformKeyEnum implements InformKey<OsgInformBody>
{
    ADDITIONAL_PPRPERTIES("ERROR", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            log.debug("UnKnow inform key message {} on gateway {} with omadac {}.", new Object[]{content, mac, omadacId});
            Map<String, Object> additionalProperties = informBody.getAdditionalProperties();
            if (additionalProperties == null) {
                additionalProperties = new HashMap<String, Object>();
                informBody.setAdditionalProperties(additionalProperties);
            }
            additionalProperties.put(informKey, content);
            return true;
        }
    }
    ,
    NEED_REPLAY("needReply", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, Integer.class, informBody::setNeedReply, e2 -> {
                log.warn("Failed trans osg needReplay for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSG_INFORM_DEVICE_INFO("deviceInfo", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgInformDeviceInfo.class, informBody::setDeviceInfo, e2 -> {
                log.warn("Failed trans osg OsgInformDeviceInfo for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_PORT("portInfo", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgPort.class, informBody::setPortInfo, e2 -> {
                log.warn("Failed trans osg InformOsgPort for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_PORT_TRAFFIC("trafficStat", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgPortTraffic.class, informBody::setTrafficStat, e2 -> {
                log.warn("Failed trans osg InformOsgPortTraffic for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_NET_TRAFFIC("networkTraffic", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgNetTraffic.class, informBody::setNetTraffic, e2 -> {
                log.warn("Failed trans osg InformOsgNetTraffic for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_CLIENT("client", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgClient.class, informBody::setClient, e2 -> {
                log.warn("Failed trans osg InformOsgClient for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_ARP("arp", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformArp.class, informBody::setArp, e2 -> {
                log.warn("Failed trans osg InformArp for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSG_SYS_LOG("log", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgSysLog.class, informBody::setSystemLog, e2 -> {
                log.warn("Failed trans osg OsgSysLog for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_CLIENT_TRAFFIC("clientTraffic", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformClientTraffic.class, informBody::setClientTraffic, e2 -> {
                log.warn("Failed trans osg InformClientTraffic for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_PORT_FORWARDING_STATS("portforward", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformPortForwardingStats.class, informBody::setPortForwardingStats, e2 -> {
                log.warn("Failed trans osg InformPortForwardingStats for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_DDNS("ddns", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgDDns.class, informBody::setOsgDDns, e2 -> {
                log.warn("Failed trans osg InformOsgDDns for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_VPN_STATS("vpn", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformVpnStats.class, informBody::setVpnStats, e2 -> {
                log.warn("Failed trans osg InformVpnStats for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_SSL_VPN("sslVpn", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformSslVpn.class, informBody::setSslVpn, e2 -> {
                log.warn("Failed trans osg InformSslVpn for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSG_INFORM_ROUTING("routingTable", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgInformRouting.class, informBody::setRoutingTable, e2 -> {
                log.warn("Failed trans osg OsgInformRouting for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_PORTAL_DURATION("portalDuration", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgPortalDuration.class, informBody::setPortalDuration, e2 -> {
                log.warn("Failed trans osg InformOsgPortalDuration for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_ABNORMAL_DETECTION("abnormalDt", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformOsgAbnormalDetection.class, informBody::setAbnormalDetection, e2 -> {
                log.warn("Failed trans osg InformOsgAbnormalDetection for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_WIREGUARD("wireguard", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformWireguardStats.class, informBody::setWireguard, e2 -> {
                log.warn("Failed trans osg InformWireguardStats for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    POE("poe", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgPoeStatus.class, informBody::setPoe, e2 -> {
                log.warn("Failed trans osg poe for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_OSG_QOS("qos", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformQosData.class, informBody::setQosData, e2 -> {
                log.warn("Failed trans osg InformQosData for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSG_LLDP_INFO("lldp", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgLLDPInfo.class, informBody::setLldp, e2 -> {
                log.warn("Failed trans osg lldp data for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    IPS_THREAD_LIST("ipsThreat", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, IpsThreatInfo.class, informBody::setIpsThreatInfo, e2 -> {
                log.warn("Failed trans osg ipsThreat data for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    LTE("lte", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgLteInfo.class, informBody::setOsgLteInfo, e2 -> {
                log.warn("Failed trans osg lte info data for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_APPLICATION_TRAFFIC("applicationsTraffic", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformApplicationTraffic.class, informBody::setApplicationsTraffic, e2 -> {
                log.warn("Failed trans osg InformApplicationTraffic for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    DHCP_CLIENT("dhcpClient", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, DhcpClientInfo.class, informBody::setDhcpClientInfo, e2 -> {
                log.warn("Failed trans osg dhcp client info data for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    CALL_LOG_INFORM("callLogInform", false){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, CallLogInform.class, informBody::setCallLogInform, e2 -> {
                log.warn("Failed trans ap callLogInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2.toString()});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    VOICE_MAIL_USB_ON_OFF_INFORM("voiceMailUsb", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, VoiceMailUsbOnOffInform.class, informBody::setVoiceMailUsbOnOffInform, e2 -> {
                log.warn("Failed trans osg voiceMailUsbOnOffInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2.toString()});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSG_LAST_CFG_RESULT("lastCfgResult", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgConfigureRespBody.class, informBody::setLastCfgResult, e2 -> {
                log.warn("Failed trans osg lastCfgResult inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    OSG_CFG_RESULTS("cfgResults", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, OsgCfgResultsInfo.class, informBody::setOsgCfgResultsInfo, e2 -> {
                log.warn("Failed trans osg cfgResults inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INFORM_SD_WAN_STATS("sdwan", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull OsgInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, InformSdWanStats.class, informBody::setInformSdWanStats, e2 -> {
                log.warn("Failed trans osg InformSdWanStats for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    };

    @Generated
    private static final Logger log;
    static final Map<String, OsgInformKeyEnum> KEY_ENUM_MAP;
    private String key;
    private boolean negligible;

    @Nonnull
    public static InformResolveResult<OsgInformBody> resolveInform(Map informMap, String omadacId, String mac) {
        try {
            return new InformResolveResult<OsgInformBody>((OsgInformBody)x.a((Map)informMap, OsgInformBody.class), Collections.emptyMap());
        }
        catch (Exception e2) {
            log.warn("Transform inform error for Gateway {} on {}", new Object[]{mac, omadacId, e2});
            if (CollectionUtils.isEmpty((Map)informMap)) {
                log.trace("Empty osg inform body for {} {}. ", (Object)mac, (Object)omadacId);
                return new InformResolveResult<OsgInformBody>();
            }
            Set informKeys = informMap.keySet();
            if (CollectionUtils.isEmpty(informKeys)) {
                log.trace("Empty osg inform keys for {} {}. ", (Object)mac, (Object)omadacId);
                return new InformResolveResult<OsgInformBody>();
            }
            OsgInformBody osgInformBody = new OsgInformBody();
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            for (Object key : informKeys) {
                OsgInformKeyEnum informKeyEnum = OsgInformKeyEnum.resolve(key);
                if (informKeyEnum.transformMessage(informMap.get(key), omadacId, mac, key.toString(), osgInformBody, errorMap) || informKeyEnum.isNegligible()) continue;
                log.warn("Transform inform error for osg device {} on {} on key {} and message {}.", new Object[]{mac, omadacId, key, informMap.get(key)});
                return new InformResolveResult<OsgInformBody>();
            }
            return new InformResolveResult<OsgInformBody>(osgInformBody, errorMap);
        }
    }

    @Nonnull
    public static InformResolveResult<OsgInformBody> resolveInformInKeySet(Map informMap, @Nonnull Set<OsgInformKeyEnum> keyEnums, String omadacId, String mac) {
        if (CollectionUtils.isEmpty((Map)informMap)) {
            log.trace("Empty osg inform body in part resolve for {} {}. ", (Object)mac, (Object)omadacId);
            return new InformResolveResult<OsgInformBody>();
        }
        OsgInformBody osgInformBody = new OsgInformBody();
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        for (OsgInformKeyEnum keyEnum : keyEnums) {
            if (!informMap.containsKey(keyEnum.key()) || keyEnum.transformMessage(informMap.get(keyEnum.key), omadacId, mac, keyEnum.key, osgInformBody, errorMap) || keyEnum.isNegligible()) continue;
            log.warn("Transform inform error for gateway device {} on {} on key {} and message {}.", new Object[]{mac, omadacId, keyEnum.key(), informMap.get(keyEnum.key)});
            return new InformResolveResult<OsgInformBody>();
        }
        return new InformResolveResult<OsgInformBody>(osgInformBody, errorMap);
    }

    public static OsgInformKeyEnum resolve(Object key) {
        return Optional.ofNullable(KEY_ENUM_MAP.get(key.toString())).orElse(ADDITIONAL_PPRPERTIES);
    }

    private OsgInformKeyEnum(String key, boolean negligible) {
        this.key = key;
        this.negligible = negligible;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public boolean isNegligible() {
        return this.negligible;
    }

    static {
        log = LoggerFactory.getLogger(OsgInformKeyEnum.class);
        KEY_ENUM_MAP = Arrays.stream(OsgInformKeyEnum.values()).collect(Collectors.toMap(OsgInformKeyEnum::key, value -> value));
    }
}

