/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.inform.ap;

import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.eap.ApConfigRespBody;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.body.manage.InformKey;
import com.tplink.smb.omada.device.manage.message.inform.InformResolveResult;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApCfgResultInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApDownLinkPortStatus;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApLanMCastStat;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApPoeStatus;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApUpLinkPortStatus;
import com.tplink.smb.omada.device.manage.message.inform.ap.ClientConnectionStatInform;
import com.tplink.smb.omada.device.manage.message.inform.ap.ClientStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.EapInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.EapSysLog;
import com.tplink.smb.omada.device.manage.message.inform.ap.GpsInform;
import com.tplink.smb.omada.device.manage.message.inform.ap.InformEapAuthedUser;
import com.tplink.smb.omada.device.manage.message.inform.ap.LanInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.LanTrafficStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.RogueApStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.SsidStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.TrafficStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.WirelessInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.BandSteerRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.InterfaceStatusRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.RadioAccess;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.RoamingRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.ConnectRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.mesh.MeshInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedRoamingInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.voip.CallLogInform;
import com.tplink.smb.omada.device.manage.message.inform.ap.wids.WidsInform;
import com.tplink.smb.omada.device.manage.message.inform.ap.wips.WipsInform;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ApInformKeyEnum implements InformKey<EapInformBody>
{
    ADDITIONAL_PPRPERTIES("addtional", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            log.debug("UnKnow inform key message {} on gateway {} with omadac {}.", new Object[]{content, mac, omadacId});
            Map<String, Object> additionalProperties = informBody.getAdditionalProperties();
            if (additionalProperties == null) {
                additionalProperties = new HashMap<String, Object>();
                informBody.setAdditionalProperties(additionalProperties);
            }
            additionalProperties.put(informKey, content);
            return true;
        }
    }
    ,
    NEED_REPLAY("needReply", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, Integer.class, informBody::setNeedReply, e2 -> {
                log.warn("Failed trans ap needReplay for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    EAP_INFORM_DEVICE_INFO("deviceInfo", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, EapInformDeviceInfo.class, informBody::setDeviceInfo, e2 -> {
                log.warn("Failed trans ap needReplay for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    CLIENT_STATS("clients", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, ClientStats.class, informBody::setClients, e2 -> {
                log.warn("Failed trans ap clients for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    PORTAL_AUTH_CLIENTS("portalAuthClients", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, ClientStats.class, informBody::setPortalAuthClients, e2 -> {
                log.warn("Failed trans ap portalAuthClients for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    ROGUE_AP_STATS("rogueApList", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, RogueApStats.class, informBody::setRogueApList, e2 -> {
                log.warn("Failed trans ap rogueApList for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    TRUST_AP_LIST("trustApList", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, RogueApStats.class, informBody::setTrustApList, e2 -> {
                log.warn("Failed trans ap trustApList for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    RADIO_TRAFFIC_2G("radioTraffic_2G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, TrafficStats.class, informBody::setRadioTraffic2G, e2 -> {
                log.warn("Failed trans ap radioTraffic2G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    RADIO_TRAFFIC_5G("radioTraffic_5G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, TrafficStats.class, informBody::setRadioTraffic5G, e2 -> {
                log.warn("Failed trans ap radioTraffic5G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    RADIO_TRAFFIC_5G2("radioTraffic_5G2", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, TrafficStats.class, informBody::setRadioTraffic5G2, e2 -> {
                log.warn("Failed trans ap radioTraffic5G2 for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    RADIO_TRAFFIC_6G("radioTraffic_6G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, TrafficStats.class, informBody::setRadioTraffic6G, e2 -> {
                log.warn("Failed trans ap radioTraffic6G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    LAN_TRAFFIC("lanTraffic", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, LanTrafficStats.class, informBody::setLanTraffic, e2 -> {
                log.warn("Failed trans ap lanTraffic for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    LAN_INFO("lanInfo", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, LanInfo.class, informBody::setLanInfo, e2 -> {
                log.warn("Failed trans ap LanInfo for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    EAP_SYS_LOG("log", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, EapSysLog.class, informBody::setSystemLog, e2 -> {
                log.warn("Failed trans ap log for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    SSID_STATS_2G("ssidStats_2G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, SsidStats.class, informBody::setSsidStats2G, e2 -> {
                log.warn("Failed trans ap ssidStats2G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    SSID_STATS_5G("ssidStats_5G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, SsidStats.class, informBody::setSsidStats5G, e2 -> {
                log.warn("Failed trans ap ssidStats5G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    SSID_STATS_5G2("ssidStats_5G2", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, SsidStats.class, informBody::setSsidStats5G2, e2 -> {
                log.warn("Failed trans ap ssidStats5G2 for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    SSID_STATS_6G("ssidStats_6G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, SsidStats.class, informBody::setSsidStats6G, e2 -> {
                log.warn("Failed trans ap ssidStats6G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    W_SETTINGS_2G("wSettings_2G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, WirelessInfo.class, informBody::setWSettings2G, e2 -> {
                log.warn("Failed trans ap wSettings2G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    W_SETTINGS_5G("wSettings_5G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, WirelessInfo.class, informBody::setWSettings5G, e2 -> {
                log.warn("Failed trans ap wSettings5G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    W_SETTINGS_5G2("wSettings_5G2", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, WirelessInfo.class, informBody::setWSettings5G2, e2 -> {
                log.warn("Failed trans ap wSettings5G2 for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    W_SETTINGS_6G("wSettings_6G", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, WirelessInfo.class, informBody::setWSettings6G, e2 -> {
                log.warn("Failed trans ap wSettings6G for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AUTHED_USERS("authedUsers", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, InformEapAuthedUser.class, informBody::setAuthedUsers, e2 -> {
                log.warn("Failed trans ap authedUsers for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    MESH_INFO("mesh", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, MeshInfo.class, informBody::setMeshInfo, e2 -> {
                log.warn("Failed trans ap MeshInfo for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    REPORTED_ROAMING_INFO("roaming", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ReportedRoamingInfo.class, informBody::setReportedRoamingInfo, e2 -> {
                log.warn("Failed trans ap ReportedRoamingInfo for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    CLIENT_CONNECTION_STAT_INFORM("clientConnection", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ClientConnectionStatInform.class, informBody::setClientConnection, e2 -> {
                log.warn("Failed trans ap ClientConnectionStatInform for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    CONNECT_RECORD("connRec", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ConnectRecord.class, informBody::setConnectRecord, e2 -> {
                log.warn("Failed trans ap ConnectRecord for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    RADIO_ACCESS("radioAccess", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, RadioAccess.class, informBody::setRadioAccess, e2 -> {
                log.warn("Failed trans ap RadioAccess for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    BAND_STEER_RECORD("bSteerRec", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, BandSteerRecord.class, informBody::setBdSteerRec, e2 -> {
                log.warn("Failed trans ap BandSteerRecord for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    ROAMING_RECORD("roamRec", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, RoamingRecord.class, informBody::setRoamRec, e2 -> {
                log.warn("Failed trans ap RoamingRecord for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    INTERFACE_STATUS_RECORD("intfRec", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, InterfaceStatusRecord.class, informBody::setIntfRec, e2 -> {
                log.warn("Failed trans ap InterfaceStatusRecord for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    WIDS_INFORM("widsInform", false){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, WidsInform.class, informBody::setWidsInform, e2 -> {
                log.warn("Failed trans ap widsInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    WIPS_INFORM("wipsInform", false){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, WipsInform.class, informBody::setWipsInform, e2 -> {
                log.warn("Failed trans ap wipsInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AP_DOWN_LINK_PORT_STATUS("portStatus", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, ApDownLinkPortStatus.class, informBody::setPortStatus, e2 -> {
                log.warn("Failed trans ap portStatus for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AP_UP_LINK_PORT_STATUS("uplinkPortStatus", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transformList(content, ApUpLinkPortStatus.class, informBody::setUplinkPortStatus, e2 -> {
                log.warn("Failed trans ap uplinkPortStatus for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    CALL_LOG_INFORM("callLogInform", false){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, CallLogInform.class, informBody::setCallLogInform, e2 -> {
                log.warn("Failed trans ap callLogInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    GPS_INFORM("gps", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, GpsInform.class, informBody::setGpsInform, e2 -> {
                log.warn("Failed trans ap gpsInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AP_POE_STATUS("poeInform", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ApPoeStatus.class, informBody::setPoe, e2 -> {
                log.warn("Failed trans ap poeInform for mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AP_LAN_MULTI_TRAFFIC("lanMCastStat", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ApLanMCastStat.class, informBody::setLanMultiTrafficInform, e2 -> {
                log.warn("Failed trans ap lanMultiTraffic for  mac {} on omadac {} with errorMse {} and error {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AP_LAST_CFG_RESULT("lastCfgResult", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ApConfigRespBody.class, informBody::setLastCfgResult, e2 -> {
                log.warn("Failed trans ap lastCfgResult inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    }
    ,
    AP_CFG_RESULTS("cfgResults", true){

        @Override
        public boolean transformMessage(Object content, String omadacId, String mac, String informKey, @Nonnull EapInformBody informBody, @Nonnull Map<String, Object> errorMap) {
            return this.transform(content, ApCfgResultInfo.class, informBody::setCfgResultsInfo, e2 -> {
                log.warn("Failed trans ap cfgResults inform for mac {} on omadac {} with errorMsg {}.", new Object[]{mac, omadacId, e2.getMessage(), e2});
                errorMap.put(this.key(), content);
            });
        }
    };

    @Generated
    private static final Logger log;
    private String key;
    private boolean negligible;
    static final Map<String, ApInformKeyEnum> KEY_ENUM_MAP;

    @Nonnull
    public static InformResolveResult<EapInformBody> resolveInform(Map informMap, String omadacId, String mac) {
        try {
            return new InformResolveResult<EapInformBody>((EapInformBody)x.a((Map)informMap, EapInformBody.class), Collections.emptyMap());
        }
        catch (Exception e2) {
            log.warn("Transform inform error for AP {} on {}", new Object[]{mac, omadacId, e2});
            if (CollectionUtils.isEmpty((Map)informMap)) {
                log.trace("Empty ap inform body for {} {}. ", (Object)mac, (Object)omadacId);
                return new InformResolveResult<EapInformBody>();
            }
            Set informKeys = informMap.keySet();
            if (CollectionUtils.isEmpty(informKeys)) {
                log.trace("Empty ap inform keys for {} {}. ", (Object)mac, (Object)omadacId);
                return new InformResolveResult<EapInformBody>();
            }
            HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
            EapInformBody eapInformBody = new EapInformBody();
            for (Object key : informKeys) {
                ApInformKeyEnum informKeyEnum = ApInformKeyEnum.resolve(key);
                if (informKeyEnum.transformMessage(informMap.get(key), omadacId, mac, key.toString(), eapInformBody, errorMap) || informKeyEnum.isNegligible()) continue;
                log.warn("Transform inform error for ap device {} on {} on key {} and message {}.", new Object[]{mac, omadacId, key, informMap.get(key)});
                return new InformResolveResult<EapInformBody>();
            }
            return new InformResolveResult<EapInformBody>(eapInformBody, errorMap);
        }
    }

    @Nonnull
    public static InformResolveResult<EapInformBody> resolveInformInKeySet(Map informMap, @Nonnull Set<ApInformKeyEnum> keyEnums, String omadacId, String mac) {
        if (CollectionUtils.isEmpty((Map)informMap)) {
            log.trace("Empty ap inform body in part resolve for {} {}. ", (Object)mac, (Object)omadacId);
            return new InformResolveResult<EapInformBody>();
        }
        HashMap<String, Object> errorMap = new HashMap<String, Object>(2);
        EapInformBody eapInformBody = new EapInformBody();
        for (ApInformKeyEnum keyEnum : keyEnums) {
            if (!informMap.containsKey(keyEnum.key()) || keyEnum.transformMessage(informMap.get(keyEnum.key), omadacId, mac, keyEnum.key, eapInformBody, errorMap) || keyEnum.isNegligible()) continue;
            log.warn("Transform inform error for ap device {} on {} on key {} and message {}.", new Object[]{mac, omadacId, keyEnum.key(), informMap.get(keyEnum.key)});
            return new InformResolveResult<EapInformBody>();
        }
        return new InformResolveResult<EapInformBody>(eapInformBody, errorMap);
    }

    private ApInformKeyEnum(String key, boolean negligible) {
        this.key = key;
        this.negligible = negligible;
    }

    public static ApInformKeyEnum resolve(Object key) {
        return Optional.ofNullable(KEY_ENUM_MAP.get(key.toString())).orElse(ADDITIONAL_PPRPERTIES);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public boolean isNegligible() {
        return this.negligible;
    }

    static {
        log = LoggerFactory.getLogger(ApInformKeyEnum.class);
        KEY_ENUM_MAP = Arrays.stream(ApInformKeyEnum.values()).collect(Collectors.toMap(ApInformKeyEnum::key, value -> value));
    }
}

