/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw.qos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.config.osw.es.EsComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.FragResult;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.RuleEntry;
import com.tplink.smb.omada.device.manage.message.exception.ComponentTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OswQosRuleConfig
extends b
implements EsComponent {
    @JsonProperty(value="operation")
    private Integer operation;
    @JsonProperty(value="rules")
    private List<RuleEntry> rules;

    @Override
    public FragResult getFragResult(OswConfigBody configBody, int maxBytes, Integer sequenceId, String omadacId, String mac) {
        int componentLength = x.a((Object)this).length();
        if (x.a((Object)configBody).length() + componentLength > maxBytes) {
            ArrayList<OswConfigBody> sendNowConfigBodys = new ArrayList<OswConfigBody>();
            sendNowConfigBodys.add(configBody);
            ArrayList<RuleEntry> ruleEntries = new ArrayList<RuleEntry>();
            OswConfigBody sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswQosRuleConfig(new OswQosRuleConfig(0, ruleEntries));
            sendConfigBody.setSequenceId(sequenceId);
            for (RuleEntry ruleEntry : this.rules) {
                ruleEntries.add(ruleEntry);
                int splitedLength = x.a((Object)sendConfigBody).length();
                if (splitedLength <= maxBytes) continue;
                if (ruleEntries.size() == 1) {
                    throw new ComponentTooLongException(maxBytes, splitedLength);
                }
                ruleEntries.remove(ruleEntries.size() - 1);
                sendNowConfigBodys.add(sendConfigBody);
                ruleEntries = new ArrayList();
                ruleEntries.add(ruleEntry);
                sendConfigBody = new OswConfigBody();
                sendConfigBody.setOswQosRuleConfig(new OswQosRuleConfig(0, ruleEntries));
                sendConfigBody.setSequenceId(sequenceId);
            }
            sendNowConfigBodys.add(sendConfigBody);
            OswConfigBody oswConfigBody = new OswConfigBody();
            oswConfigBody.setSequenceId(sequenceId);
            return FragResult.builder().sendNowConfigBodys(sendNowConfigBodys).configBody(oswConfigBody).build();
        }
        configBody.setOswQosRuleConfig(this);
        return FragResult.builder().sendNowConfigBodys(Collections.emptyList()).configBody(configBody).build();
    }

    @Generated
    public static OswQosRuleConfigBuilder builder() {
        return new OswQosRuleConfigBuilder();
    }

    @Generated
    public Integer getOperation() {
        return this.operation;
    }

    @Generated
    public List<RuleEntry> getRules() {
        return this.rules;
    }

    @JsonProperty(value="operation")
    @Generated
    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    @JsonProperty(value="rules")
    @Generated
    public void setRules(List<RuleEntry> rules) {
        this.rules = rules;
    }

    @Generated
    public String toString() {
        return "OswQosRuleConfig(operation=" + this.getOperation() + ", rules=" + this.getRules() + ")";
    }

    @Generated
    public OswQosRuleConfig() {
    }

    @Generated
    public OswQosRuleConfig(Integer operation, List<RuleEntry> rules) {
        this.operation = operation;
        this.rules = rules;
    }

    @Generated
    public static class OswQosRuleConfigBuilder {
        @Generated
        private Integer operation;
        @Generated
        private List<RuleEntry> rules;

        @Generated
        OswQosRuleConfigBuilder() {
        }

        @JsonProperty(value="operation")
        @Generated
        public OswQosRuleConfigBuilder operation(Integer operation) {
            this.operation = operation;
            return this;
        }

        @JsonProperty(value="rules")
        @Generated
        public OswQosRuleConfigBuilder rules(List<RuleEntry> rules) {
            this.rules = rules;
            return this;
        }

        @Generated
        public OswQosRuleConfig build() {
            return new OswQosRuleConfig(this.operation, this.rules);
        }

        @Generated
        public String toString() {
            return "OswQosRuleConfig.OswQosRuleConfigBuilder(operation=" + this.operation + ", rules=" + this.rules + ")";
        }
    }
}

