/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw.qos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.config.osw.common.ConfigMergeComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.EsComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.FragResult;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.VlanPriorityEntry;
import com.tplink.smb.omada.device.manage.message.exception.ComponentTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OswQosForVlanConfig
extends b
implements ConfigMergeComponent,
EsComponent {
    @JsonProperty(value="vlanPriorities")
    public List<VlanPriorityEntry> vlanPriorities;

    @Override
    public FragResult getFragResult(OswConfigBody configBody, int maxBytes, Integer sequenceId, String omadacId, String mac) {
        int componentLength = x.a((Object)this).length();
        if (x.a((Object)configBody).length() + componentLength > maxBytes) {
            ArrayList<OswConfigBody> sendNowConfigBodys = new ArrayList<OswConfigBody>();
            sendNowConfigBodys.add(configBody);
            ArrayList<VlanPriorityEntry> fragVlanPriorities = new ArrayList<VlanPriorityEntry>();
            OswConfigBody sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswQosForVlanConfig(new OswQosForVlanConfig(fragVlanPriorities));
            sendConfigBody.setSequenceId(sequenceId);
            for (VlanPriorityEntry vlanPriorityEntry : this.vlanPriorities) {
                fragVlanPriorities.add(vlanPriorityEntry);
                int splitedLength = x.a((Object)sendConfigBody).length();
                if (splitedLength <= maxBytes) continue;
                if (fragVlanPriorities.size() == 1) {
                    throw new ComponentTooLongException(maxBytes, splitedLength);
                }
                fragVlanPriorities.remove(fragVlanPriorities.size() - 1);
                sendNowConfigBodys.add(sendConfigBody);
                fragVlanPriorities = new ArrayList();
                fragVlanPriorities.add(vlanPriorityEntry);
                sendConfigBody = new OswConfigBody();
                sendConfigBody.setOswQosForVlanConfig(new OswQosForVlanConfig(fragVlanPriorities));
                sendConfigBody.setSequenceId(sequenceId);
            }
            sendNowConfigBodys.add(sendConfigBody);
            OswConfigBody oswConfigBody = new OswConfigBody();
            oswConfigBody.setSequenceId(sequenceId);
            return FragResult.builder().sendNowConfigBodys(sendNowConfigBodys).configBody(oswConfigBody).build();
        }
        configBody.setOswQosForVlanConfig(this);
        return FragResult.builder().sendNowConfigBodys(Collections.emptyList()).configBody(configBody).build();
    }

    @Override
    public void mergeConfig(List<? extends ConfigMergeComponent> configList) {
        ArrayList<VlanPriorityEntry> vlanPriorities = new ArrayList<VlanPriorityEntry>();
        for (ConfigMergeComponent configMergeComponent : configList) {
            OswQosForVlanConfig qosForVlanConfig = (OswQosForVlanConfig)configMergeComponent;
            Optional.ofNullable(qosForVlanConfig.getVlanPriorities()).ifPresent(vlanPriorities::addAll);
        }
        this.setVlanPriorities(!CollectionUtils.isEmpty(vlanPriorities) ? vlanPriorities : null);
    }

    @Generated
    public List<VlanPriorityEntry> getVlanPriorities() {
        return this.vlanPriorities;
    }

    @JsonProperty(value="vlanPriorities")
    @Generated
    public void setVlanPriorities(List<VlanPriorityEntry> vlanPriorities) {
        this.vlanPriorities = vlanPriorities;
    }

    @Generated
    public String toString() {
        return "OswQosForVlanConfig(vlanPriorities=" + this.getVlanPriorities() + ")";
    }

    @Generated
    public OswQosForVlanConfig() {
    }

    @Generated
    public OswQosForVlanConfig(List<VlanPriorityEntry> vlanPriorities) {
        this.vlanPriorities = vlanPriorities;
    }
}

