/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw.qos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.config.BaseListEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.common.ConfigMergeComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.EsComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.FragResult;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.BasicConfigEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.DscpPriorityEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.LagPriorityEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.PortPriorityEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.PriorityQueueMapEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.qos.SchedulerConfigEntry;
import com.tplink.smb.omada.device.manage.message.exception.ComponentTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OswQosConfig
extends b
implements ConfigMergeComponent,
EsComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswQosConfig.class);
    @JsonProperty(value="basicConfig")
    public BasicConfigEntry basicConfig;

    @Override
    public FragResult getFragResult(OswConfigBody configBody, int maxBytes, Integer sequenceId, String omadacId, String mac) {
        if (x.a((Object)configBody).length() + x.a((Object)this).length() > maxBytes) {
            ArrayList<OswConfigBody> sendNowConfigBodies = new ArrayList<OswConfigBody>();
            sendNowConfigBodies.add(configBody);
            this.splitPortPriorityConfig(maxBytes, sequenceId, sendNowConfigBodies);
            this.splitLagPriority(maxBytes, sequenceId, sendNowConfigBodies);
            this.splitDscpPriority(maxBytes, sequenceId, sendNowConfigBodies);
            this.splitPriorityQueueMap(maxBytes, sequenceId, sendNowConfigBodies);
            this.splitSchedulerConfig(maxBytes, sequenceId, sendNowConfigBodies);
            OswConfigBody oswConfigBody = new OswConfigBody();
            oswConfigBody.setSequenceId(sequenceId);
            return FragResult.builder().sendNowConfigBodys(sendNowConfigBodies).configBody(oswConfigBody).build();
        }
        configBody.setOswDscpQosConfig(this);
        return FragResult.builder().sendNowConfigBodys(Collections.emptyList()).configBody(configBody).build();
    }

    private void splitSchedulerConfig(int maxBytes, Integer sequenceId, List<OswConfigBody> sendNowConfigBodies) {
        if (CollectionUtils.isEmpty(this.basicConfig.getSchedulerConfig())) {
            return;
        }
        ArrayList<SchedulerConfigEntry> fragSchedulerConfig = new ArrayList<SchedulerConfigEntry>();
        BasicConfigEntry basicConfigEntry = new BasicConfigEntry();
        basicConfigEntry.setOperation(this.basicConfig.getOperation());
        basicConfigEntry.setSchedulerConfig(fragSchedulerConfig);
        OswConfigBody sendConfigBody = new OswConfigBody();
        sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(basicConfigEntry));
        sendConfigBody.setSequenceId(sequenceId);
        List<SchedulerConfigEntry> schedulerConfig = this.basicConfig.getSchedulerConfig();
        for (SchedulerConfigEntry entry : schedulerConfig) {
            fragSchedulerConfig.add(entry);
            int splitedLength = x.a((Object)sendConfigBody).length();
            if (splitedLength <= maxBytes) continue;
            if (fragSchedulerConfig.size() == 1) {
                throw new ComponentTooLongException(maxBytes, splitedLength);
            }
            fragSchedulerConfig.remove(fragSchedulerConfig.size() - 1);
            sendNowConfigBodies.add(sendConfigBody);
            fragSchedulerConfig = new ArrayList();
            fragSchedulerConfig.add(entry);
            sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(new BasicConfigEntry().setSchedulerConfig(fragSchedulerConfig)));
            sendConfigBody.setSequenceId(sequenceId);
        }
        sendNowConfigBodies.add(sendConfigBody);
    }

    private void splitPriorityQueueMap(int maxBytes, Integer sequenceId, List<OswConfigBody> sendNowConfigBodies) {
        if (CollectionUtils.isEmpty(this.basicConfig.getPriorityQueueMap())) {
            return;
        }
        ArrayList<PriorityQueueMapEntry> fragPriorityQueueMap = new ArrayList<PriorityQueueMapEntry>();
        BasicConfigEntry basicConfigEntry = new BasicConfigEntry();
        basicConfigEntry.setOperation(this.basicConfig.getOperation());
        basicConfigEntry.setPriorityQueueMap(fragPriorityQueueMap);
        OswConfigBody sendConfigBody = new OswConfigBody();
        sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(basicConfigEntry));
        sendConfigBody.setSequenceId(sequenceId);
        List<PriorityQueueMapEntry> priorityQueueMap = this.basicConfig.getPriorityQueueMap();
        for (PriorityQueueMapEntry entry : priorityQueueMap) {
            fragPriorityQueueMap.add(entry);
            int splitedLength = x.a((Object)sendConfigBody).length();
            if (splitedLength <= maxBytes) continue;
            if (fragPriorityQueueMap.size() == 1) {
                throw new ComponentTooLongException(maxBytes, splitedLength);
            }
            fragPriorityQueueMap.remove(fragPriorityQueueMap.size() - 1);
            sendNowConfigBodies.add(sendConfigBody);
            fragPriorityQueueMap = new ArrayList();
            fragPriorityQueueMap.add(entry);
            sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(new BasicConfigEntry().setPriorityQueueMap(fragPriorityQueueMap)));
            sendConfigBody.setSequenceId(sequenceId);
        }
        sendNowConfigBodies.add(sendConfigBody);
    }

    private void splitDscpPriority(int maxBytes, Integer sequenceId, List<OswConfigBody> sendNowConfigBodies) {
        if (CollectionUtils.isEmpty(this.basicConfig.getDscpPriority())) {
            return;
        }
        ArrayList<DscpPriorityEntry> fragDscpPriority = new ArrayList<DscpPriorityEntry>();
        BasicConfigEntry basicConfigEntry = new BasicConfigEntry();
        basicConfigEntry.setOperation(this.basicConfig.getOperation());
        basicConfigEntry.setDscpPriority(fragDscpPriority);
        OswConfigBody sendConfigBody = new OswConfigBody();
        sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(basicConfigEntry));
        sendConfigBody.setSequenceId(sequenceId);
        List<DscpPriorityEntry> dscpPriority = this.basicConfig.getDscpPriority();
        for (DscpPriorityEntry entry : dscpPriority) {
            fragDscpPriority.add(entry);
            int splitedLength = x.a((Object)sendConfigBody).length();
            if (splitedLength <= maxBytes) continue;
            if (fragDscpPriority.size() == 1) {
                throw new ComponentTooLongException(maxBytes, splitedLength);
            }
            fragDscpPriority.remove(fragDscpPriority.size() - 1);
            sendNowConfigBodies.add(sendConfigBody);
            fragDscpPriority = new ArrayList();
            fragDscpPriority.add(entry);
            sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(new BasicConfigEntry().setDscpPriority(fragDscpPriority)));
            sendConfigBody.setSequenceId(sequenceId);
        }
        sendNowConfigBodies.add(sendConfigBody);
    }

    private void splitLagPriority(int maxBytes, Integer sequenceId, List<OswConfigBody> sendNowConfigBodies) {
        if (CollectionUtils.isEmpty(this.basicConfig.getLagPriority())) {
            return;
        }
        ArrayList<LagPriorityEntry> fragLagPriority = new ArrayList<LagPriorityEntry>();
        BasicConfigEntry basicConfigEntry = new BasicConfigEntry();
        basicConfigEntry.setOperation(this.basicConfig.getOperation());
        basicConfigEntry.setLagPriority(fragLagPriority);
        OswConfigBody sendConfigBody = new OswConfigBody();
        sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(basicConfigEntry));
        sendConfigBody.setSequenceId(sequenceId);
        List<LagPriorityEntry> lagPriority = this.basicConfig.getLagPriority();
        for (LagPriorityEntry entry : lagPriority) {
            fragLagPriority.add(entry);
            int splitedLength = x.a((Object)sendConfigBody).length();
            if (splitedLength <= maxBytes) continue;
            if (fragLagPriority.size() == 1) {
                throw new ComponentTooLongException(maxBytes, splitedLength);
            }
            fragLagPriority.remove(fragLagPriority.size() - 1);
            sendNowConfigBodies.add(sendConfigBody);
            fragLagPriority = new ArrayList();
            fragLagPriority.add(entry);
            sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(new BasicConfigEntry().setLagPriority(fragLagPriority)));
            sendConfigBody.setSequenceId(sequenceId);
        }
        sendNowConfigBodies.add(sendConfigBody);
    }

    private void splitPortPriorityConfig(int maxBytes, Integer sequenceId, List<OswConfigBody> sendNowConfigBodies) {
        if (CollectionUtils.isEmpty(this.basicConfig.getPortPriority())) {
            return;
        }
        ArrayList<PortPriorityEntry> fragPortPriority = new ArrayList<PortPriorityEntry>();
        BasicConfigEntry basicConfigEntry = new BasicConfigEntry();
        basicConfigEntry.setOperation(this.basicConfig.getOperation());
        basicConfigEntry.setPortPriority(fragPortPriority);
        OswConfigBody sendConfigBody = new OswConfigBody();
        sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(basicConfigEntry));
        sendConfigBody.setSequenceId(sequenceId);
        List<PortPriorityEntry> portPriority = this.basicConfig.getPortPriority();
        for (PortPriorityEntry entry : portPriority) {
            fragPortPriority.add(entry);
            int splitedLength = x.a((Object)sendConfigBody).length();
            if (splitedLength <= maxBytes) continue;
            if (fragPortPriority.size() == 1) {
                throw new ComponentTooLongException(maxBytes, splitedLength);
            }
            fragPortPriority.remove(fragPortPriority.size() - 1);
            sendNowConfigBodies.add(sendConfigBody);
            fragPortPriority = new ArrayList();
            fragPortPriority.add(entry);
            sendConfigBody = new OswConfigBody();
            sendConfigBody.setOswDscpQosConfig(new OswQosConfig().setBasicConfig(new BasicConfigEntry().setPortPriority(fragPortPriority)));
            sendConfigBody.setSequenceId(sequenceId);
        }
        sendNowConfigBodies.add(sendConfigBody);
    }

    @Override
    public void mergeConfig(List<? extends ConfigMergeComponent> configList) {
        if (CollectionUtils.isEmpty(configList)) {
            return;
        }
        ArrayList basicConfigList = new ArrayList();
        for (ConfigMergeComponent configMergeComponent : configList) {
            OswQosConfig oswQosConfig = (OswQosConfig)configMergeComponent;
            Optional.ofNullable(oswQosConfig.getBasicConfig()).ifPresent(basicConfigList::add);
        }
        if (!CollectionUtils.isEmpty(basicConfigList)) {
            boolean bl;
            Set operationSet = basicConfigList.stream().map(BaseListEntry::getOperation).collect(Collectors.toSet());
            boolean bl2 = bl = operationSet.size() == 1 && Objects.nonNull(operationSet.iterator().next());
            if (!bl) {
                log.warn("Can not merge Qos configurations with different operation");
                return;
            }
            Integer operation = (Integer)operationSet.iterator().next();
            BasicConfigEntry basicConfigEntry = new BasicConfigEntry();
            ArrayList<PortPriorityEntry> portPriority = new ArrayList<PortPriorityEntry>();
            ArrayList<LagPriorityEntry> lagPriority = new ArrayList<LagPriorityEntry>();
            ArrayList<DscpPriorityEntry> dscpPriority = new ArrayList<DscpPriorityEntry>();
            ArrayList<PriorityQueueMapEntry> priorityQueueMap = new ArrayList<PriorityQueueMapEntry>();
            ArrayList<SchedulerConfigEntry> schedulerConfig = new ArrayList<SchedulerConfigEntry>();
            for (BasicConfigEntry basicConfig : basicConfigList) {
                Optional.ofNullable(basicConfig.getPortPriority()).ifPresent(portPriority::addAll);
                Optional.ofNullable(basicConfig.getLagPriority()).ifPresent(lagPriority::addAll);
                Optional.ofNullable(basicConfig.getDscpPriority()).ifPresent(dscpPriority::addAll);
                Optional.ofNullable(basicConfig.getPriorityQueueMap()).ifPresent(priorityQueueMap::addAll);
                Optional.ofNullable(basicConfig.getSchedulerConfig()).ifPresent(schedulerConfig::addAll);
            }
            basicConfigEntry.setPortPriority(!CollectionUtils.isEmpty(portPriority) ? portPriority : null);
            basicConfigEntry.setLagPriority(!CollectionUtils.isEmpty(lagPriority) ? lagPriority : null);
            basicConfigEntry.setDscpPriority(!CollectionUtils.isEmpty(dscpPriority) ? dscpPriority : null);
            basicConfigEntry.setPriorityQueueMap(!CollectionUtils.isEmpty(priorityQueueMap) ? priorityQueueMap : null);
            basicConfigEntry.setSchedulerConfig(!CollectionUtils.isEmpty(schedulerConfig) ? schedulerConfig : null);
            basicConfigEntry.setOperation(operation);
            this.setBasicConfig(basicConfigEntry);
        } else {
            this.setBasicConfig(null);
        }
    }

    @Generated
    public BasicConfigEntry getBasicConfig() {
        return this.basicConfig;
    }

    @JsonProperty(value="basicConfig")
    @Generated
    public OswQosConfig setBasicConfig(BasicConfigEntry basicConfig) {
        this.basicConfig = basicConfig;
        return this;
    }

    @Generated
    public String toString() {
        return "OswQosConfig(basicConfig=" + this.getBasicConfig() + ")";
    }
}

