/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw.multicast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.device.manage.message.config.osw.common.ConfigMergeComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.multicast.OswMulticastPortConfig;
import com.tplink.smb.omada.device.manage.message.config.osw.multicast.OswMulticastSnoopConfig;
import com.tplink.smb.omada.device.manage.message.config.osw.multicast.OswMulticastVlanConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OswLanMulticastConfig
extends b
implements ConfigMergeComponent {
    @JsonProperty(value="igmpSnoop")
    private OswMulticastSnoopConfig igmpSnoop;
    @JsonProperty(value="mldSnoop")
    private OswMulticastSnoopConfig mldSnoop;

    @Override
    public void mergeConfig(List<? extends ConfigMergeComponent> configList) {
        ArrayList<OswMulticastPortConfig> ports;
        if (CollectionUtils.isEmpty(configList)) {
            return;
        }
        ArrayList igmpSnoopList = new ArrayList();
        ArrayList mldSnoopList = new ArrayList();
        for (ConfigMergeComponent configMergeComponent : configList) {
            OswLanMulticastConfig multicastConfig = (OswLanMulticastConfig)configMergeComponent;
            Optional.ofNullable(multicastConfig.getIgmpSnoop()).ifPresent(igmpSnoopList::add);
            Optional.ofNullable(multicastConfig.getMldSnoop()).ifPresent(mldSnoopList::add);
        }
        if (!CollectionUtils.isEmpty(igmpSnoopList)) {
            OswMulticastSnoopConfig igmpSnoopConfig = new OswMulticastSnoopConfig();
            ArrayList<OswMulticastVlanConfig> arrayList = new ArrayList<OswMulticastVlanConfig>();
            ports = new ArrayList<OswMulticastPortConfig>();
            for (OswMulticastSnoopConfig snoopConfig : igmpSnoopList) {
                Optional.ofNullable(snoopConfig.getVlans()).ifPresent(arrayList::addAll);
                Optional.ofNullable(snoopConfig.getPorts()).ifPresent(ports::addAll);
            }
            igmpSnoopConfig.setVlans(arrayList);
            igmpSnoopConfig.setPorts(ports);
            this.setIgmpSnoop(igmpSnoopConfig);
        } else {
            this.setIgmpSnoop(null);
        }
        if (!CollectionUtils.isEmpty(mldSnoopList)) {
            OswMulticastSnoopConfig mldSnoopConfig = new OswMulticastSnoopConfig();
            ArrayList<OswMulticastVlanConfig> arrayList = new ArrayList<OswMulticastVlanConfig>();
            ports = new ArrayList();
            for (OswMulticastSnoopConfig snoopConfig : mldSnoopList) {
                Optional.ofNullable(snoopConfig.getVlans()).ifPresent(arrayList::addAll);
                Optional.ofNullable(snoopConfig.getPorts()).ifPresent(ports::addAll);
            }
            mldSnoopConfig.setVlans(arrayList);
            mldSnoopConfig.setPorts(ports);
            this.setMldSnoop(mldSnoopConfig);
        } else {
            this.setMldSnoop(null);
        }
    }

    @Generated
    public OswMulticastSnoopConfig getIgmpSnoop() {
        return this.igmpSnoop;
    }

    @Generated
    public OswMulticastSnoopConfig getMldSnoop() {
        return this.mldSnoop;
    }

    @JsonProperty(value="igmpSnoop")
    @Generated
    public void setIgmpSnoop(OswMulticastSnoopConfig igmpSnoop) {
        this.igmpSnoop = igmpSnoop;
    }

    @JsonProperty(value="mldSnoop")
    @Generated
    public void setMldSnoop(OswMulticastSnoopConfig mldSnoop) {
        this.mldSnoop = mldSnoop;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswLanMulticastConfig)) {
            return false;
        }
        OswLanMulticastConfig other = (OswLanMulticastConfig)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        OswMulticastSnoopConfig this$igmpSnoop = this.getIgmpSnoop();
        OswMulticastSnoopConfig other$igmpSnoop = other.getIgmpSnoop();
        if (this$igmpSnoop == null ? other$igmpSnoop != null : !((Object)this$igmpSnoop).equals(other$igmpSnoop)) {
            return false;
        }
        OswMulticastSnoopConfig this$mldSnoop = this.getMldSnoop();
        OswMulticastSnoopConfig other$mldSnoop = other.getMldSnoop();
        return !(this$mldSnoop == null ? other$mldSnoop != null : !((Object)this$mldSnoop).equals(other$mldSnoop));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswLanMulticastConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OswMulticastSnoopConfig $igmpSnoop = this.getIgmpSnoop();
        result = result * 59 + ($igmpSnoop == null ? 43 : ((Object)$igmpSnoop).hashCode());
        OswMulticastSnoopConfig $mldSnoop = this.getMldSnoop();
        result = result * 59 + ($mldSnoop == null ? 43 : ((Object)$mldSnoop).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswLanMulticastConfig(igmpSnoop=" + this.getIgmpSnoop() + ", mldSnoop=" + this.getMldSnoop() + ")";
    }

    @Generated
    public OswLanMulticastConfig() {
    }

    @Generated
    public OswLanMulticastConfig(OswMulticastSnoopConfig igmpSnoop, OswMulticastSnoopConfig mldSnoop) {
        this.igmpSnoop = igmpSnoop;
        this.mldSnoop = mldSnoop;
    }
}

