/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.config.osw.common.ConfigMergeComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.EsComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.FragResult;
import com.tplink.smb.omada.device.manage.message.config.osw.port.OswPortConfig;
import com.tplink.smb.omada.device.manage.message.config.osw.port.OswPortStp;
import com.tplink.smb.omada.device.manage.message.exception.ComponentTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OswPortConfigList
extends b
implements ConfigMergeComponent,
EsComponent {
    @JsonProperty(value="ports")
    private List<OswPortConfig> ports;

    public Object clone() {
        OswPortConfigList oswPortConfigList = (OswPortConfigList)super.clone();
        List<OswPortConfig> portConfigs = oswPortConfigList.getPorts();
        if (portConfigs != null) {
            ArrayList<OswPortConfig> portConfigClone = new ArrayList<OswPortConfig>(portConfigs.size());
            for (OswPortConfig portConfig : portConfigs) {
                portConfigClone.add((OswPortConfig)((Object)portConfig.clone()));
            }
            oswPortConfigList.setPorts(portConfigClone);
        }
        return oswPortConfigList;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public FragResult getFragResult(OswConfigBody configBody, int maxBytes, Integer sequenceId, String omadacId, String mac) {
        int componentLength = x.a((Object)this).length();
        if (x.a((Object)configBody).length() + componentLength > maxBytes) {
            ArrayList<OswConfigBody> sendNowConfigBodys = new ArrayList<OswConfigBody>();
            sendNowConfigBodys.add(configBody);
            ArrayList<OswPortConfig> fragPorts = new ArrayList<OswPortConfig>();
            OswConfigBody sendConfigBody = new OswConfigBody();
            sendConfigBody.setPort(new OswPortConfigList(fragPorts));
            sendConfigBody.setSequenceId(sequenceId);
            for (OswPortConfig port : this.ports) {
                this.clearUnSupportFields(port);
                fragPorts.add(port);
                int splitedLength = x.a((Object)sendConfigBody).length();
                if (splitedLength <= maxBytes) continue;
                if (fragPorts.size() == 1) {
                    throw new ComponentTooLongException(maxBytes, splitedLength);
                }
                fragPorts.remove(fragPorts.size() - 1);
                sendNowConfigBodys.add(sendConfigBody);
                fragPorts = new ArrayList();
                fragPorts.add(port);
                sendConfigBody = new OswConfigBody();
                sendConfigBody.setPort(new OswPortConfigList(fragPorts));
                sendConfigBody.setSequenceId(sequenceId);
            }
            sendNowConfigBodys.add(sendConfigBody);
            OswConfigBody oswConfigBody = new OswConfigBody();
            oswConfigBody.setSequenceId(sequenceId);
            return FragResult.builder().sendNowConfigBodys(sendNowConfigBodys).configBody(oswConfigBody).build();
        }
        configBody.setPort(this);
        return FragResult.builder().sendNowConfigBodys(Collections.emptyList()).configBody(configBody).build();
    }

    private void clearUnSupportFields(OswPortConfig port) {
        port.setStandardPortList(null);
        OswPortStp stp = port.getStp();
        if (stp != null) {
            stp.setPriority(null);
            stp.setExtPathCost(null);
            stp.setIntPathCost(null);
            stp.setEdgePort(null);
            stp.setP2pLink(null);
            stp.setMcheck(null);
            stp.setLoopProtect(null);
            stp.setRootProtect(null);
            stp.setTcGuard(null);
            stp.setBpduProtect(null);
            stp.setBpduFilter(null);
            stp.setBpduForward(null);
        }
    }

    @Override
    public void mergeConfig(List<? extends ConfigMergeComponent> configList) {
        ArrayList<OswPortConfig> ports = new ArrayList<OswPortConfig>();
        for (ConfigMergeComponent configMergeComponent : configList) {
            OswPortConfigList portConfigList = (OswPortConfigList)configMergeComponent;
            Optional.ofNullable(portConfigList.getPorts()).ifPresent(ports::addAll);
        }
        this.setPorts(!CollectionUtils.isEmpty(ports) ? ports : null);
    }

    @Generated
    public List<OswPortConfig> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="ports")
    @Generated
    public void setPorts(List<OswPortConfig> ports) {
        this.ports = ports;
    }

    @Generated
    public OswPortConfigList() {
    }

    @Generated
    public OswPortConfigList(List<OswPortConfig> ports) {
        this.ports = ports;
    }
}

