/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.config.osw.OswNetworkEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.common.ConfigMergeComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.EsComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.FragResult;
import com.tplink.smb.omada.device.manage.message.exception.ComponentTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OswNetworkConfig
extends b
implements ConfigMergeComponent,
EsComponent {
    @JsonProperty(value="networks")
    private List<OswNetworkEntry> networks;

    public Object clone() {
        OswNetworkConfig clone = (OswNetworkConfig)super.clone();
        if (CollectionUtils.isNotEmpty(this.getNetworks())) {
            ArrayList<OswNetworkEntry> list = new ArrayList<OswNetworkEntry>(this.getNetworks().size());
            for (OswNetworkEntry entry : this.getNetworks()) {
                list.add((OswNetworkEntry)((Object)entry.clone()));
            }
            clone.setNetworks(list);
        }
        return clone;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Override
    public FragResult getFragResult(OswConfigBody configBody, int maxBytes, Integer sequenceId, String omadacId, String mac) {
        int componentLength = x.a((Object)this).length();
        if (x.a((Object)configBody).length() + componentLength > maxBytes) {
            ArrayList<OswConfigBody> sendNowConfigBodys = new ArrayList<OswConfigBody>();
            sendNowConfigBodys.add(configBody);
            ArrayList<OswNetworkEntry> fragNetworks = new ArrayList<OswNetworkEntry>();
            OswConfigBody sendConfigBody = new OswConfigBody();
            sendConfigBody.setNetwork(new OswNetworkConfig(fragNetworks));
            sendConfigBody.setSequenceId(sequenceId);
            for (OswNetworkEntry network : this.networks) {
                fragNetworks.add(network);
                int splitedLength = x.a((Object)sendConfigBody).length();
                if (splitedLength <= maxBytes) continue;
                if (fragNetworks.size() == 1) {
                    throw new ComponentTooLongException(maxBytes, splitedLength);
                }
                fragNetworks.remove(fragNetworks.size() - 1);
                sendNowConfigBodys.add(sendConfigBody);
                fragNetworks = new ArrayList();
                fragNetworks.add(network);
                sendConfigBody = new OswConfigBody();
                sendConfigBody.setNetwork(new OswNetworkConfig(fragNetworks));
                sendConfigBody.setSequenceId(sequenceId);
            }
            sendNowConfigBodys.add(sendConfigBody);
            OswConfigBody oswConfigBody = new OswConfigBody();
            oswConfigBody.setSequenceId(sequenceId);
            return FragResult.builder().sendNowConfigBodys(sendNowConfigBodys).configBody(oswConfigBody).build();
        }
        configBody.setNetwork(this);
        return FragResult.builder().sendNowConfigBodys(Collections.emptyList()).configBody(configBody).build();
    }

    @Override
    public void mergeConfig(List<? extends ConfigMergeComponent> configList) {
        if (CollectionUtils.isEmpty(configList)) {
            return;
        }
        ArrayList<OswNetworkEntry> networks = new ArrayList<OswNetworkEntry>();
        for (ConfigMergeComponent configMergeComponent : configList) {
            OswNetworkConfig networkConfig = (OswNetworkConfig)configMergeComponent;
            Optional.ofNullable(networkConfig.getNetworks()).ifPresent(networks::addAll);
        }
        this.setNetworks(!CollectionUtils.isEmpty(networks) ? networks : null);
    }

    @Generated
    public List<OswNetworkEntry> getNetworks() {
        return this.networks;
    }

    @JsonProperty(value="networks")
    @Generated
    public void setNetworks(List<OswNetworkEntry> networks) {
        this.networks = networks;
    }

    @Generated
    public String toString() {
        return "OswNetworkConfig(networks=" + this.getNetworks() + ")";
    }

    @Generated
    public OswNetworkConfig(List<OswNetworkEntry> networks) {
        this.networks = networks;
    }

    @Generated
    public OswNetworkConfig() {
    }
}

