/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.config.osw;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.e.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.LagHashAlgConfig;
import com.tplink.smb.omada.device.manage.message.config.osw.common.ConfigMergeComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.EsComponent;
import com.tplink.smb.omada.device.manage.message.config.osw.es.FragResult;
import com.tplink.smb.omada.device.manage.message.config.osw.lag.OswLagConfig;
import com.tplink.smb.omada.device.manage.message.exception.ComponentTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OswLagConfigList
extends b
implements ConfigMergeComponent,
EsComponent {
    @JsonProperty(value="lags")
    private List<OswLagConfig> lags;
    @JsonProperty(value="lagHashAlg")
    private LagHashAlgConfig lagHashAlg;

    public OswLagConfigList(List<OswLagConfig> lags) {
        this(lags, null);
    }

    public OswLagConfigList(LagHashAlgConfig lagHashAlgConfig) {
        this(null, lagHashAlgConfig);
    }

    public OswLagConfigList(List<OswLagConfig> lags, LagHashAlgConfig lagHashAlgConfig) {
        this.lags = lags;
        this.lagHashAlg = lagHashAlgConfig;
    }

    public OswLagConfigList() {
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public FragResult getFragResult(OswConfigBody configBody, int maxBytes, Integer sequenceId, String omadacId, String mac) {
        int componentLength = x.a((Object)this).length();
        if (x.a((Object)configBody).length() + componentLength > maxBytes) {
            ArrayList<OswConfigBody> sendNowConfigBodys = new ArrayList<OswConfigBody>();
            sendNowConfigBodys.add(configBody);
            ArrayList<OswLagConfig> fragLags = new ArrayList<OswLagConfig>();
            OswConfigBody sendConfigBody = new OswConfigBody();
            sendConfigBody.setLag(new OswLagConfigList(fragLags));
            sendConfigBody.setSequenceId(sequenceId);
            for (OswLagConfig lag : this.lags) {
                fragLags.add(lag);
                int splitedLength = x.a((Object)sendConfigBody).length();
                if (splitedLength <= maxBytes) continue;
                if (fragLags.size() == 1) {
                    throw new ComponentTooLongException(maxBytes, splitedLength);
                }
                fragLags.remove(fragLags.size() - 1);
                sendNowConfigBodys.add(sendConfigBody);
                fragLags = new ArrayList();
                fragLags.add(lag);
                sendConfigBody = new OswConfigBody();
                sendConfigBody.setLag(new OswLagConfigList(fragLags));
                sendConfigBody.setSequenceId(sequenceId);
            }
            sendNowConfigBodys.add(sendConfigBody);
            OswConfigBody oswConfigBody = new OswConfigBody();
            oswConfigBody.setSequenceId(sequenceId);
            return FragResult.builder().sendNowConfigBodys(sendNowConfigBodys).configBody(oswConfigBody).build();
        }
        configBody.setLag(this);
        return FragResult.builder().sendNowConfigBodys(Collections.emptyList()).configBody(configBody).build();
    }

    @Override
    public void mergeConfig(List<? extends ConfigMergeComponent> configList) {
        if (CollectionUtils.isEmpty(configList)) {
            return;
        }
        ArrayList<OswLagConfig> lags = new ArrayList<OswLagConfig>();
        LagHashAlgConfig lagHashAlg = null;
        for (ConfigMergeComponent configMergeComponent : configList) {
            OswLagConfigList lagConfigList = (OswLagConfigList)configMergeComponent;
            Optional.ofNullable(lagConfigList.getLags()).ifPresent(lags::addAll);
            lagHashAlg = lagConfigList.getLagHashAlg();
        }
        this.setLags(!CollectionUtils.isEmpty(lags) ? lags : null);
        Optional.ofNullable(lagHashAlg).ifPresent(this::setLagHashAlg);
    }

    @Generated
    public List<OswLagConfig> getLags() {
        return this.lags;
    }

    @Generated
    public LagHashAlgConfig getLagHashAlg() {
        return this.lagHashAlg;
    }

    @JsonProperty(value="lags")
    @Generated
    public void setLags(List<OswLagConfig> lags) {
        this.lags = lags;
    }

    @JsonProperty(value="lagHashAlg")
    @Generated
    public void setLagHashAlg(LagHashAlgConfig lagHashAlg) {
        this.lagHashAlg = lagHashAlg;
    }
}

