/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message.body;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.device.manage.message.body.ConfigureBody;
import com.tplink.smb.omada.device.manage.message.config.SetKey;
import com.tplink.smb.omada.device.manage.message.exception.SetKeyException;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.TypeUtils;

public abstract class ConfigureBodyHashMapAdaptor<K extends SetKey>
implements ConfigureBody<K> {
    @JsonIgnore
    private final Map<String, Object> hashMap;

    public ConfigureBodyHashMapAdaptor() {
        this.hashMap = new HashMap<String, Object>();
    }

    public ConfigureBodyHashMapAdaptor(int capability) {
        this.hashMap = new HashMap<String, Object>(capability);
    }

    @Override
    public boolean containsKey(K key) {
        return this.hashMap.containsKey(key.key());
    }

    @Override
    public Object get(K key) {
        return this.hashMap.get(key.key());
    }

    @Override
    public Object remove(K key) {
        return this.hashMap.remove(key.key());
    }

    @Override
    public Object put(@Nonnull K keyEnum, @Nonnull Object value) {
        this.assertValid((SetKey)keyEnum, value);
        return this.hashMap.put(keyEnum.key(), value);
    }

    @Override
    @Nonnull
    public Collection<Object> values() {
        return this.hashMap.values();
    }

    @JsonAnySetter
    public void setProperty(String fieldName, Object value) {
        this.hashMap.put(fieldName, value);
    }

    @JsonAnyGetter
    public Map<String, Object> hashMap() {
        return this.hashMap;
    }

    private void assertValid(SetKey keyEnum, Object value) {
        Objects.requireNonNull(keyEnum);
        Objects.requireNonNull(value);
        if (!TypeUtils.isAssignable(keyEnum.entryClass(), value.getClass())) {
            throw new SetKeyException(keyEnum, value.getClass());
        }
    }
}

