/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EcspVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EcspVersion.class);
    public static final int[] HIGH_MAIN_VERSION = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static final int[] LOW_MAIN_VERSION = new int[]{-1, -1};
    public static Pattern ECSP_V1_PATTERN = Pattern.compile("^1");
    public static Pattern ECSP_V2_PATTERN = Pattern.compile("^2");
    public static Pattern ECSP_V3_PATTERN = Pattern.compile("^3");

    private EcspVersion() {
    }

    public static String fitFatEcspVer(String ecspVer) {
        int blank = ecspVer.lastIndexOf(32);
        if (blank < 0) {
            return ecspVer;
        }
        return ecspVer.substring(blank + 1);
    }

    public static int[] parseFatEcspVer(String ecspVer) {
        String fitEcspVer = EcspVersion.fitFatEcspVer(ecspVer);
        return EcspVersion.parseFitEcspVer(fitEcspVer);
    }

    public static int[] parseFitEcspVer(String ecspVer) {
        StringTokenizer stringTokenizer = new StringTokenizer(ecspVer, ".");
        int[] result = new int[2];
        for (int idx = 0; stringTokenizer.hasMoreTokens() && idx <= 1; ++idx) {
            result[idx] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return result;
    }

    public static EcspFirstVersionEnum getFirstVersion(String ecspVersion) {
        Integer firstVersion;
        if (T.c((String)ecspVersion)) {
            return EcspFirstVersionEnum.ERROR;
        }
        String[] verisons = ecspVersion.split("\\.");
        if (verisons.length < 1) {
            return EcspFirstVersionEnum.ERROR;
        }
        try {
            firstVersion = Integer.parseInt(verisons[0]);
        }
        catch (NumberFormatException e2) {
            log.error("error ecspVersion format: {}", (Object)ecspVersion);
            return EcspFirstVersionEnum.ERROR;
        }
        return EcspFirstVersionEnum.resolve(firstVersion);
    }

    public static EcspFirstVersionEnum getFirstVersion(String ecspVersion, @Nullable Integer verCap) {
        Integer firstVersion;
        if (T.c((String)ecspVersion)) {
            return EcspFirstVersionEnum.ERROR;
        }
        String[] verisons = ecspVersion.split("\\.");
        if (verisons.length < 1) {
            return EcspFirstVersionEnum.ERROR;
        }
        try {
            firstVersion = Integer.parseInt(verisons[0]);
        }
        catch (NumberFormatException e2) {
            log.error("error ecspVersion format: {}", (Object)ecspVersion);
            return EcspFirstVersionEnum.ERROR;
        }
        return EcspFirstVersionEnum.resolveFromFirstVersionAndVerCap(firstVersion, verCap);
    }

    public static String parseFromInts(int[] ints) {
        return ints[0] + "." + ints[1] + ".0";
    }

    @Nullable
    public static Pattern getEcspVersionPattern(int ecspFirstVersion) {
        if (Objects.equals(ecspFirstVersion, EcspFirstVersionEnum.V1.getVersion())) {
            return ECSP_V1_PATTERN;
        }
        if (Objects.equals(ecspFirstVersion, EcspFirstVersionEnum.V2.getVersion())) {
            return ECSP_V2_PATTERN;
        }
        if (Objects.equals(ecspFirstVersion, EcspFirstVersionEnum.V3.getVersion())) {
            return ECSP_V3_PATTERN;
        }
        log.warn("get ecspFirstVersion pattern error, ecspFirstVersion is :{}", (Object)ecspFirstVersion);
        return null;
    }
}

