/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.manage.message;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.f;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public enum EcspFirstVersionEnum {
    ERROR(-1, null, null, null, null),
    HIGH_IN_COMPATIBLE(-2, EcspVersion.LOW_MAIN_VERSION, EcspVersion.LOW_MAIN_VERSION, EcspVersion.LOW_MAIN_VERSION, EcspVersion.LOW_MAIN_VERSION),
    LOW_IN_COMPATIBLE(-3, EcspVersion.HIGH_MAIN_VERSION, EcspVersion.HIGH_MAIN_VERSION, EcspVersion.HIGH_MAIN_VERSION, EcspVersion.HIGH_MAIN_VERSION),
    V1(1, EcspVersion.parseFitEcspVer("1.3.0"), EcspVersion.parseFitEcspVer("1.2.0"), EcspVersion.parseFitEcspVer("1.2.0"), null),
    V2(2, EcspVersion.parseFitEcspVer("2.3.0"), EcspVersion.parseFitEcspVer("2.2.0"), EcspVersion.parseFitEcspVer("2.2.0"), EcspVersion.parseFitEcspVer("2.0.0")),
    V3(3, EcspVersion.parseFitEcspVer("3.3.0"), EcspVersion.parseFitEcspVer("3.2.0"), EcspVersion.parseFitEcspVer("3.2.0"), EcspVersion.parseFitEcspVer("3.0.0"));

    @Generated
    private static final Logger log;
    private static Map<Integer, EcspFirstVersionEnum> map;
    private int version;
    private int[] eapVers;
    private int[] oswVers;
    private int[] osgVers;
    private int[] oltVers;

    public boolean isInValid() {
        return this.equals((Object)ERROR) || this.equals((Object)HIGH_IN_COMPATIBLE) || this.equals((Object)LOW_IN_COMPATIBLE);
    }

    private EcspFirstVersionEnum(int version, int[] eapVers, int[] oswVers, int[] osgVers, int[] oltVers) {
        this.version = version;
        this.eapVers = eapVers;
        this.oswVers = oswVers;
        this.osgVers = osgVers;
        this.oltVers = oltVers;
    }

    public int getVersion() {
        return this.version;
    }

    public static EcspFirstVersionEnum resolve(int version) {
        EcspFirstVersionEnum escpVersion = map.get(version);
        if (escpVersion != null) {
            return escpVersion;
        }
        log.warn("may in compatibleVersion, first version is {}.", (Object)version);
        if (V1.getVersion() > version) {
            return LOW_IN_COMPATIBLE;
        }
        if (V3.getVersion() < version) {
            return HIGH_IN_COMPATIBLE;
        }
        return ERROR;
    }

    @Nonnull
    private static Set<EcspFirstVersionEnum> resolveVerCap(@Nullable Integer verCap) {
        HashSet<EcspFirstVersionEnum> versionEnums = new HashSet<EcspFirstVersionEnum>();
        if (verCap == null) {
            versionEnums.add(V1);
            return versionEnums;
        }
        if ((verCap & V1.getVersion()) != 0) {
            versionEnums.add(V1);
        }
        if ((verCap & EcspFirstVersionEnum.V2.version) != 0) {
            versionEnums.add(V2);
        }
        if ((verCap & 1 << EcspFirstVersionEnum.V3.version - 1) != 0) {
            versionEnums.add(V3);
        }
        return versionEnums;
    }

    public static EcspFirstVersionEnum resolveFromFirstVersionAndVerCap(int fistVersion, @Nullable Integer verCap) {
        EcspFirstVersionEnum versionEnum = EcspFirstVersionEnum.resolve(fistVersion);
        if (versionEnum.isInValid()) {
            return versionEnum;
        }
        if (verCap == null) {
            return versionEnum;
        }
        Set<EcspFirstVersionEnum> supportVersionEnums = EcspFirstVersionEnum.resolveVerCap(verCap);
        if (CollectionUtils.isEmpty(supportVersionEnums)) {
            return EcspFirstVersionEnum.handleIncompatible(verCap);
        }
        EcspFirstVersionEnum ecspFirstVersionEnum = supportVersionEnums.stream().max(Enum::compareTo).orElse(ERROR);
        if (ecspFirstVersionEnum.compareTo(versionEnum) < 0) {
            return ERROR;
        }
        return ecspFirstVersionEnum;
    }

    private static EcspFirstVersionEnum handleIncompatible(@Nonnull Integer verCap) {
        int index = 1;
        for (int i2 = 0; i2 < 32 && verCap % 2 != 1; ++i2) {
            ++index;
            verCap = verCap >> 1;
        }
        if (index > V3.getVersion()) {
            return HIGH_IN_COMPATIBLE;
        }
        return LOW_IN_COMPATIBLE;
    }

    public static EcspFirstVersionEnum resolveFromVerCap(@Nullable Integer verCap) {
        Set<EcspFirstVersionEnum> supportVersionEnums = EcspFirstVersionEnum.resolveVerCap(verCap);
        EcspFirstVersionEnum supportMax = supportVersionEnums.stream().max(Enum::compareTo).orElse(ERROR);
        if (V3.upperThan(supportMax)) {
            return supportMax;
        }
        return V3;
    }

    public boolean upperThan(@Nonnull EcspFirstVersionEnum ecspFirstVersionEnum) {
        return this.getVersion() > ecspFirstVersionEnum.getVersion();
    }

    public f compatibleType(DeviceTypeEnum deviceTypeEnum, int[] versionNums) {
        if (ERROR.equals((Object)this)) {
            log.warn("unKnow device ecspVersion.");
            return null;
        }
        switch (deviceTypeEnum) {
            case a: {
                return EcspFirstVersionEnum.getCompatibleType(versionNums, this.eapVers);
            }
            case c: {
                return EcspFirstVersionEnum.getCompatibleType(versionNums, this.oswVers);
            }
            case b: {
                return EcspFirstVersionEnum.getCompatibleType(versionNums, this.osgVers);
            }
            case d: {
                return EcspFirstVersionEnum.getCompatibleType(versionNums, this.oltVers);
            }
        }
        log.warn("unKnow device type {} when resolve compatible.", (Object)deviceTypeEnum);
        return null;
    }

    private static f getCompatibleType(int[] deviceVers, int[] controllerVers) {
        if (deviceVers[0] == controllerVers[0]) {
            if (deviceVers[1] == controllerVers[1]) {
                return f.a;
            }
            if (deviceVers[1] < controllerVers[1]) {
                log.warn("LOW_MINOR_VER: {}", (Object)ArrayUtils.toString((Object)controllerVers));
                return f.e;
            }
            log.warn("HIGH_MINOR_VER: {}", (Object)ArrayUtils.toString((Object)controllerVers));
            return f.d;
        }
        if (deviceVers[0] < controllerVers[0]) {
            log.warn("LOW_MAJOR_VER: {}", (Object)ArrayUtils.toString((Object)controllerVers));
            return f.c;
        }
        log.warn("HIGH_MAJOR_VER: {}", (Object)ArrayUtils.toString((Object)controllerVers));
        return f.b;
    }

    static {
        log = LoggerFactory.getLogger(EcspFirstVersionEnum.class);
        map = new HashMap<Integer, EcspFirstVersionEnum>(3);
        for (EcspFirstVersionEnum ecspVersion : EcspFirstVersionEnum.values()) {
            map.put(ecspVersion.getVersion(), ecspVersion);
        }
    }
}

