/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.nameresolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(SelfNameResolver.class);
    private final GrpcServerProperties properties;
    private final SynchronizationContext syncContext;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final boolean usingExecutorResource;
    private Executor executor = null;
    private boolean resolving = false;
    private NameResolver.Listener2 listener = null;

    public SelfNameResolver(GrpcServerProperties properties, NameResolver.Args args) {
        this(properties, args, (SharedResourceHolder.Resource<Executor>)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    public SelfNameResolver(GrpcServerProperties properties, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
        this.executorResource = Objects.requireNonNull(executorResource, "executorResource");
        this.executor = args.getOffloadExecutor();
        this.usingExecutorResource = this.executor == null;
    }

    public String getServiceAuthority() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return this.getOwnAddressString("localhost");
        }
    }

    public final void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        if (this.usingExecutorResource) {
            this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        }
        this.resolve();
    }

    public final void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    private void resolve() {
        log.debug("Scheduled self resolve");
        if (this.resolving || this.executor == null) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener));
    }

    public void shutdown() {
        this.listener = null;
        if (this.executor != null && this.usingExecutorResource) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
    }

    private SocketAddress getOwnAddress() {
        String address = this.properties.getAddress();
        int port = this.properties.getPort();
        InetSocketAddress target = "*".equals(address) ? new InetSocketAddress(port) : new InetSocketAddress(InetAddresses.forString((String)address), port);
        return target;
    }

    private String getOwnAddressString(String fallback) {
        try {
            return this.getOwnAddress().toString().substring(1);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public String toString() {
        return "SelfNameResolver [" + this.getOwnAddressString("<unavailable>") + "]";
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;

        Resolve(NameResolver.Listener2 listener) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
        }

        @Override
        public void run() {
            try {
                this.savedListener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.of((Object)new EquivalentAddressGroup(SelfNameResolver.this.getOwnAddress()))).build());
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("Failed to resolve own address").withCause((Throwable)e));
            }
            finally {
                SelfNameResolver.this.syncContext.execute(() -> {
                    SelfNameResolver.this.resolving = false;
                });
            }
        }
    }
}

