/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import io.grpc.ServerInterceptor;
import io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerInterceptor;
import io.micrometer.observation.ObservationRegistry;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"management.tracing.grpc.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnBean(value={ObservationRegistry.class})
public class GrpcServerMicrometerTraceAutoConfiguration {
    @GrpcGlobalServerInterceptor
    @Order(value=2501)
    public ServerInterceptor globalObservationGrpcServerInterceptorConfigurer(ObservationRegistry observations) {
        return new ObservationGrpcServerInterceptor(observations);
    }
}

