/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.advice;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.devh.boot.grpc.server.advice.GrpcAdvice;
import net.devh.boot.grpc.server.advice.GrpcExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class GrpcAdviceDiscoverer
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(GrpcAdviceDiscoverer.class);
    public static final ReflectionUtils.MethodFilter EXCEPTION_HANDLER_METHODS = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, GrpcExceptionHandler.class);
    private ApplicationContext applicationContext;
    private Map<String, Object> annotatedBeans;
    private Set<Method> annotatedMethods;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.annotatedBeans = this.applicationContext.getBeansWithAnnotation(GrpcAdvice.class);
        this.annotatedBeans.forEach((key, value) -> log.debug("Found gRPC advice: " + key + ", class: " + value.getClass().getName()));
        this.annotatedMethods = this.findAnnotatedMethods();
    }

    private Set<Method> findAnnotatedMethods() {
        return this.annotatedBeans.values().stream().map(Object::getClass).map(this::findAnnotatedMethods).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<Method> findAnnotatedMethods(Class<?> clazz) {
        return MethodIntrospector.selectMethods(clazz, (ReflectionUtils.MethodFilter)EXCEPTION_HANDLER_METHODS);
    }

    public Map<String, Object> getAnnotatedBeans() {
        Assert.state((this.annotatedBeans != null ? 1 : 0) != 0, (String)"@GrpcAdvice annotation scanning failed.");
        return this.annotatedBeans;
    }

    public Set<Method> getAnnotatedMethods() {
        Assert.state((this.annotatedMethods != null ? 1 : 0) != 0, (String)"@GrpcExceptionHandler annotation scanning failed.");
        return this.annotatedMethods;
    }
}

