/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.commom.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.logmanager.c.d;
import com.tplink.smb.omada.logmanager.domain.model.e.g;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.C;
import com.tplink.smb.omada.logmanager.domain.model.log.event.LogStatusDTO;
import com.tplink.smb.omada.logmanager.domain.model.notification.DefaultNotificationConfiguration;
import com.tplink.smb.omada.logmanager.domain.model.notification.Notification;
import com.tplink.smb.omada.logmanager.domain.model.notification.NotificationConfiguration;
import com.tplink.smb.omada.logmanager.domain.model.notification.e;
import com.tplink.smb.omada.logmanager.domain.model.notification.l;
import com.tplink.smb.omada.logmanager.domain.model.sitesetting.OmadaLogSiteSetting;
import com.tplink.smb.omada.logmanager.domain.model.sitesetting.k;
import com.tplink.smb.omada.logmanager.domain.model.sitesetting.u;
import com.tplink.smb.omada.logmanager.port.commom.eventcenter.DeviceEventDTO;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.device.api.internal.dto.LogKeyInfoDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a
implements EventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private u b;
    @Autowired
    private k c;
    @Autowired
    private com.tplink.smb.omada.logmanager.domain.model.a d;
    @Autowired
    private e e;

    public void handleEvent(Event event) {
        a.debug("Receive device log key event: {}", (Object)event);
        if (Objects.isNull(event)) {
            return;
        }
        DeviceEventDTO deviceEventDTO = (DeviceEventDTO)((Object)com.tplink.smb.omada.common.util.x.a((String)((String)event.getMessage()), DeviceEventDTO.class));
        String omadacId = deviceEventDTO.getOmadacId();
        String siteId = deviceEventDTO.getSiteId();
        String deviceType = deviceEventDTO.getDeviceType();
        List<LogKeyInfoDTO> logKeyInfos = deviceEventDTO.getLogKeyInfos();
        if (Objects.isNull(omadacId) || Objects.isNull(siteId) || CollectionUtils.isEmpty(logKeyInfos)) {
            return;
        }
        if (!Objects.equals(DeviceEventDTO.DeviceEventType.ADOPT_SUCCESS.getKey(), deviceEventDTO.getEventType())) {
            return;
        }
        Optional<OmadaLogSiteSetting> omadaLogSiteSettingOptional = this.b.a(new g(omadacId), new i(siteId));
        if (!omadaLogSiteSettingOptional.isPresent()) {
            a.warn("Failed to find omada log site setting, omadacId: {}, siteId: {}", (Object)omadacId, (Object)siteId);
            return;
        }
        OmadaLogSiteSetting omadaLogSiteSetting = omadaLogSiteSettingOptional.get();
        List<Notification> alertNotifications = omadaLogSiteSetting.getAlertNotifications();
        List<Notification> eventNotifications = omadaLogSiteSetting.getEventNotifications();
        HashMap<String, Notification> alertLogKeyNotificationMap = CollectionUtils.isEmpty(alertNotifications) ? new HashMap<String, Notification>() : (Map)alertNotifications.stream().collect(Collectors.toMap(Notification::getOmadaLogEnumKey, notification -> notification, (v1, v2) -> v2, LinkedHashMap::new));
        HashMap<String, Notification> eventLogKeyNotificationMap = CollectionUtils.isEmpty(eventNotifications) ? new HashMap<String, Notification>() : (Map)eventNotifications.stream().collect(Collectors.toMap(Notification::getOmadaLogEnumKey, notification -> notification, (v1, v2) -> v2, LinkedHashMap::new));
        HashMap<String, Boolean> logKeyStatusMap = new HashMap<String, Boolean>();
        for (LogKeyInfoDTO logKeyInfo : logKeyInfos) {
            NotificationConfiguration notificationConfiguration;
            Integer sign = logKeyInfo.getSign();
            String level = logKeyInfo.getLevel();
            String key = logKeyInfo.getKey();
            if (this.a(key) || Objects.isNull(notificationConfiguration = this.a(omadacId, siteId, sign)) || Boolean.FALSE.equals(notificationConfiguration.getAlert()) && Boolean.FALSE.equals(notificationConfiguration.getEvent())) continue;
            notificationConfiguration.setLevel(level);
            if (this.a(alertLogKeyNotificationMap, eventLogKeyNotificationMap, notificationConfiguration, key, deviceType)) continue;
            this.a(alertLogKeyNotificationMap, eventLogKeyNotificationMap, notificationConfiguration, logKeyInfo, deviceType);
            logKeyStatusMap.put(key, notificationConfiguration.getEnable() != false || notificationConfiguration.getEmail() != false || notificationConfiguration.getWebhook() != false);
        }
        omadaLogSiteSetting.setAlertNotifications(new ArrayList<Notification>(alertLogKeyNotificationMap.values()));
        omadaLogSiteSetting.setEventNotifications(new ArrayList<Notification>(eventLogKeyNotificationMap.values()));
        this.c.a(omadaLogSiteSetting, x.a);
        this.d.b(omadacId, siteId, Boolean.TRUE, Boolean.FALSE);
        if (!CollectionUtils.isEmpty(logKeyStatusMap)) {
            this.e.a(LogStatusDTO.builder().omadacId(omadacId).siteId(siteId).keyMap(logKeyStatusMap).build());
        }
    }

    private NotificationConfiguration a(String omadacId, String siteId, Integer sign) {
        if (Objects.isNull(sign)) {
            a.info("Log sign is null, omadacId: {}, siteId: {}", (Object)omadacId, (Object)siteId);
            return null;
        }
        NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().e(false).a(false).b(false).c(false).d(false).a();
        if ((sign & 1) > 0) {
            notificationConfiguration.setEnable(true);
        }
        if ((sign & 2) > 0) {
            notificationConfiguration.setAlert(true);
        }
        if ((sign & 4) > 0) {
            notificationConfiguration.setEvent(true);
        }
        if ((sign & 8) > 0) {
            notificationConfiguration.setEmail(true);
        }
        if ((sign & 0x10) > 0) {
            notificationConfiguration.setWebhook(true);
        }
        return notificationConfiguration;
    }

    private boolean a(String key) {
        if (com.tplink.smb.omada.logmanager.c.d.b.containsKey(key) || com.tplink.smb.omada.logmanager.c.d.d.containsKey(key)) {
            return true;
        }
        if (com.tplink.smb.omada.logmanager.c.d.a.contains(key)) {
            return true;
        }
        return com.tplink.smb.omada.logmanager.c.d.n.contains(key);
    }

    private boolean a(Map<String, Notification> alertLogKeyNotificationMap, Map<String, Notification> eventLogKeyNotificationMap, NotificationConfiguration notificationConfiguration, String key, String deviceType) {
        String deviceTypes;
        Set<String> alertLogKeys = alertLogKeyNotificationMap.keySet();
        Notification alertNotification = alertLogKeyNotificationMap.get(key);
        Set<String> eventLogKeys = eventLogKeyNotificationMap.keySet();
        Notification eventNotification = eventLogKeyNotificationMap.get(key);
        return Boolean.TRUE.equals(notificationConfiguration.getAlert()) && alertLogKeys.contains(key) ? Objects.nonNull(deviceTypes = (String)Optional.ofNullable(alertNotification).map(Notification::getDeviceTypes).orElse(null)) && deviceTypes.contains(deviceType) : Boolean.TRUE.equals(notificationConfiguration.getEvent()) && eventLogKeys.contains(key) && Objects.nonNull(deviceTypes = (String)Optional.ofNullable(eventNotification).map(Notification::getDeviceTypes).orElse(null)) && deviceTypes.contains(deviceType);
    }

    private void a(Map<String, Notification> alertLogKeyNotificationMap, Map<String, Notification> eventLogKeyNotificationMap, NotificationConfiguration notificationConfiguration, LogKeyInfoDTO logKeyInfo, String deviceType) {
        String key = logKeyInfo.getKey();
        String module = logKeyInfo.getModule();
        String shortMsg = logKeyInfo.getName();
        Notification notification = null;
        if (Boolean.TRUE.equals(notificationConfiguration.getAlert())) {
            notification = alertLogKeyNotificationMap.get(key);
        } else if (Boolean.TRUE.equals(notificationConfiguration.getEvent())) {
            notification = eventLogKeyNotificationMap.get(key);
        }
        Object deviceTypes = Optional.ofNullable(notification).map(Notification::getDeviceTypes).orElse(null);
        deviceTypes = Objects.isNull(deviceTypes) ? deviceType : (String)deviceTypes + "_" + deviceType;
        if (Objects.isNull(notification)) {
            notification = Notification.builder().a(l.c).a(key).a(C.a(module)).b(shortMsg).c((String)deviceTypes).a(notificationConfiguration).a();
        } else {
            notification.setDeviceTypes((String)deviceTypes);
        }
        DefaultNotificationConfiguration defaultNotificationConfiguration = DefaultNotificationConfiguration.builder().e(notification.getNotificationConfiguration().getEnable()).a(notification.getNotificationConfiguration().getAlert()).b(notification.getNotificationConfiguration().getEvent()).c(notification.getNotificationConfiguration().getEmail()).d(notification.getNotificationConfiguration().getWebhook()).a(notification.getNotificationConfiguration().getLevel()).a();
        notification.setDefaultNotificationConfiguration(defaultNotificationConfiguration);
        if (Boolean.TRUE.equals(notificationConfiguration.getAlert())) {
            alertLogKeyNotificationMap.put(key, notification);
        } else if (Boolean.TRUE.equals(notificationConfiguration.getEvent())) {
            eventLogKeyNotificationMap.put(key, notification);
        }
    }
}

