/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model.notification;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.F;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.NotificationVO;
import com.tplink.smb.omada.logmanager.c.c;
import com.tplink.smb.omada.logmanager.domain.model.e.g;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.C;
import com.tplink.smb.omada.logmanager.domain.model.notification.DefaultNotificationConfiguration;
import com.tplink.smb.omada.logmanager.domain.model.notification.NotificationConfiguration;
import com.tplink.smb.omada.logmanager.domain.model.notification.l;
import com.tplink.smb.omada.logmanager.port.commom.cache.log.OmadaAlertTypeCache;
import com.tplink.smb.omada.logmanager.port.commom.cache.log.OmadaEventTypeCache;
import com.tplink.smb.omada.logmanager.port.commom.cache.log.OmadaLogTypeCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class Notification
implements com.tplink.smb.omada.common.e.l<Notification> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Notification.class);
    protected final l notificationTypeEnum;
    protected final String omadaLogEnumKey;
    protected final C module;
    protected final String shortMsg;
    protected String deviceTypes;
    protected NotificationConfiguration notificationConfiguration;
    @Nullable
    protected DefaultNotificationConfiguration defaultNotificationConfiguration;

    public Notification(l notificationTypeEnum, String omadaLogEnumKey, C module, String shortMsg, String deviceTypes, NotificationConfiguration notificationConfiguration, DefaultNotificationConfiguration defaultNotificationConfiguration) {
        this.notificationTypeEnum = notificationTypeEnum;
        this.omadaLogEnumKey = omadaLogEnumKey;
        this.module = module;
        this.shortMsg = shortMsg;
        this.deviceTypes = deviceTypes;
        this.notificationConfiguration = notificationConfiguration;
        this.defaultNotificationConfiguration = defaultNotificationConfiguration;
    }

    public Notification() {
        this.notificationTypeEnum = null;
        this.omadaLogEnumKey = null;
        this.module = null;
        this.shortMsg = null;
        this.deviceTypes = null;
        this.notificationConfiguration = null;
        this.defaultNotificationConfiguration = null;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public void setDefaultNotificationConfiguration(DefaultNotificationConfiguration defaultNotificationConfiguration) {
        this.defaultNotificationConfiguration = defaultNotificationConfiguration;
    }

    public void setDeviceTypes(String deviceTypes) {
        this.deviceTypes = deviceTypes;
    }

    public boolean isAlert(String omadaLogEnumKey) {
        if (T.a((String)omadaLogEnumKey) || !omadaLogEnumKey.equals(this.omadaLogEnumKey)) {
            return false;
        }
        return this.notificationConfiguration.getAlert();
    }

    public boolean needEmail(String omadaLogEnumKey) {
        if (T.a((String)omadaLogEnumKey) || !omadaLogEnumKey.equals(this.omadaLogEnumKey)) {
            return false;
        }
        return Boolean.TRUE.equals(this.notificationConfiguration.getEmail());
    }

    public boolean enableWebhook(String omadaLogEnumKey) {
        if (T.a((String)omadaLogEnumKey) || !omadaLogEnumKey.equals(this.omadaLogEnumKey)) {
            return false;
        }
        if (Objects.isNull(this.notificationConfiguration) || Objects.isNull(this.notificationConfiguration.getWebhook())) {
            log.warn("Failed to get notification webhook.omada log key:{}", (Object)omadaLogEnumKey);
            return false;
        }
        return Boolean.TRUE.equals(this.notificationConfiguration.getWebhook());
    }

    public static Notification transferVO(@NonNull Notification notification, @NonNull List<NotificationVO> notificationVOs) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        if (notificationVOs == null) {
            throw new NullPointerException("notificationVOs is marked non-null but is null");
        }
        NotificationVO notificationVO = notificationVOs.stream().filter(item -> T.a((String)notification.getOmadaLogEnumKey(), (String)item.getKey())).findFirst().orElse(null);
        if (Objects.nonNull(notificationVO)) {
            NotificationConfiguration notificationConfiguration = new NotificationConfiguration(notificationVO.getAlert(), notificationVO.getEvent(), notificationVO.getEmail(), Optional.ofNullable(notificationVO.getWebhook()).orElse(notification.getNotificationConfiguration().getWebhook()), notificationVO.getEnable(), notificationVO.getLevel());
            notification.setNotificationConfiguration(notificationConfiguration);
        }
        if (Boolean.TRUE.equals(notification.getNotificationConfiguration().getAlert())) {
            notification.getNotificationConfiguration().setEvent(true);
        }
        return notification;
    }

    public static List<Notification> buildDefaultSiteNotifications(@Nonnull g omadacId, @Nullable i siteId) {
        Map<String, OmadaLogTypeCache.LogType> logTypeMap = OmadaLogTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("omadacId={} log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.nonNull(logType.q()) && logType.q() != false || T.a((String)"License", (String)logType.d()) || Objects.nonNull(logType.p()) && logType.p() != false || !CollectionUtils.isEmpty(logType.r()) && !logType.r().contains(OmadacType.b()) || Notification.a(omadacId.a(), logType)) {
                return;
            }
            NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().b(logType.h()).c(logType.j()).a(logType.i()).d(logType.k()).a(logType.g()).e(logType.i() != false || logType.h() != false).a();
            log.debug("omadacId={},siteId={} initial site setting notification success.", (Object)omadacId.a(), Optional.ofNullable(siteId).map(i::a).orElse(null));
            notifications.add(Notification.builder().a((String)key).a(l.c).a(notificationConfiguration).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultSiteAlertNotifications(@Nonnull g omadacId, @Nullable i siteId) {
        Map<String, OmadaAlertTypeCache.LogType> logTypeMap = OmadaAlertTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("omadacId={} log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.nonNull(logType.n()) && logType.n().booleanValue() || Objects.nonNull(logType.m()) && logType.m().booleanValue()) {
                return;
            }
            if (T.a((String)"License", (String)logType.d())) {
                return;
            }
            if (!CollectionUtils.isEmpty(logType.r()) && !logType.r().contains(OmadacType.b())) {
                return;
            }
            if (Notification.a(omadacId.a(), logType) || Notification.a(omadacId.a(), logType.a(), logType.d())) {
                return;
            }
            NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().c(logType.i()).d(logType.j()).a(logType.g()).e(logType.q()).a();
            log.debug("omadacId={},siteId={} initial site setting notification success.", (Object)omadacId.a(), Optional.ofNullable(siteId).map(i::a).orElse(null));
            notifications.add(Notification.builder().a((String)key).a(l.c).a(notificationConfiguration).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultSiteEventNotifications(@Nonnull g omadacId, @Nullable i siteId) {
        Map<String, OmadaEventTypeCache.LogType> logTypeMap = OmadaEventTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("omadacId={} log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.nonNull(logType.m()) && logType.m().booleanValue() || Objects.nonNull(logType.l()) && logType.l().booleanValue()) {
                return;
            }
            if (T.a((String)"License", (String)logType.d())) {
                return;
            }
            if (!CollectionUtils.isEmpty(logType.q()) && !logType.q().contains(OmadacType.b())) {
                return;
            }
            if (Notification.a(omadacId.a(), logType) || Notification.a(omadacId.a(), logType.a(), logType.d())) {
                return;
            }
            NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().c(logType.h()).d(logType.i()).e(logType.p()).a();
            log.debug("omadacId={},siteId={} initial site setting notification success.", (Object)omadacId.a(), Optional.ofNullable(siteId).map(i::a).orElse(null));
            notifications.add(Notification.builder().a((String)key).a(l.c).a(notificationConfiguration).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultGlobalNotifications(@Nonnull g omadacId) {
        Map<String, OmadaLogTypeCache.LogType> logTypeMap = OmadaLogTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("omadacId={} log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.isNull(logType.p()) || !Boolean.TRUE.equals(logType.p())) {
                return;
            }
            if (T.a((String)"License", (String)logType.d())) {
                return;
            }
            if (!CollectionUtils.isEmpty(logType.r()) && !logType.r().contains(OmadacType.b())) {
                return;
            }
            if (Notification.a(omadacId.a(), logType) || Notification.a(omadacId.a(), logType.a(), logType.d())) {
                return;
            }
            NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().b(logType.h()).c(logType.j()).a(logType.i()).d(logType.k()).a();
            log.debug("omadacId={} initial omadac setting notification success.", (Object)omadacId.a());
            notifications.add(Notification.builder().a((String)key).a(l.b).a(notificationConfiguration).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultGlobalAlertNotifications(@Nonnull g omadacId) {
        Map<String, OmadaAlertTypeCache.LogType> logTypeMap = OmadaAlertTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("omadacId={} log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.isNull(logType.m()) || !Boolean.TRUE.equals(logType.m())) {
                return;
            }
            if (T.a((String)"License", (String)logType.d())) {
                return;
            }
            if (!CollectionUtils.isEmpty(logType.r()) && !logType.r().contains(OmadacType.b())) {
                return;
            }
            if (Notification.a(omadacId.a(), logType) || Notification.a(omadacId.a(), logType.a(), logType.d())) {
                return;
            }
            NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().e(logType.q()).a(logType.g()).c(logType.i()).d(logType.j()).a();
            log.debug("omadacId={} initial omadac setting notification success.", (Object)omadacId.a());
            notifications.add(Notification.builder().a((String)key).a(l.b).a(notificationConfiguration).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultGlobalEventNotifications(@Nonnull g omadacId) {
        Map<String, OmadaEventTypeCache.LogType> logTypeMap = OmadaEventTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.error("omadacId={} log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(4);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.isNull(logType.l()) || !Boolean.TRUE.equals(logType.l())) {
                return;
            }
            if (T.a((String)"License", (String)logType.d())) {
                return;
            }
            if (!CollectionUtils.isEmpty(logType.q()) && !logType.q().contains(OmadacType.b())) {
                return;
            }
            if (Notification.a(omadacId.a(), logType) || Notification.a(omadacId.a(), logType.a(), logType.d())) {
                return;
            }
            NotificationConfiguration notificationConfiguration = NotificationConfiguration.builder().e(logType.p()).c(logType.h()).d(logType.i()).a();
            log.debug("omadacId={} initial omadac setting notification success.", (Object)omadacId.a());
            notifications.add(Notification.builder().a((String)key).a(l.b).a(notificationConfiguration).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultGlobalEventNotificationsForCentralNetwork(@Nonnull g omadacId) {
        log.debug("omadacId: {} build central network global event notification success.", (Object)omadacId);
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Notification notification = Notification.builder().a(l.b).a("DEV_DISCOVER").a(C.d).a(NotificationConfiguration.builder().e(false).a(false).b(true).c(false).d(false).a()).a();
        notifications.add(notification);
        return notifications;
    }

    public static List<Notification> buildDefaultMspNotifications(@Nonnull String mspId) {
        Map<String, OmadaLogTypeCache.LogType> logTypeMap = OmadaLogTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.warn("mspId:{} Failed to get log type cache is empty.", (Object)mspId);
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(10);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.isNull(logType.q()) || !logType.q().booleanValue() || T.a((String)"License", (String)logType.d()) || !CollectionUtils.isEmpty(logType.r()) && !logType.r().contains(OmadacType.b())) {
                return;
            }
            log.trace("mspId:{} initial log msp setting notification success.", (Object)mspId);
            notifications.add(Notification.builder().a((String)key).a(l.a).a(NotificationConfiguration.builder().b(logType.h()).c(logType.j()).a(logType.i()).d(logType.k()).a()).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultMspAlertNotifications(@Nonnull String mspId) {
        Map<String, OmadaAlertTypeCache.LogType> logTypeMap = OmadaAlertTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.warn("mspId:{} Failed to get log type cache is empty.", (Object)mspId);
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(10);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.isNull(logType.n()) || !logType.n().booleanValue() || T.a((String)"License", (String)logType.d()) || !CollectionUtils.isEmpty(logType.r()) && !logType.r().contains(OmadacType.b())) {
                return;
            }
            log.trace("mspId:{} initial log msp setting notification success.", (Object)mspId);
            notifications.add(Notification.builder().a((String)key).a(l.a).a(NotificationConfiguration.builder().e(logType.q()).a(logType.g()).c(logType.i()).d(logType.j()).a()).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public static List<Notification> buildDefaultMspEventNotifications(@Nonnull String mspId) {
        Map<String, OmadaEventTypeCache.LogType> logTypeMap = OmadaEventTypeCache.a();
        if (CollectionUtils.isEmpty(logTypeMap)) {
            log.warn("mspId:{} Failed to get log type cache is empty.", (Object)mspId);
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>(10);
        logTypeMap.forEach((key, logType) -> {
            if (Objects.isNull(logType.m()) || !logType.m().booleanValue() || T.a((String)"License", (String)logType.d()) || !CollectionUtils.isEmpty(logType.q()) && !logType.q().contains(OmadacType.b())) {
                return;
            }
            log.trace("mspId:{} initial log msp setting notification success.", (Object)mspId);
            notifications.add(Notification.builder().a((String)key).a(l.a).a(NotificationConfiguration.builder().e(logType.p()).c(logType.h()).d(logType.i()).a()).a(C.a(logType.d())).a());
        });
        return notifications;
    }

    public NotificationVO toVO() {
        OmadaLogTypeCache.LogType logType;
        NotificationVO notificationVO = new NotificationVO();
        notificationVO.setKey(this.getOmadaLogEnumKey());
        if (Objects.nonNull((Object)this.getModule())) {
            notificationVO.setModule(this.getModule().a());
        }
        if ((logType = OmadaLogTypeCache.a(this.getOmadaLogEnumKey())) != null) {
            notificationVO.setShortMsg(logType.b());
            if (Objects.isNull(notificationVO.getModule())) {
                notificationVO.setModule(logType.d());
            }
            if (!CollectionUtils.isEmpty(logType.m())) {
                notificationVO.setDeviceTypes(new ArrayList<String>(logType.m()));
            }
            if (!CollectionUtils.isEmpty(logType.n())) {
                notificationVO.setClientTypes(new ArrayList<String>(logType.n()));
            }
        }
        if (T.b((String)this.getShortMsg())) {
            notificationVO.setShortMsg(this.getShortMsg());
        }
        if (T.b((String)this.getDeviceTypes())) {
            notificationVO.setDeviceTypes(Arrays.asList(this.getDeviceTypes().split("_")));
        }
        if (this.notificationConfiguration != null) {
            notificationVO.setAlert(this.notificationConfiguration.getAlert());
            notificationVO.setEmail(this.notificationConfiguration.getEmail());
            notificationVO.setEvent(this.notificationConfiguration.getEvent());
            notificationVO.setWebhook(this.notificationConfiguration.getWebhook());
            notificationVO.setEnable(this.notificationConfiguration.getEnable());
            notificationVO.setLevel(this.notificationConfiguration.getLevel());
        }
        return notificationVO;
    }

    public boolean sameValueAs(Notification other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    private static boolean a(String omadacIdorMspId, OmadaLogTypeCache.LogType logType) {
        if (!F.d((String)omadacIdorMspId)) {
            return false;
        }
        if (T.a((String)C.c.a(), (String)logType.d())) {
            return true;
        }
        if (T.a((String)C.d.a(), (String)logType.d()) && !c.cL.contains(logType.a())) {
            return true;
        }
        return c.cM.contains(logType.a());
    }

    private static boolean a(String omadacId, String key, String module) {
        if (!F.e((String)omadacId)) {
            return false;
        }
        if (T.a((String)C.c.a(), (String)module)) {
            return true;
        }
        if (T.a((String)C.d.a(), (String)module) && !c.cO.contains(key)) {
            return true;
        }
        return c.cP.contains(key);
    }

    private static boolean a(String omadacIdorMspId, OmadaAlertTypeCache.LogType logType) {
        if (!F.d((String)omadacIdorMspId)) {
            return false;
        }
        if (T.a((String)C.c.a(), (String)logType.d())) {
            return true;
        }
        if (T.a((String)C.d.a(), (String)logType.d()) && !c.cL.contains(logType.a())) {
            return true;
        }
        return c.cM.contains(logType.a());
    }

    private static boolean a(String omadacIdorMspId, OmadaEventTypeCache.LogType logType) {
        if (!F.d((String)omadacIdorMspId)) {
            return false;
        }
        if (T.a((String)C.c.a(), (String)logType.d())) {
            return true;
        }
        if (T.a((String)C.d.a(), (String)logType.d()) && !c.cL.contains(logType.a())) {
            return true;
        }
        return c.cM.contains(logType.a());
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public l getNotificationTypeEnum() {
        return this.notificationTypeEnum;
    }

    @Generated
    public String getOmadaLogEnumKey() {
        return this.omadaLogEnumKey;
    }

    @Generated
    public C getModule() {
        return this.module;
    }

    @Generated
    public String getShortMsg() {
        return this.shortMsg;
    }

    @Generated
    public String getDeviceTypes() {
        return this.deviceTypes;
    }

    @Generated
    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    @Nullable
    @Generated
    public DefaultNotificationConfiguration getDefaultNotificationConfiguration() {
        return this.defaultNotificationConfiguration;
    }

    @Generated
    public String toString() {
        return "Notification(notificationTypeEnum=" + this.getNotificationTypeEnum() + ", omadaLogEnumKey=" + this.getOmadaLogEnumKey() + ", module=" + this.getModule() + ", shortMsg=" + this.getShortMsg() + ", deviceTypes=" + this.getDeviceTypes() + ", notificationConfiguration=" + this.getNotificationConfiguration() + ", defaultNotificationConfiguration=" + this.getDefaultNotificationConfiguration() + ")";
    }

    @Generated
    public static class a {
        @Generated
        private l a;
        @Generated
        private String b;
        @Generated
        private C c;
        @Generated
        private String d;
        @Generated
        private String e;
        @Generated
        private NotificationConfiguration f;
        @Generated
        private DefaultNotificationConfiguration g;

        @Generated
        a() {
        }

        @Generated
        public a a(l notificationTypeEnum) {
            this.a = notificationTypeEnum;
            return this;
        }

        @Generated
        public a a(String omadaLogEnumKey) {
            this.b = omadaLogEnumKey;
            return this;
        }

        @Generated
        public a a(C module) {
            this.c = module;
            return this;
        }

        @Generated
        public a b(String shortMsg) {
            this.d = shortMsg;
            return this;
        }

        @Generated
        public a c(String deviceTypes) {
            this.e = deviceTypes;
            return this;
        }

        @Generated
        public a a(NotificationConfiguration notificationConfiguration) {
            this.f = notificationConfiguration;
            return this;
        }

        @Generated
        public a a(@Nullable DefaultNotificationConfiguration defaultNotificationConfiguration) {
            this.g = defaultNotificationConfiguration;
            return this;
        }

        @Generated
        public Notification a() {
            return new Notification(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        @Generated
        public String toString() {
            return "Notification.NotificationBuilder(notificationTypeEnum=" + this.a + ", omadaLogEnumKey=" + this.b + ", module=" + this.c + ", shortMsg=" + this.d + ", deviceTypes=" + this.e + ", notificationConfiguration=" + this.f + ", defaultNotificationConfiguration=" + this.g + ")";
        }
    }
}

