/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model.notification;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.NotificationVO;
import com.tplink.smb.omada.logmanager.domain.model.e.g;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.notification.NotificationConfiguration;
import com.tplink.smb.omada.logmanager.domain.model.notification.l;
import com.tplink.smb.omada.logmanager.port.commom.cache.audit.AuditLogCategoryCache;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class AuditLogNotification
implements com.tplink.smb.omada.common.e.l<AuditLogNotification> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditLogNotification.class);
    protected final l notificationTypeEnum;
    protected final String auditCategoryKey;
    protected NotificationConfiguration notificationConfiguration;

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public boolean enableWebhook() {
        if (Objects.isNull(this.notificationConfiguration)) {
            log.warn("Failed to get audit log notification webhook.audit log key:{}", (Object)this.auditCategoryKey);
            return false;
        }
        return Boolean.TRUE.equals(this.notificationConfiguration.getWebhook());
    }

    public static AuditLogNotification transToNotification(@NonNull AuditLogNotification notification, @NonNull List<NotificationVO> notificationVOs) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        if (notificationVOs == null) {
            throw new NullPointerException("notificationVOs is marked non-null but is null");
        }
        NotificationVO notificationVO = notificationVOs.stream().filter(item -> T.a((String)notification.getAuditCategoryKey(), (String)item.getKey())).findFirst().orElse(null);
        if (Objects.isNull(notificationVO)) {
            return notification;
        }
        notification.setNotificationConfiguration(NotificationConfiguration.builder().d(notificationVO.getWebhook()).a());
        return notification;
    }

    public static List<AuditLogNotification> buildDefaultSiteNotifications(@Nonnull g omadacId, @Nonnull i siteId) {
        Map<String, AuditLogCategoryCache.AuditLogCategory> categoryCache = AuditLogCategoryCache.d();
        if (CollectionUtils.isEmpty(categoryCache)) {
            log.warn("omadacId:{},siteId:{}.Failed to get audit log type cache is empty.", (Object)omadacId.a(), (Object)siteId.a());
            return Collections.emptyList();
        }
        ArrayList notifications = new ArrayList(categoryCache.size());
        categoryCache.forEach((key, logCategory) -> {
            if (Boolean.TRUE.equals(logCategory.e())) {
                notifications.add(AuditLogNotification.builder().a((String)key).a(l.c).a(NotificationConfiguration.builder().d(logCategory.f()).a()).a());
            }
        });
        log.info("omadacId:{},siteId:{}.Initial audit log site setting notification success.", (Object)omadacId.a(), (Object)siteId.a());
        return notifications.stream().sorted(Comparator.comparing(AuditLogNotification::getAuditCategoryKey)).collect(Collectors.toList());
    }

    public static List<AuditLogNotification> buildDefaultGlobalNotifications(@Nonnull g omadacId) {
        Map<String, AuditLogCategoryCache.AuditLogCategory> categoryCache = AuditLogCategoryCache.d();
        if (CollectionUtils.isEmpty(categoryCache)) {
            log.warn("omadacId:{} Failed to get audit log type cache is empty.", (Object)omadacId.a());
            return Collections.emptyList();
        }
        ArrayList notifications = new ArrayList(categoryCache.size());
        categoryCache.forEach((key, logCategory) -> {
            if (Boolean.TRUE.equals(logCategory.d())) {
                notifications.add(AuditLogNotification.builder().a((String)key).a(l.b).a(NotificationConfiguration.builder().d(logCategory.f()).a()).a());
            }
        });
        log.info("omadacId:{}.Initial audit log global setting notification success.", (Object)omadacId.a());
        return notifications.stream().sorted(Comparator.comparing(AuditLogNotification::getAuditCategoryKey)).collect(Collectors.toList());
    }

    public static List<AuditLogNotification> buildDefaultGlobalNotificationsForCentralNetwork(@Nonnull g omadacId) {
        log.debug("omadacId: {}, build default global audilt log notification for central network.", (Object)omadacId);
        ArrayList<AuditLogNotification> auditLogNotifications = new ArrayList<AuditLogNotification>();
        AuditLogNotification logNotification = AuditLogNotification.builder().a(l.b).a("LOG").a(NotificationConfiguration.builder().d(false).a()).a();
        auditLogNotifications.add(logNotification);
        AuditLogNotification dataExportNotification = AuditLogNotification.builder().a(l.b).a("DATA_EXPORT").a(NotificationConfiguration.builder().d(false).a()).a();
        auditLogNotifications.add(dataExportNotification);
        AuditLogNotification firmwareNotification = AuditLogNotification.builder().a(l.b).a("FIRMWARE").a(NotificationConfiguration.builder().d(false).a()).a();
        auditLogNotifications.add(firmwareNotification);
        AuditLogNotification siteTemplateNotification = AuditLogNotification.builder().a(l.b).a("SITE_TEMPLATE").a(NotificationConfiguration.builder().d(false).a()).a();
        auditLogNotifications.add(siteTemplateNotification);
        return auditLogNotifications;
    }

    public static List<AuditLogNotification> buildDefaultMspNotifications(@Nonnull String mspId) {
        Map<String, AuditLogCategoryCache.AuditLogCategory> categoryCache = AuditLogCategoryCache.d();
        if (CollectionUtils.isEmpty(categoryCache)) {
            log.warn("mspId:{} Failed to get audit log type cache is empty.", (Object)mspId);
            return Collections.emptyList();
        }
        ArrayList notifications = new ArrayList(categoryCache.size());
        categoryCache.forEach((key, logCategory) -> {
            if (Boolean.TRUE.equals(logCategory.c())) {
                notifications.add(AuditLogNotification.builder().a((String)key).a(l.a).a(NotificationConfiguration.builder().d(logCategory.f()).a()).a());
            }
        });
        log.info("mspId:{}.Initial audit log msp setting notification success.", (Object)mspId);
        return notifications.stream().sorted(Comparator.comparing(AuditLogNotification::getAuditCategoryKey)).collect(Collectors.toList());
    }

    public NotificationVO toVO() {
        NotificationVO notificationVO = new NotificationVO();
        notificationVO.setKey(this.getAuditCategoryKey());
        AuditLogCategoryCache.AuditLogCategory auditLogCategory = AuditLogCategoryCache.a(this.getAuditCategoryKey());
        if (Objects.isNull(auditLogCategory)) {
            log.warn("Audit log category is null for key {}.", (Object)this.getAuditCategoryKey());
        } else {
            notificationVO.setShortMsg(auditLogCategory.b());
        }
        notificationVO.setWebhook(this.getNotificationConfiguration().getWebhook());
        return notificationVO;
    }

    public boolean sameValueAs(AuditLogNotification other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public l getNotificationTypeEnum() {
        return this.notificationTypeEnum;
    }

    @Generated
    public String getAuditCategoryKey() {
        return this.auditCategoryKey;
    }

    @Generated
    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    @Generated
    public AuditLogNotification(l notificationTypeEnum, String auditCategoryKey, NotificationConfiguration notificationConfiguration) {
        this.notificationTypeEnum = notificationTypeEnum;
        this.auditCategoryKey = auditCategoryKey;
        this.notificationConfiguration = notificationConfiguration;
    }

    @Generated
    public static class a {
        @Generated
        private l a;
        @Generated
        private String b;
        @Generated
        private NotificationConfiguration c;

        @Generated
        a() {
        }

        @Generated
        public a a(l notificationTypeEnum) {
            this.a = notificationTypeEnum;
            return this;
        }

        @Generated
        public a a(String auditCategoryKey) {
            this.b = auditCategoryKey;
            return this;
        }

        @Generated
        public a a(NotificationConfiguration notificationConfiguration) {
            this.c = notificationConfiguration;
            return this;
        }

        @Generated
        public AuditLogNotification a() {
            return new AuditLogNotification(this.a, this.b, this.c);
        }

        @Generated
        public String toString() {
            return "AuditLogNotification.AuditLogNotificationBuilder(notificationTypeEnum=" + this.a + ", auditCategoryKey=" + this.b + ", notificationConfiguration=" + this.c + ")";
        }
    }
}

