/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model.mspsetting;

import com.tplink.smb.omada.common.e.e;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.smtpclient.MailServer;
import com.tplink.smb.omada.logmanager.api.external.dto.WebhookConfigVO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogMspSettingDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.RemoteLogSettingDTO;
import com.tplink.smb.omada.logmanager.c.c;
import com.tplink.smb.omada.logmanager.domain.model.mspsetting.LogMspSettingId;
import com.tplink.smb.omada.logmanager.domain.model.notification.Notification;
import com.tplink.smb.omada.logmanager.domain.model.notification.m;
import com.tplink.smb.omada.logmanager.domain.model.sitesetting.RemoteLogSetting;
import com.tplink.smb.omada.logmanager.domain.model.webhook.WebhookConfig;
import com.tplink.smb.omada.logmanager.port.commom.cache.log.i;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@KeepClass
public class LogMspSetting
implements e<LogMspSetting> {
    private LogMspSettingId id;
    private String mspId;
    private MailServer mailServer;
    private List<Notification> notifications;
    private List<Notification> alertNotifications;
    private List<Notification> eventNotifications;
    private WebhookConfig webhookSetting;
    private RemoteLogSetting remoteLogSetting;
    private String version;

    @Nonnull
    public static LogMspSetting buildDefaultSetting(@Nonnull LogMspSettingId settingId, @Nonnull String mspId) {
        return LogMspSetting.builder().a(settingId).a(mspId).a(MailServer.builder().a(Boolean.valueOf(false)).b(Boolean.valueOf(false)).c(Boolean.valueOf(false)).a()).a(Notification.buildDefaultMspNotifications(mspId)).b(Notification.buildDefaultMspAlertNotifications(mspId)).c(Notification.buildDefaultMspEventNotifications(mspId)).a((RemoteLogSetting)((RemoteLogSetting.a)((RemoteLogSetting.a)RemoteLogSetting.builder().a(Boolean.FALSE)).a(c.cf)).b()).a((WebhookConfig)((WebhookConfig.a)WebhookConfig.builder().a(Boolean.FALSE)).b()).b(i.a(i.a.a).c()).a();
    }

    @Nonnull
    public static LogMspSetting buildDefaultSetting(@Nonnull LogMspSettingId settingId, @Nonnull String mspId, i logNotificationVersionEnum) {
        return LogMspSetting.builder().a(settingId).a(mspId).a(MailServer.builder().a(Boolean.valueOf(false)).b(Boolean.valueOf(false)).c(Boolean.valueOf(false)).a()).a(m.a(mspId)).a((RemoteLogSetting)((RemoteLogSetting.a)((RemoteLogSetting.a)RemoteLogSetting.builder().a(Boolean.FALSE)).a(c.cf)).b()).a((WebhookConfig)((WebhookConfig.a)WebhookConfig.builder().a(Boolean.FALSE)).b()).b(logNotificationVersionEnum.c()).a();
    }

    @Nonnull
    public LogMspSetting modifyNotification(@Nonnull List<Notification> notifications) {
        this.notifications = notifications;
        return this;
    }

    @Nonnull
    public LogMspSetting modifyNotificationV2(@Nonnull List<Notification> alertNotifications, @Nonnull List<Notification> eventNotifications) {
        this.alertNotifications = alertNotifications;
        this.eventNotifications = eventNotifications;
        return this;
    }

    @Nonnull
    public LogMspSetting modifyByDTO(@Nonnull OmadaLogMspSettingDTO logMspSettingDTO) {
        this.mailServer = logMspSettingDTO.getMailServer();
        return this;
    }

    @Nonnull
    public LogMspSetting modifyRemoteLogSetting(@Nonnull OmadaLogMspSettingDTO mspSettingDTO) {
        RemoteLogSettingDTO remoteLogSetting = mspSettingDTO.getRemoteLogSetting();
        this.remoteLogSetting = ((RemoteLogSetting.a)((RemoteLogSetting.a)((RemoteLogSetting.a)RemoteLogSetting.builder().a(remoteLogSetting.getEnable())).a(remoteLogSetting.getHost())).a(remoteLogSetting.getPort())).b();
        return this;
    }

    @Nonnull
    public LogMspSetting modifyLogMspSetting(@Nonnull List<Notification> notifications, WebhookConfigVO webhookSetting) {
        this.notifications = notifications;
        if (Objects.nonNull(webhookSetting)) {
            this.webhookSetting = ((WebhookConfig.a)((WebhookConfig.a)WebhookConfig.builder().a(Objects.isNull(webhookSetting.getWebhookEnable()) ? Boolean.FALSE : webhookSetting.getWebhookEnable())).a(webhookSetting.getWebhookId())).b();
        }
        return this;
    }

    @Nonnull
    public LogMspSetting modifyLogMspSettingV2(@Nonnull List<Notification> alertNotifications, @Nonnull List<Notification> eventNotifications, WebhookConfigVO webhookSetting) {
        this.alertNotifications = alertNotifications;
        this.eventNotifications = eventNotifications;
        if (Objects.nonNull(webhookSetting)) {
            this.webhookSetting = ((WebhookConfig.a)((WebhookConfig.a)WebhookConfig.builder().a(Objects.isNull(webhookSetting.getWebhookEnable()) ? Boolean.FALSE : webhookSetting.getWebhookEnable())).a(webhookSetting.getWebhookId())).b();
        }
        return this;
    }

    @Nonnull
    public LogMspSetting modifyWebhookSetting(@Nonnull WebhookConfigVO webhookSetting) {
        this.webhookSetting = ((WebhookConfig.a)((WebhookConfig.a)WebhookConfig.builder().a(Objects.isNull(webhookSetting.getWebhookEnable()) ? Boolean.FALSE : webhookSetting.getWebhookEnable())).a(webhookSetting.getWebhookId())).b();
        return this;
    }

    @Nonnull
    public OmadaLogMspSettingDTO toDTO() {
        return OmadaLogMspSettingDTO.builder().mspId(this.getMspId()).mailServer(this.getMailServer()).build();
    }

    public boolean sameIdentityAs(LogMspSetting other) {
        return this.id.sameValueAs(other.getId());
    }

    @Generated
    LogMspSetting(LogMspSettingId id, String mspId, MailServer mailServer, List<Notification> notifications, List<Notification> alertNotifications, List<Notification> eventNotifications, WebhookConfig webhookSetting, RemoteLogSetting remoteLogSetting, String version) {
        this.id = id;
        this.mspId = mspId;
        this.mailServer = mailServer;
        this.notifications = notifications;
        this.alertNotifications = alertNotifications;
        this.eventNotifications = eventNotifications;
        this.webhookSetting = webhookSetting;
        this.remoteLogSetting = remoteLogSetting;
        this.version = version;
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public LogMspSettingId getId() {
        return this.id;
    }

    @Generated
    public String getMspId() {
        return this.mspId;
    }

    @Generated
    public MailServer getMailServer() {
        return this.mailServer;
    }

    @Generated
    public List<Notification> getNotifications() {
        return this.notifications;
    }

    @Generated
    public List<Notification> getAlertNotifications() {
        return this.alertNotifications;
    }

    @Generated
    public List<Notification> getEventNotifications() {
        return this.eventNotifications;
    }

    @Generated
    public WebhookConfig getWebhookSetting() {
        return this.webhookSetting;
    }

    @Generated
    public RemoteLogSetting getRemoteLogSetting() {
        return this.remoteLogSetting;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setId(LogMspSettingId id) {
        this.id = id;
    }

    @Generated
    public void setMspId(String mspId) {
        this.mspId = mspId;
    }

    @Generated
    public void setMailServer(MailServer mailServer) {
        this.mailServer = mailServer;
    }

    @Generated
    public void setNotifications(List<Notification> notifications) {
        this.notifications = notifications;
    }

    @Generated
    public void setAlertNotifications(List<Notification> alertNotifications) {
        this.alertNotifications = alertNotifications;
    }

    @Generated
    public void setEventNotifications(List<Notification> eventNotifications) {
        this.eventNotifications = eventNotifications;
    }

    @Generated
    public void setWebhookSetting(WebhookConfig webhookSetting) {
        this.webhookSetting = webhookSetting;
    }

    @Generated
    public void setRemoteLogSetting(RemoteLogSetting remoteLogSetting) {
        this.remoteLogSetting = remoteLogSetting;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public static class a {
        @Generated
        private LogMspSettingId a;
        @Generated
        private String b;
        @Generated
        private MailServer c;
        @Generated
        private List<Notification> d;
        @Generated
        private List<Notification> e;
        @Generated
        private List<Notification> f;
        @Generated
        private WebhookConfig g;
        @Generated
        private RemoteLogSetting h;
        @Generated
        private String i;

        @Generated
        a() {
        }

        @Generated
        public a a(LogMspSettingId id) {
            this.a = id;
            return this;
        }

        @Generated
        public a a(String mspId) {
            this.b = mspId;
            return this;
        }

        @Generated
        public a a(MailServer mailServer) {
            this.c = mailServer;
            return this;
        }

        @Generated
        public a a(List<Notification> notifications) {
            this.d = notifications;
            return this;
        }

        @Generated
        public a b(List<Notification> alertNotifications) {
            this.e = alertNotifications;
            return this;
        }

        @Generated
        public a c(List<Notification> eventNotifications) {
            this.f = eventNotifications;
            return this;
        }

        @Generated
        public a a(WebhookConfig webhookSetting) {
            this.g = webhookSetting;
            return this;
        }

        @Generated
        public a a(RemoteLogSetting remoteLogSetting) {
            this.h = remoteLogSetting;
            return this;
        }

        @Generated
        public a b(String version) {
            this.i = version;
            return this;
        }

        @Generated
        public LogMspSetting a() {
            return new LogMspSetting(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        @Generated
        public String toString() {
            return "LogMspSetting.LogMspSettingBuilder(id=" + this.a + ", mspId=" + this.b + ", mailServer=" + this.c + ", notifications=" + this.d + ", alertNotifications=" + this.e + ", eventNotifications=" + this.f + ", webhookSetting=" + this.g + ", remoteLogSetting=" + this.h + ", version=" + this.i + ")";
        }
    }
}

