/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model.mspsetting;

import com.tplink.smb.omada.common.e.e;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.logmanager.api.external.dto.WebhookConfigVO;
import com.tplink.smb.omada.logmanager.domain.model.mspsetting.AuditLogMspSettingId;
import com.tplink.smb.omada.logmanager.domain.model.notification.AuditLogNotification;
import com.tplink.smb.omada.logmanager.domain.model.webhook.WebhookConfig;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@KeepClass
public class AuditLogMspSetting
implements e<AuditLogMspSetting> {
    private AuditLogMspSettingId id;
    private String mspId;
    private List<AuditLogNotification> notifications;
    private WebhookConfig webhookSetting;

    @Nonnull
    public static AuditLogMspSetting buildDefaultSetting(@Nonnull AuditLogMspSettingId settingId, @Nonnull String mspId) {
        return AuditLogMspSetting.builder().a(settingId).a(mspId).a(AuditLogNotification.buildDefaultMspNotifications(mspId)).a((WebhookConfig)((WebhookConfig.a)WebhookConfig.builder().a(Boolean.FALSE)).b()).a();
    }

    @Nonnull
    public AuditLogMspSetting modifyAuditLogMspSetting(@Nonnull List<AuditLogNotification> notifications, WebhookConfigVO webhookSetting) {
        this.notifications = notifications;
        this.webhookSetting = ((WebhookConfig.a)((WebhookConfig.a)WebhookConfig.builder().a(webhookSetting.getWebhookEnable())).a(webhookSetting.getWebhookId())).b();
        return this;
    }

    @Nonnull
    public AuditLogMspSetting modifyWebhookSetting(@Nonnull WebhookConfigVO webhookSetting) {
        this.webhookSetting = ((WebhookConfig.a)((WebhookConfig.a)WebhookConfig.builder().a(Objects.isNull(webhookSetting.getWebhookEnable()) ? Boolean.FALSE : webhookSetting.getWebhookEnable())).a(webhookSetting.getWebhookId())).b();
        return this;
    }

    public boolean sameIdentityAs(AuditLogMspSetting other) {
        return this.id.sameValueAs(other.getId());
    }

    @Generated
    AuditLogMspSetting(AuditLogMspSettingId id, String mspId, List<AuditLogNotification> notifications, WebhookConfig webhookSetting) {
        this.id = id;
        this.mspId = mspId;
        this.notifications = notifications;
        this.webhookSetting = webhookSetting;
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public AuditLogMspSettingId getId() {
        return this.id;
    }

    @Generated
    public String getMspId() {
        return this.mspId;
    }

    @Generated
    public List<AuditLogNotification> getNotifications() {
        return this.notifications;
    }

    @Generated
    public WebhookConfig getWebhookSetting() {
        return this.webhookSetting;
    }

    @Generated
    public void setId(AuditLogMspSettingId id) {
        this.id = id;
    }

    @Generated
    public void setMspId(String mspId) {
        this.mspId = mspId;
    }

    @Generated
    public void setNotifications(List<AuditLogNotification> notifications) {
        this.notifications = notifications;
    }

    @Generated
    public void setWebhookSetting(WebhookConfig webhookSetting) {
        this.webhookSetting = webhookSetting;
    }

    @Generated
    public static class a {
        @Generated
        private AuditLogMspSettingId a;
        @Generated
        private String b;
        @Generated
        private List<AuditLogNotification> c;
        @Generated
        private WebhookConfig d;

        @Generated
        a() {
        }

        @Generated
        public a a(AuditLogMspSettingId id) {
            this.a = id;
            return this;
        }

        @Generated
        public a a(String mspId) {
            this.b = mspId;
            return this;
        }

        @Generated
        public a a(List<AuditLogNotification> notifications) {
            this.c = notifications;
            return this;
        }

        @Generated
        public a a(WebhookConfig webhookSetting) {
            this.d = webhookSetting;
            return this;
        }

        @Generated
        public AuditLogMspSetting a() {
            return new AuditLogMspSetting(this.a, this.b, this.c, this.d);
        }

        @Generated
        public String toString() {
            return "AuditLogMspSetting.AuditLogMspSettingBuilder(id=" + this.a + ", mspId=" + this.b + ", notifications=" + this.c + ", webhookSetting=" + this.d + ")";
        }
    }
}

