/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model.log;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.inform.ap.EapAlertLog;
import com.tplink.smb.omada.device.manage.message.inform.ap.EapSysLog;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.domain.model.a;
import com.tplink.smb.omada.logmanager.domain.model.a.b;
import com.tplink.smb.omada.logmanager.domain.model.log.DeviceLogEntryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.c;
import com.tplink.smb.omada.logmanager.domain.model.log.event.DeviceLogDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.f;
import com.tplink.smb.omada.logmanager.domain.model.log.j;
import com.tplink.smb.omada.logmanager.domain.model.log.k;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.domain.model.notification.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class h {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(h.class);
    @Autowired
    private k b;
    @Autowired
    private a c;
    @Autowired
    private c d;
    @Autowired
    private f e;
    @Autowired
    private com.tplink.smb.omada.logmanager.api.internal.f f;
    @Autowired
    private d g;
    @Autowired
    private j h;
    private static final String i = ";";

    public void a(String omadacId, String siteId, DeviceLogDTO deviceLogDTO) {
        List logs = Optional.ofNullable(deviceLogDTO.getEapSysLog()).map(EapSysLog::getLogs).orElse(Collections.emptyList());
        List alertLogs = Optional.ofNullable(deviceLogDTO.getEapAlertLog()).map(EapAlertLog::getAlertLogs).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(logs) && CollectionUtils.isEmpty(alertLogs)) {
            return;
        }
        ArrayList deviceLogEntryDTO = new ArrayList();
        if (!CollectionUtils.isEmpty(logs)) {
            List eventLogEntryDTO = logs.stream().map(eapSysLogEntry -> DeviceLogEntryDTO.builder().key(eapSysLogEntry.getKey()).content(eapSysLogEntry.getContent()).time(eapSysLogEntry.getTime()).build()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeviceLogEntryDTO>(Comparator.comparing(entry -> {
                StringBuilder stringBuilder = new StringBuilder();
                return stringBuilder.append(entry.getKey()).append(i).append(entry.getContent()).toString();
            }))), ArrayList::new));
            deviceLogEntryDTO.addAll(eventLogEntryDTO);
        }
        if (!CollectionUtils.isEmpty(alertLogs)) {
            List alertLogEntrys = alertLogs.stream().map(eapAlertLogEntry -> DeviceLogEntryDTO.builder().key(eapAlertLogEntry.getKey()).content(eapAlertLogEntry.getContent()).time(eapAlertLogEntry.getTime()).resolve(eapAlertLogEntry.getResolve()).id(eapAlertLogEntry.getId()).update(eapAlertLogEntry.getUpdate()).build()).filter(deviceLogEntry -> !Boolean.TRUE.equals(deviceLogEntry.getResolve())).sorted(Comparator.comparing(DeviceLogEntryDTO::getTime).reversed()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeviceLogEntryDTO>(Comparator.comparing(entry -> {
                StringBuilder stringBuilder = new StringBuilder();
                return stringBuilder.append(entry.getKey()).append(i).append(entry.getContent()).toString();
            }))), ArrayList::new));
            List alertResolveLogEntrys = alertLogs.stream().map(eapAlertLogEntry -> DeviceLogEntryDTO.builder().key(eapAlertLogEntry.getKey()).content(eapAlertLogEntry.getContent()).time(eapAlertLogEntry.getTime()).resolve(eapAlertLogEntry.getResolve()).id(eapAlertLogEntry.getId()).update(eapAlertLogEntry.getUpdate()).build()).filter(deviceLogEntry -> Boolean.TRUE.equals(deviceLogEntry.getResolve()) && Objects.nonNull(deviceLogEntry.getId())).sorted(Comparator.comparing(DeviceLogEntryDTO::getTime).reversed()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DeviceLogEntryDTO>(Comparator.comparing(entry -> {
                StringBuilder stringBuilder = new StringBuilder();
                return stringBuilder.append(entry.getKey()).append(i).append(entry.getContent()).toString();
            }))), ArrayList::new));
            deviceLogEntryDTO.addAll(alertLogEntrys);
            deviceLogEntryDTO.addAll(alertResolveLogEntrys);
        }
        String deviceMac = deviceLogDTO.getDeviceMac();
        String deviceName = deviceLogDTO.getDeviceName();
        HashMap<String, String> macNameMap = new HashMap<String, String>(1);
        macNameMap.put(deviceMac, deviceName);
        ArrayList<w> saveLogs = new ArrayList<w>(logs.size());
        ArrayList<OmadaLogDTO> clientLogs = new ArrayList<OmadaLogDTO>(logs.size());
        Map<String, String> logKeyModuleMap = this.g.a(omadacId, siteId);
        for (DeviceLogEntryDTO logEntry : deviceLogEntryDTO) {
            String logKey = logEntry.getKey();
            if (Objects.equals("AP_DET_LOOP", logKey)) {
                logKey = "OSW_DET_LOOP";
            }
            if (Objects.equals("AP_LOOP_C", logKey)) {
                logKey = "OSW_LOOP_C";
            }
            if (Objects.isNull(logKey) || !logKeyModuleMap.containsKey(logKey)) {
                a.debug("Ignore unknown eap log type: {} from device: {}", (Object)logKey, (Object)deviceMac);
                continue;
            }
            String logContent = logEntry.getContent();
            if (T.c((String)logContent)) {
                a.debug("Ignore empty eap log type: {} from device: {}", (Object)logKey, (Object)deviceMac);
                continue;
            }
            if (Objects.equals("AP_C_FL", logKey)) {
                if (logContent.contains("the user is blocked by Access Control")) {
                    a.debug("Ignore AP_C_FL log with reason of block by acl from device: {}.", (Object)deviceMac);
                    continue;
                }
                if (this.f.a(omadacId, siteId).booleanValue()) {
                    a.debug("Ignore AP_C_FL log from pro device: {}.", (Object)deviceMac);
                    continue;
                }
            }
            if (Objects.equals("AP_C_ENT_OK", logKey) || Objects.equals("DEV_IP_C", logKey) && logContent.contains("0.0.0.0") || this.e.a(omadacId, siteId, DeviceTypeEnum.a, logKey).booleanValue()) continue;
            long currentTimeMillis = System.currentTimeMillis();
            Long logTime = logEntry.getTime();
            if (logTime < com.tplink.smb.omada.logmanager.domain.model.a.b.a((Long)currentTimeMillis, 1)) {
                a.warn("Drop eap log due to illegal timestamp: {} from device: {}.omadacId:{}", new Object[]{logTime, com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), omadacId});
                continue;
            }
            String logModule = logKeyModuleMap.get(logKey);
            OmadaLogDTO omadaLogDTO = this.c.a(omadacId, siteId, logKey, logEntry.getContent(), logEntry.getTime(), DeviceTypeEnum.a, deviceMac, logModule);
            omadaLogDTO.setAlertId(logEntry.getId());
            omadaLogDTO.setResolve(Boolean.valueOf(Boolean.TRUE.equals(logEntry.getResolve())));
            omadaLogDTO.setUpdate(Boolean.valueOf(Boolean.TRUE.equals(logEntry.getUpdate())));
            omadaLogDTO.setMacNameMap(macNameMap);
            if (Objects.equals(logModule, "Client")) {
                clientLogs.add(omadaLogDTO);
                continue;
            }
            Optional.ofNullable(w.b(omadaLogDTO)).ifPresent(saveLogs::add);
        }
        if (!CollectionUtils.isEmpty(saveLogs)) {
            this.h.a(saveLogs);
        }
        if (!CollectionUtils.isEmpty(clientLogs)) {
            this.d.a(clientLogs);
        }
    }
}

