/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model.log.event;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.common.concurrent.thread.c;
import com.tplink.smb.omada.logmanager.config.LogThreadConfigProperties;
import com.tplink.smb.omada.logmanager.domain.model.log.event.d;
import com.tplink.smb.omada.logmanager.domain.model.log.event.e;
import com.tplink.smb.omada.logmanager.domain.model.log.event.f;
import com.tplink.smb.omada.logmanager.domain.model.log.event.g;
import com.tplink.smb.omada.logmanager.domain.model.log.event.h;
import com.tplink.smb.omada.logmanager.domain.model.log.event.i;
import com.tplink.smb.omada.logmanager.port.commom.eventcenter.LogDeviceInformProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LogThreadConfigProperties.class, LogDeviceInformProperties.class})
public class LogExecutorConfiguration {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(LogExecutorConfiguration.class);
    @Autowired
    private MeterRegistry b;

    @Lazy
    @Bean(name={"logDeviceConnectEventWorkGroup"}, destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"logDeviceConnectEventWorkGroup"})
    public ExecutorService logDeviceConnectEventWorkGroup(LogThreadConfigProperties threadConfigProperties) {
        int coreThreadNum = 2;
        int maxThreadNum = 2;
        int executorQueueLength = threadConfigProperties.getExecutorQueueLength();
        String poolName = "log-device-connect-event-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreadNum, maxThreadNum, threadConfigProperties.getKeepAliveMills(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(executorQueueLength), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new d(this));
        executor.allowCoreThreadTimeOut(true);
        return c.a((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"remoteLogEventWorkGroup"}, destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"remoteLogEventWorkGroup"})
    public ExecutorService remoteLogEventWorkGroup(LogThreadConfigProperties threadConfigProperties) {
        int coreThreadNum = threadConfigProperties.getCoreThreadNum();
        int maxThreadNum = threadConfigProperties.getMaxThreadNum();
        int executorQueueLength = threadConfigProperties.getExecutorQueueLength();
        String poolName = "remote-log-event-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreadNum, maxThreadNum, threadConfigProperties.getKeepAliveMills(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(executorQueueLength), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new e(this));
        executor.allowCoreThreadTimeOut(true);
        return c.a((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"omadaLogDstInfoEventWorkGroup"}, destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"omadaLogDstInfoEventWorkGroup"})
    public ExecutorService omadaLogDstInfoEventWorkGroup(LogThreadConfigProperties threadConfigProperties) {
        int coreThreadNum = threadConfigProperties.getCoreThreadNum();
        int maxThreadNum = threadConfigProperties.getMaxThreadNum();
        int executorQueueLength = threadConfigProperties.getExecutorQueueLength();
        String poolName = "log-dst-info-event-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreadNum, maxThreadNum, threadConfigProperties.getKeepAliveMills(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(executorQueueLength), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new f(this));
        executor.allowCoreThreadTimeOut(true);
        return c.a((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"emailLogEventWorkGroup"}, destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"emailLogEventWorkGroup"})
    public ExecutorService emailLogEventWorkGroup(LogThreadConfigProperties threadConfigProperties) {
        int coreThreadNum = threadConfigProperties.getCoreThreadNum();
        int maxThreadNum = threadConfigProperties.getMaxThreadNum();
        int executorQueueLength = threadConfigProperties.getExecutorQueueLength();
        String poolName = "email-log-event-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreadNum, maxThreadNum, threadConfigProperties.getKeepAliveMills(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(executorQueueLength), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new g(this));
        executor.allowCoreThreadTimeOut(true);
        return c.a((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Bean(name={"logDeviceInformWorkGroup"})
    @ConditionalOnMissingBean(name={"logDeviceInformWorkGroup"})
    public ExecutorService logDeviceInformWorkGroup(LogDeviceInformProperties logDeviceInformProperties) {
        int coreSize = logDeviceInformProperties.getCoreThreads();
        int maxSize = logDeviceInformProperties.getMaxThreads();
        String poolName = "log-device-inform-work-group";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, maxSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(logDeviceInformProperties.getQueueCapacity()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new h(this));
        return c.a((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"omadaLogTimeoutResolveEventWorkGroup"}, destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"omadaLogTimeoutResolveEventWorkGroup"})
    public ExecutorService omadaLogTimeoutResolveEventWorkGroup(LogThreadConfigProperties threadConfigProperties) {
        int coreThreadNum = threadConfigProperties.getCoreThreadNum();
        int maxThreadNum = threadConfigProperties.getMaxThreadNum();
        int executorQueueLength = threadConfigProperties.getExecutorQueueLength();
        String poolName = "log-timeout-resolve-event-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreadNum, maxThreadNum, threadConfigProperties.getKeepAliveMills(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(executorQueueLength), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new i(this));
        executor.allowCoreThreadTimeOut(true);
        return c.a((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }
}

