/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.domain.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.log.component.common.utils.JsonUtils;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.logmanager.api.external.dto.LogNotificationCacheDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.domain.model.b;
import com.tplink.smb.omada.logmanager.domain.model.d;
import com.tplink.smb.omada.logmanager.domain.model.e.g;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.A;
import com.tplink.smb.omada.logmanager.domain.model.log.L;
import com.tplink.smb.omada.logmanager.domain.model.log.ak;
import com.tplink.smb.omada.logmanager.domain.model.log.al;
import com.tplink.smb.omada.logmanager.domain.model.log.bo.DstInfoBO;
import com.tplink.smb.omada.logmanager.domain.model.log.bo.MspTimeZoneDstBO;
import com.tplink.smb.omada.logmanager.domain.model.log.bo.OmadacTimeZoneDstBO;
import com.tplink.smb.omada.logmanager.domain.model.log.bo.SiteTimeZoneDstBO;
import com.tplink.smb.omada.logmanager.domain.model.mspsetting.c;
import com.tplink.smb.omada.logmanager.domain.model.notification.Notification;
import com.tplink.smb.omada.logmanager.domain.model.notification.p;
import com.tplink.smb.omada.logmanager.domain.model.omadacsetting.f;
import com.tplink.smb.omada.logmanager.domain.model.sitesetting.k;
import com.tplink.smb.omada.logmanager.port.commom.eventcenter.stomp.StompMessageEvent;
import com.tplink.smb.omada.logmanager.port.commom.service.h;
import com.tplink.smb.omada.logmanager.port.commom.service.o;
import com.tplink.smb.omada.manager.c.x;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private p b;
    @Autowired
    private L c;
    @Autowired
    private ak d;
    @Autowired
    private al e;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.commom.eventcenter.stomp.a f;
    @Autowired
    private com.tplink.smb.omada.logmanager.domain.model.log.p g;
    @Autowired
    private f h;
    @Autowired
    private k i;
    @Autowired
    private h j;
    @Autowired
    @Lazy
    private c k;
    @Autowired
    private EventCenter l;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.commom.service.f m;
    @Autowired
    private o n;

    public List<String> a(String omadacId, String siteId, boolean queryAlert, boolean queryEvent, boolean isRoot) {
        ArrayList<String> logKeys = new ArrayList<String>();
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        if (isRoot) {
            this.a(alertLogs, eventLogs, omadacId);
        } else {
            this.a(alertLogs, eventLogs, omadacId, siteId);
        }
        if (queryAlert) {
            logKeys.addAll(alertLogs);
        }
        if (queryEvent) {
            logKeys.addAll(eventLogs);
        }
        return logKeys;
    }

    public List<String> b(String omadacId, String siteId, boolean queryAlert, boolean queryEvent, boolean isRoot) {
        ArrayList<String> logKeys = new ArrayList<String>();
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        if (isRoot) {
            this.a(alertLogs, eventLogs, omadacId);
        }
        this.a(alertLogs, eventLogs, omadacId, siteId);
        if (queryAlert) {
            logKeys.addAll(alertLogs);
        }
        if (queryEvent) {
            logKeys.addAll(eventLogs);
        }
        return logKeys;
    }

    public List<String> a(String omadacId, String siteId) {
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.a(alertLogs, eventLogs, omadacId);
        this.a(alertLogs, eventLogs, omadacId, siteId);
        return alertLogs;
    }

    public List<String> b(String omadacId, String siteId) {
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.a(alertLogs, eventLogs, omadacId);
        this.a(alertLogs, eventLogs, omadacId, siteId);
        return eventLogs;
    }

    public List<String> a(String omadacId) {
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.a(alertLogs, eventLogs, omadacId);
        return alertLogs;
    }

    public List<String> b(String omadacId) {
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.a(alertLogs, eventLogs, omadacId);
        return eventLogs;
    }

    public List<String> a(String omadacId, boolean queryAlert, boolean queryEvent) {
        ArrayList<String> logKeys = new ArrayList<String>();
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.a(alertLogs, eventLogs, omadacId);
        if (queryAlert) {
            logKeys.addAll(alertLogs);
        }
        if (queryEvent) {
            logKeys.addAll(eventLogs);
        }
        return logKeys;
    }

    public List<String> a(String omadacId, String siteId, Boolean queryAlert, Boolean queryEvent) {
        ArrayList<String> logKeys = new ArrayList<String>();
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.a(alertLogs, eventLogs, omadacId, siteId);
        if (queryAlert.booleanValue()) {
            logKeys.addAll(alertLogs);
        }
        if (queryEvent.booleanValue()) {
            logKeys.addAll(eventLogs);
        }
        return logKeys;
    }

    public List<String> a(String mspId, Boolean queryAlert, Boolean queryEvent) {
        ArrayList<String> logKeys = new ArrayList<String>();
        ArrayList<String> alertLogs = new ArrayList<String>();
        ArrayList<String> eventLogs = new ArrayList<String>();
        this.b(alertLogs, eventLogs, mspId);
        if (queryAlert.booleanValue()) {
            logKeys.addAll(alertLogs);
        }
        if (queryEvent.booleanValue()) {
            logKeys.addAll(eventLogs);
        }
        return logKeys;
    }

    public Set<String> a(String omadacId, String siteId, Boolean isRoot) {
        List<Notification> omadacSettingNotifications;
        List<Notification> siteSettingNotifications;
        HashSet<String> logKeys = new HashSet<String>();
        if (Objects.nonNull(siteId) && !CollectionUtils.isEmpty(siteSettingNotifications = this.b.a(new g(omadacId), new i(siteId)))) {
            siteSettingNotifications.forEach(notification -> logKeys.add(notification.getOmadaLogEnumKey()));
        }
        if (Objects.nonNull(isRoot) && isRoot.booleanValue() && !CollectionUtils.isEmpty(omadacSettingNotifications = this.b.a(new g(omadacId)))) {
            omadacSettingNotifications.forEach(notification -> logKeys.add(notification.getOmadaLogEnumKey()));
        }
        a.debug("logKeys:{}", logKeys);
        return logKeys;
    }

    public void a(g omadacId, String siteId) {
        long siteCount = 0L;
        if (Objects.nonNull(siteId)) {
            siteCount = this.c.b(omadacId, new i(siteId));
            this.a(omadacId.a(), siteId, siteCount, com.tplink.smb.omada.common.q.c.g.a());
        }
        long globalCount = this.c.b(omadacId);
        this.a(omadacId.a(), siteId, globalCount + siteCount, com.tplink.smb.omada.common.q.c.f.a());
    }

    public void b(String mspId, Boolean clearMspCache, Boolean clearAlertCache) {
        this.clearMspRelatedCache(mspId, clearMspCache, clearAlertCache);
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(a.class, (TypeReference)new b(this), "clearMspRelatedCache", new Class[]{String.class, Boolean.class, Boolean.class}, new Object[]{mspId, clearMspCache, clearAlertCache});
        this.n.a(requestDTO);
    }

    @KeepMethod
    public void clearMspRelatedCache(String mspId, Boolean clearMspCache, Boolean clearAlertCache) {
        a.debug("Node id: " + com.tplink.smb.omada.common.util.system.a.h() + "\u2014\u2014> clearMspRelatedCache");
        if (clearAlertCache.booleanValue()) {
            this.g.a(mspId);
        }
        if (clearMspCache.booleanValue()) {
            this.k.b(mspId);
        }
        if (OmadacType.s()) {
            this.l.send("omada.manager.configuration.site.setting", ((Event.EventBuilder)((Event.EventBuilder)Event.builder().message((Object)JsonUtils.bean2Json((Object)LogNotificationCacheDTO.builder().omadacIdOrMspId(mspId).build()))).filterKey("log_msp_notification_modified")).build());
        }
        this.c(mspId);
    }

    public void c(String omadacId, Boolean clearGlobalCache, Boolean clearAlertCache) {
        this.clearGlobalRelatedCacheCluster(omadacId, clearAlertCache, clearGlobalCache);
        this.logAlertNumCacheCluster(omadacId);
        this.a(new g(omadacId));
        OmadaClusterUniversalRequestDTO requestDTO1 = new OmadaClusterUniversalRequestDTO(a.class, (TypeReference)new com.tplink.smb.omada.logmanager.domain.model.c(this), "clearGlobalRelatedCacheCluster", new Class[]{String.class, Boolean.class, Boolean.class}, new Object[]{omadacId, clearAlertCache, clearGlobalCache});
        this.n.a(requestDTO1);
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(a.class, (TypeReference)new d(this), "logAlertNumCacheCluster", new Class[]{String.class}, new Object[]{omadacId});
        this.n.a(requestDTO);
    }

    @KeepMethod
    public void logAlertNumCacheCluster(String omadacId) {
        a.debug("Node id: " + com.tplink.smb.omada.common.util.system.a.h() + "\u2014\u2014> logAlertNumCacheCluster");
        this.g.d(new g(omadacId));
    }

    @KeepMethod
    public void clearGlobalRelatedCacheCluster(String omadacId, Boolean clearAlertCache, Boolean clearGlobalCache) {
        a.debug("Node id: " + com.tplink.smb.omada.common.util.system.a.h() + "\u2014\u2014> clearGlobalRelatedCacheCluster");
        if (clearAlertCache.booleanValue()) {
            this.g.b(new g(omadacId));
        }
        if (clearGlobalCache.booleanValue()) {
            this.h.b(new g(omadacId));
        }
        if (OmadacType.s()) {
            this.l.send("omada.manager.configuration.site.setting", ((Event.EventBuilder)((Event.EventBuilder)Event.builder().message((Object)JsonUtils.bean2Json((Object)LogNotificationCacheDTO.builder().omadacIdOrMspId(omadacId).build()))).filterKey("log_global_notification_modified")).build());
        }
    }

    public void b(String omadacId, String siteId, Boolean clearSiteCache, Boolean clearAlertCache) {
        if (clearAlertCache.booleanValue()) {
            this.g.a(new g(omadacId), new i(siteId));
        }
        if (clearSiteCache.booleanValue()) {
            this.i.i(new g(omadacId), new i(siteId), x.a);
        }
        if (OmadacType.s()) {
            this.l.send("omada.manager.configuration.site.setting", ((Event.EventBuilder)((Event.EventBuilder)Event.builder().message((Object)JsonUtils.bean2Json((Object)LogNotificationCacheDTO.builder().omadacIdOrMspId(omadacId).siteId(siteId).build()))).filterKey("log_site_notification_modified")).build());
        }
        this.g.d(new g(omadacId));
        this.a(new g(omadacId), new i(siteId));
    }

    public void a(g omadacId) {
        this.a(omadacId.a(), null, this.c.b(omadacId), com.tplink.smb.omada.common.q.c.f.a());
    }

    public void a(g omadacId, i siteId) {
        this.a(omadacId.a(), siteId.a(), this.c.b(omadacId, siteId), com.tplink.smb.omada.common.q.c.g.a());
    }

    public void c(String mspId) {
        long mspCount = this.c.c(mspId);
        this.a(mspId, null, mspCount, com.tplink.smb.omada.common.q.c.s.a());
    }

    private void a(List<String> alertLogs, List<String> eventLogs, String omadacId, String siteId) {
        List<Notification> siteSettingNotifications = this.b.a(new g(omadacId), new i(siteId));
        if (CollectionUtils.isEmpty(siteSettingNotifications)) {
            return;
        }
        this.m.a(omadacId, siteId, siteSettingNotifications).forEach(notification -> {
            if (notification.getNotificationConfiguration().getAlert().booleanValue()) {
                alertLogs.add(notification.getOmadaLogEnumKey());
            }
            if (notification.getNotificationConfiguration().getEvent().booleanValue()) {
                eventLogs.add(notification.getOmadaLogEnumKey());
            }
        });
    }

    private void a(List<String> alertLogs, List<String> eventLogs, String omadacId) {
        List<Notification> omadacSettingNotifications = this.b.a(new g(omadacId));
        if (CollectionUtils.isEmpty(omadacSettingNotifications)) {
            return;
        }
        List<Notification> globalNotifications = this.m.a(omadacId, omadacSettingNotifications);
        if (this.j.a(omadacId).a(com.tplink.smb.omada.common.f.c.a)) {
            omadacSettingNotifications = this.m.b(omadacId, globalNotifications);
        }
        omadacSettingNotifications.forEach(notificationDO -> {
            if (notificationDO.getNotificationConfiguration().getAlert().booleanValue()) {
                alertLogs.add(notificationDO.getOmadaLogEnumKey());
            }
            if (notificationDO.getNotificationConfiguration().getEvent().booleanValue()) {
                eventLogs.add(notificationDO.getOmadaLogEnumKey());
            }
        });
    }

    private void b(List<String> alertLogs, List<String> eventLogs, String mspId) {
        List<Notification> mspNotification = this.b.a(mspId);
        if (CollectionUtils.isEmpty(mspNotification)) {
            return;
        }
        this.m.c(mspId, mspNotification).forEach(notification -> {
            if (notification.getNotificationConfiguration().getAlert().booleanValue()) {
                alertLogs.add(notification.getOmadaLogEnumKey());
            }
            if (notification.getNotificationConfiguration().getEvent().booleanValue()) {
                eventLogs.add(notification.getOmadaLogEnumKey());
            }
        });
    }

    private void a(String omadacId, String siteId, Long count, int alertType) {
        StompMessageEvent event = new StompMessageEvent();
        event.setOmadacId(omadacId);
        event.setSiteId(siteId);
        event.setEventType(alertType);
        event.setData(count);
        this.f.a(event);
    }

    public String a(@Nonnull g omadacId, @Nullable i siteId, String format, long timeStamp) {
        DstInfoBO dstInfoBO;
        String timeZone;
        if (siteId == null) {
            Optional<OmadacTimeZoneDstBO> omadacTimeZoneDstBOOptional = this.d.a(omadacId);
            if (!omadacTimeZoneDstBOOptional.isPresent() || Objects.isNull(omadacTimeZoneDstBOOptional.get().getTimeZone()) || Objects.isNull(omadacTimeZoneDstBOOptional.get().getDstInfo())) {
                a.warn("Failed to get omadac dst.omadacId:{},omadacTimeZoneDstBOOptional:{}", (Object)omadacId.a(), (Object)JsonUtils.bean2Json(omadacTimeZoneDstBOOptional));
                return W.a((Long)timeStamp, (String)format);
            }
            timeZone = omadacTimeZoneDstBOOptional.get().getTimeZone();
            dstInfoBO = omadacTimeZoneDstBOOptional.get().getDstInfo();
        } else {
            Optional<SiteTimeZoneDstBO> siteTimeZoneDstBOOptional = this.e.a(omadacId, siteId);
            if (!siteTimeZoneDstBOOptional.isPresent() || Objects.isNull(siteTimeZoneDstBOOptional.get().getTimeZone()) || Objects.isNull(siteTimeZoneDstBOOptional.get().getDstInfo())) {
                a.warn("Failed to get site dst.omadacId:{},siteTimeZoneDstBOOptional:{}", (Object)omadacId.a(), (Object)JsonUtils.bean2Json(siteTimeZoneDstBOOptional));
                return W.a((Long)timeStamp, (String)format);
            }
            timeZone = siteTimeZoneDstBOOptional.get().getTimeZone();
            dstInfoBO = siteTimeZoneDstBOOptional.get().getDstInfo();
        }
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timeZone))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfoBO)) {
            localDateTime = localDateTime.plus(dstInfoBO.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    public String a(String format, long timeStamp, OmadacTimeZoneDstBO omadacTimeZoneWithDst) {
        if (Objects.isNull(omadacTimeZoneWithDst) || Objects.isNull(omadacTimeZoneWithDst.getTimeZone()) || Objects.isNull(omadacTimeZoneWithDst.getDstInfo())) {
            return W.a((Long)timeStamp, (String)format);
        }
        String timeZone = omadacTimeZoneWithDst.getTimeZone();
        DstInfoBO dstInfoBO = omadacTimeZoneWithDst.getDstInfo();
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timeZone))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfoBO)) {
            localDateTime = localDateTime.plus(dstInfoBO.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    public String a(String format, long timeStamp, SiteTimeZoneDstBO siteTimeZoneWithDst) {
        if (Objects.isNull(siteTimeZoneWithDst) || Objects.isNull(siteTimeZoneWithDst.getTimeZone()) || Objects.isNull(siteTimeZoneWithDst.getDstInfo())) {
            return W.a((Long)timeStamp, (String)format);
        }
        String timeZone = siteTimeZoneWithDst.getTimeZone();
        DstInfoBO dstInfoBO = siteTimeZoneWithDst.getDstInfo();
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timeZone))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfoBO)) {
            localDateTime = localDateTime.plus(dstInfoBO.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    public String a(@Nonnull String mspId, String format, long timeStamp) {
        Optional<MspTimeZoneDstBO> mspTimeZoneWithDst = this.d.a(mspId);
        if (!mspTimeZoneWithDst.isPresent()) {
            return W.a((Long)timeStamp, (String)format);
        }
        String timeZone = mspTimeZoneWithDst.get().getTimeZone();
        DstInfoBO dstInfoBO = mspTimeZoneWithDst.get().getDstInfo();
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timeZone))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfoBO)) {
            localDateTime = localDateTime.plus(dstInfoBO.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    public String a(String format, long timeStamp, MspTimeZoneDstBO mspTimeZoneWithDst) {
        if (Objects.isNull(mspTimeZoneWithDst) || Objects.isNull(mspTimeZoneWithDst.getTimeZone()) || Objects.isNull(mspTimeZoneWithDst.getDstInfo())) {
            return W.a((Long)timeStamp, (String)format);
        }
        String timeZone = mspTimeZoneWithDst.getTimeZone();
        DstInfoBO dstInfoBO = mspTimeZoneWithDst.getDstInfo();
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timeZone))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfoBO)) {
            localDateTime = localDateTime.plus(dstInfoBO.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    public String a(@Nonnull g omadacId, String format, long timeStamp) {
        Optional<OmadacTimeZoneDstBO> omadacTimeZoneDstBOOptional = this.d.a(omadacId);
        if (!omadacTimeZoneDstBOOptional.isPresent()) {
            return W.a((Long)timeStamp, (String)format);
        }
        String timeZone = omadacTimeZoneDstBOOptional.get().getTimeZone();
        DstInfoBO dstInfoBO = omadacTimeZoneDstBOOptional.get().getDstInfo();
        LocalDateTime localDateTime = new Date(timeStamp).toInstant().atOffset(ZoneOffset.of(P.b((String)timeZone))).toLocalDateTime();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        if (this.a(timeStamp, dstInfoBO)) {
            localDateTime = localDateTime.plus(dstInfoBO.getOffset(), ChronoUnit.MILLIS);
        }
        return localDateTime.format(timeFormatter);
    }

    private boolean a(long currentTime, DstInfoBO dstInfo) {
        return Boolean.TRUE.equals(dstInfo.getEnable()) && (currentTime > dstInfo.getStartTime() && currentTime < dstInfo.getEndTime() || currentTime > dstInfo.getLastStart() && currentTime < dstInfo.getLastEnd() || currentTime > dstInfo.getNextStart() && currentTime < dstInfo.getNextEnd());
    }

    public OmadaLogDTO a(String omadacId, String siteId, String key, String content, Long time, DeviceTypeEnum deviceType, String deviceMac, String module) {
        OmadaLogDTO omadaLogDTO = new OmadaLogDTO();
        omadaLogDTO.setOmadacId(omadacId);
        if (Objects.equals(key, A.aq.a())) {
            String newContent = com.tplink.smb.omada.logmanager.port.commom.f.c.a(deviceType, deviceMac, content);
            omadaLogDTO.setContent(newContent);
        } else if (Objects.equals(key, A.aX.a())) {
            String newContent = com.tplink.smb.omada.logmanager.port.commom.f.c.a(content);
            omadaLogDTO.setContent(newContent);
        } else {
            omadaLogDTO.setContent(content);
        }
        omadaLogDTO.setTime(new Date(time));
        omadaLogDTO.setOmadaLogKey(key);
        omadaLogDTO.setModule(module);
        omadaLogDTO.setDeviceType(deviceType);
        omadaLogDTO.setSiteId(siteId);
        omadaLogDTO.setDeviceMac(deviceMac);
        return omadaLogDTO;
    }

    public String a(String content, Map<String, String> macToNameMap) {
        Matcher devMacMatcher = com.tplink.smb.omada.logmanager.c.c.aB.matcher(content);
        while (devMacMatcher.find()) {
            String devMac = devMacMatcher.group(2);
            String name = macToNameMap.get(devMac);
            if (T.a((String)name)) continue;
            content = content.replace(devMacMatcher.group(0), name);
        }
        Matcher clientMacMatcher = com.tplink.smb.omada.logmanager.c.c.aD.matcher(content);
        while (clientMacMatcher.find()) {
            String clientMac = clientMacMatcher.group(1);
            String name = macToNameMap.get(clientMac);
            if (T.a((String)name)) continue;
            content = content.replace(clientMacMatcher.group(0), name);
        }
        return content;
    }
}

