/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.radius.radiusserver;

import com.tplink.cdd.component.aaa.server.api.RadiusApiService;
import com.tplink.cdd.component.aaa.server.dto.NasApiDTO;
import com.tplink.cdd.component.aaa.server.dto.UserApiDTO;
import com.tplink.cdd.component.aaa.server.dto.UserInfoRequestDTO;
import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.attribute.type.StringAttribute;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetwork;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wireless.ssid.dto.q;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.c;
import com.tplink.smb.omada.manager.device.domain.model.device.o;
import com.tplink.smb.omada.manager.device.domain.model.device.osg.m;
import com.tplink.smb.omada.manager.radius.radiusserver.UserAccessInfoDTO;
import com.tplink.smb.omada.manager.radius.radiusserver.b;
import com.tplink.smb.omada.manager.radius.radiusserver.g;
import com.tplink.smb.omada.manager.radius.radiusserver.h;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class e
implements RadiusApiService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    private h b;
    private static final OperationResponse<?> c = new OperationResponse(com.tplink.smb.omada.common.g.b.oU);

    public Optional<UserApiDTO> getUserInfo(RequestCtx requestCtx) {
        RadiusRequest radiusRequest = requestCtx.getRequest();
        Optional<String> usernameOpt = this.a(radiusRequest, 1);
        if (!usernameOpt.isPresent()) {
            a.debug("Failed to find username");
            return Optional.empty();
        }
        Optional<String> nasIp = this.c(radiusRequest, "NAS-IP-Address");
        Optional<String> calledStationId = this.b(radiusRequest, "Called-Station-Id");
        if (!nasIp.isPresent() || !calledStationId.isPresent()) {
            a.debug("Failed to find calledStationId");
            return this.a(radiusRequest, usernameOpt.get());
        }
        b calledStationIdInfo = g.a(calledStationId.get());
        if (calledStationIdInfo == null) {
            a.debug("Invalid calledStationId {}", (Object)calledStationId.get());
            return this.a(radiusRequest, usernameOpt.get());
        }
        o device = this.b.a(new G(calledStationIdInfo.a()));
        if (device == null) {
            a.debug("Failed to find device by mac {}, may be non omada managed device or WPA-Enterprise device.", (Object)calledStationIdInfo.a());
            return this.a(radiusRequest, usernameOpt.get());
        }
        UserApiDTO userApiDTO = new UserApiDTO();
        if (device instanceof c) {
            OperationResponse response;
            Optional<q> ssidOpt = this.b.a((c)device, calledStationIdInfo.d());
            if (!ssidOpt.isPresent()) {
                a.debug("Failed to find ssid {}", (Object)calledStationIdInfo.d());
            }
            if (!(response = this.a(userApiDTO, (c)device, nasIp.get(), ssidOpt, usernameOpt.get(), username -> this.b.a(device.p(), device.n(), (String)username))).success()) {
                return Optional.empty();
            }
        } else if (device instanceof m) {
            Optional<LanNetwork> lanNetwork = this.b.a((m)device, Integer.valueOf(calledStationIdInfo.d()));
            if (!lanNetwork.isPresent()) {
                return Optional.empty();
            }
            com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g radiusUser = this.b.a(device.p(), device.n(), usernameOpt.get());
            if (radiusUser == null) {
                return Optional.empty();
            }
            OperationResponse response = this.a(userApiDTO, (m)device, lanNetwork.get(), nasIp.get(), radiusUser);
            if (!response.success()) {
                return Optional.empty();
            }
        } else {
            com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g radiusUser = this.b.a(device.p(), device.n(), usernameOpt.get());
            if (radiusUser == null) {
                return Optional.empty();
            }
            userApiDTO.setPassword(radiusUser.k());
            userApiDTO.setSite(device.n().a());
        }
        return Optional.of(userApiDTO);
    }

    public Optional<UserApiDTO> getUserInfo(UserInfoRequestDTO userInfoRequestDTO) {
        String realUsername = userInfoRequestDTO.getUsername();
        if (realUsername == null) {
            a.debug("Failed to find username");
            return Optional.empty();
        }
        if (userInfoRequestDTO.getAuthType() == null) {
            a.debug("Failed to get authType");
            return Optional.empty();
        }
        switch (userInfoRequestDTO.getAuthType()) {
            case USER_ACCESS: {
                return this.a((RadiusRequest)userInfoRequestDTO.getAccessRequest(), realUsername);
            }
            case MAC: {
                return this.a(realUsername);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<NasApiDTO> getNasInfo(InetSocketAddress remoteAddress, RadiusRequest radiusRequest) {
        Optional<String> secrectOpt = this.b.a();
        if (!secrectOpt.isPresent()) {
            a.debug("Failed to find radius server secrect.");
            return Optional.empty();
        }
        String secrect = secrectOpt.get();
        Optional<String> nasIp = this.c(radiusRequest, "NAS-IP-Address");
        Optional<String> calledStationId = this.b(radiusRequest, "Called-Station-Id");
        if (!nasIp.isPresent() || !calledStationId.isPresent()) {
            a.debug("Failed to find calledStationId");
            return Optional.of(NasApiDTO.builder().secretKey(secrect).authType(AuthType.USER_ACCESS).build());
        }
        b calledStationIdInfo = g.a(calledStationId.get());
        if (calledStationIdInfo == null) {
            a.debug("Invalid calledStationId {}", (Object)calledStationId.get());
            return Optional.of(NasApiDTO.builder().secretKey(secrect).authType(AuthType.USER_ACCESS).build());
        }
        o device = this.b.a(new G(calledStationIdInfo.a()));
        if (device == null) {
            a.debug("Failed to find device by mac {}, may be non omada managed device or WPA-Enterprise device.", (Object)calledStationIdInfo.a());
            return Optional.of(NasApiDTO.builder().secretKey(secrect).authType(AuthType.USER_ACCESS).build());
        }
        NasApiDTO nasApiDTO = new NasApiDTO();
        nasApiDTO.setSecretKey(secrect);
        if (device instanceof c) {
            OperationResponse response;
            Optional<q> ssidOpt = this.b.a((c)device, calledStationIdInfo.d());
            if (!ssidOpt.isPresent()) {
                a.debug("Failed to find ssid {}", (Object)calledStationIdInfo.d());
            }
            if ((response = this.a(nasApiDTO, device, nasIp.get(), ssidOpt)).success()) return Optional.of(nasApiDTO);
            return Optional.empty();
        }
        if (device instanceof m) {
            m osg = (m)device;
            this.a(device, calledStationIdInfo, nasApiDTO, nasIp.get());
            if (nasApiDTO.getAuthType() != null) return Optional.of(nasApiDTO);
            if (!Objects.equals(nasIp.get(), osg.dG().a())) return Optional.empty();
            nasApiDTO.setAuthType(AuthType.USER_ACCESS);
            return Optional.of(nasApiDTO);
        } else {
            nasApiDTO.setAuthType(AuthType.USER_ACCESS);
        }
        return Optional.of(nasApiDTO);
    }

    private void a(o device, b calledStationIdInfo, NasApiDTO nasApiDTO, String nasIp) {
        if (!Boolean.TRUE.equals(device.m())) {
            return;
        }
        Optional<q> ssidOpt = this.b.a((m)device, calledStationIdInfo.d());
        if (ssidOpt.isEmpty()) {
            return;
        }
        this.a(nasApiDTO, device, nasIp, ssidOpt);
    }

    private OperationResponse a(UserApiDTO userApiDTO, c ap, String nasIp, Optional<q> ssidOpt, String username, Function<String, com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g> findRadiusUser) {
        if (!ssidOpt.isPresent()) {
            com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g radiusUser = findRadiusUser.apply(username);
            if (radiusUser == null) {
                return c;
            }
            userApiDTO.setPassword(radiusUser.k());
            userApiDTO.setSite(radiusUser.h().a());
            return OperationResponse.SUCCESS;
        }
        q ssid = ssidOpt.get();
        if (Objects.nonNull(ssid.z()) && !Objects.equals(nasIp, ap.dm().a())) {
            a.debug("Handle portl of device {}", (Object)ap.d_());
            com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g radiusUser = findRadiusUser.apply(username);
            if (radiusUser == null) {
                return c;
            }
            userApiDTO.setPassword(radiusUser.k());
            return OperationResponse.SUCCESS;
        }
        switch (ssid.r()) {
            case c: {
                com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g wpaUser = findRadiusUser.apply(username);
                if (wpaUser == null) {
                    return c;
                }
                userApiDTO.setPassword(wpaUser.k());
                userApiDTO.setSite(ap.n().a());
                break;
            }
            case a: 
            case d: {
                if (!this.b.a(ap.p(), ap.n(), ssid)) {
                    return OperationResponse.GENERAL_ERROR;
                }
                com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g macUser = findRadiusUser.apply(username);
                if (macUser == null) {
                    return c;
                }
                userApiDTO.setMacUsers(Collections.singletonList(macUser.k()));
                break;
            }
            default: {
                return OperationResponse.GENERAL_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(NasApiDTO nasApiDTO, o device, String nasIp, Optional<q> ssidOpt) {
        if (!ssidOpt.isPresent()) {
            nasApiDTO.setAuthType(AuthType.USER_ACCESS);
            return OperationResponse.SUCCESS;
        }
        q ssid = ssidOpt.get();
        if (Objects.nonNull(ssid.z()) && !Objects.equals(nasIp, device.Q().a())) {
            a.debug("Handle portl of device {}", (Object)device.d_());
            nasApiDTO.setAuthType(AuthType.USER_ACCESS);
            return OperationResponse.SUCCESS;
        }
        switch (ssid.r()) {
            case c: {
                nasApiDTO.setAuthType(AuthType.USER_ACCESS);
                break;
            }
            case a: 
            case d: {
                if (!this.b.a(device.p(), device.n(), ssid)) {
                    return OperationResponse.GENERAL_ERROR;
                }
                nasApiDTO.setAuthType(AuthType.MAC);
                break;
            }
            default: {
                return OperationResponse.GENERAL_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse a(UserApiDTO userApiDTO, m osg, LanNetwork lanNetwork, String nasIp, com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g radiusUser) {
        if (Objects.nonNull(lanNetwork.getPortalSetting()) && !Objects.equals(nasIp, osg.dG().a())) {
            userApiDTO.setPassword(radiusUser.k());
            return OperationResponse.SUCCESS;
        }
        if (Objects.equals(nasIp, osg.dG().a())) {
            userApiDTO.setPassword(radiusUser.k());
            userApiDTO.setSite(osg.n().a());
            return OperationResponse.SUCCESS;
        }
        return OperationResponse.PARAM_ERROR;
    }

    private Optional<UserApiDTO> a(RadiusRequest radiusRequest, String realUsername) {
        List<com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g> users = this.b.a(realUsername);
        if (CollectionUtils.isEmpty(users)) {
            return Optional.empty();
        }
        UserApiDTO userApiDTO = new UserApiDTO();
        userApiDTO.setPassword(users.get(0).k());
        userApiDTO.setSite(users.get(0).h().a());
        String callingStationId = this.b(radiusRequest, "Calling-Station-Id").orElse(null);
        String calledStationId = this.b(radiusRequest, "Called-Station-Id").orElse(null);
        String username = this.a(radiusRequest, 1).orElse(null);
        UserAccessInfoDTO userAccessInfoDTO = new UserAccessInfoDTO();
        userAccessInfoDTO.setCalledStationId(calledStationId);
        userAccessInfoDTO.setCallingStationId(callingStationId);
        userAccessInfoDTO.setUsername(username);
        this.b.a(userAccessInfoDTO, users.get(0));
        return Optional.of(userApiDTO);
    }

    private Optional<UserApiDTO> a(String username) {
        UserApiDTO userApiDTO = new UserApiDTO();
        List<com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.radiusprofile.radiusserver.g> users = this.b.a(username, (Integer)1);
        if (CollectionUtils.isEmpty(users)) {
            return Optional.empty();
        }
        userApiDTO.setMacUsers(Collections.singletonList(users.get(0).k()));
        return Optional.of(userApiDTO);
    }

    private Optional<String> b(RadiusRequest radiusRequest, String type) {
        Optional attr = radiusRequest.getAttribute(type);
        if (!attr.isPresent() || !(attr.get() instanceof StringAttribute)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((StringAttribute)attr.get()).getValueString());
    }

    private Optional<String> c(RadiusRequest radiusRequest, String type) {
        return radiusRequest.getAttribute(type).map(RadiusAttribute::getValueString);
    }

    private Optional<String> a(RadiusRequest radiusRequest, int code) {
        Optional attr = radiusRequest.getAttribute(code);
        if (!attr.isPresent() || !(attr.get() instanceof StringAttribute)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((StringAttribute)attr.get()).getValueString());
    }
}

