/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzoDecompressor;
import org.anarres.lzo.lzo_uintp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LzoInputStream
extends InputStream {
    private static final Log LOG = LogFactory.getLog((String)LzoInputStream.class.getName());
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected final InputStream in;
    private final LzoDecompressor decompressor;
    protected byte[] inputBuffer = EMPTY_BYTE_ARRAY;
    protected byte[] outputBuffer = EMPTY_BYTE_ARRAY;
    protected int outputBufferPos;
    protected final lzo_uintp outputBufferLen = new lzo_uintp();

    public LzoInputStream(@Nonnull InputStream in, @Nonnull LzoDecompressor decompressor) {
        this.in = in;
        this.decompressor = decompressor;
    }

    public void setInputBufferSize(@Nonnegative int inputBufferSize) {
        if (inputBufferSize > this.inputBuffer.length) {
            this.inputBuffer = new byte[inputBufferSize];
        }
    }

    public void setOutputBufferSize(@Nonnegative int outputBufferSize) {
        if (outputBufferSize > this.outputBuffer.length) {
            this.outputBuffer = new byte[outputBufferSize];
        }
    }

    public int available() throws IOException {
        return this.outputBufferLen.value - this.outputBufferPos;
    }

    public int read() throws IOException {
        if (!this.fill()) {
            return -1;
        }
        return this.outputBuffer[this.outputBufferPos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.fill()) {
            return -1;
        }
        len = Math.min(len, this.available());
        System.arraycopy(this.outputBuffer, this.outputBufferPos, b, off, len);
        this.outputBufferPos += len;
        return len;
    }

    protected void logState(@Nonnull String when) {
        LOG.info((Object)"\n");
        LOG.info((Object)(when + " Input buffer size=" + this.inputBuffer.length));
        LOG.info((Object)(when + " Output buffer pos=" + this.outputBufferPos + "; length=" + this.outputBufferLen + "; size=" + this.outputBuffer.length));
    }

    private boolean fill() throws IOException {
        while (this.available() == 0) {
            if (this.readBlock()) continue;
            return false;
        }
        return true;
    }

    protected boolean readBlock() throws IOException {
        int outputBufferLength = this.readInt(true);
        if (outputBufferLength == -1) {
            return false;
        }
        this.setOutputBufferSize(outputBufferLength);
        int inputBufferLength = this.readInt(false);
        this.setInputBufferSize(inputBufferLength);
        this.readBytes(this.inputBuffer, 0, inputBufferLength);
        this.decompress(outputBufferLength, inputBufferLength);
        return true;
    }

    protected void decompress(@Nonnegative int outputBufferLength, @Nonnegative int inputBufferLength) throws IOException {
        try {
            this.outputBufferPos = 0;
            this.outputBufferLen.value = this.outputBuffer.length;
            int code = this.decompressor.decompress(this.inputBuffer, 0, inputBufferLength, this.outputBuffer, 0, this.outputBufferLen);
            if (code != 0) {
                this.logState("LZO error: " + code);
                throw new IllegalArgumentException(this.decompressor.toErrorString(code));
            }
            if (this.outputBufferLen.value != outputBufferLength) {
                this.logState("Output underrun: ");
                throw new IllegalStateException("Expected " + outputBufferLength + " bytes, but got only " + this.outputBufferLen);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.logState("IndexOutOfBoundsException: " + e);
            throw new IOException(e);
        }
    }

    @CheckForSigned
    protected int readInt(boolean start_of_frame) throws IOException {
        int b4;
        int b3;
        int b1 = this.in.read();
        if (b1 == -1) {
            if (start_of_frame) {
                return -1;
            }
            throw new EOFException("EOF before reading 4-byte integer.");
        }
        int b2 = this.in.read();
        if ((b1 | b2 | (b3 = this.in.read()) | (b4 = this.in.read())) < 0) {
            throw new EOFException("EOF while reading 4-byte integer.");
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    protected void readBytes(@Nonnull byte[] buf, @Nonnegative int off, @Nonnegative int length) throws IOException {
        while (length > 0) {
            int count = this.in.read(buf, off, length);
            if (count < 0) {
                throw new EOFException();
            }
            off += count;
            length -= count;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }
}

