/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoTransformer;
import org.anarres.lzo.SuppressWarnings;

public class AbstractLzoTransformer
implements LzoTransformer {
    private final LzoAlgorithm algorithm;
    private final LzoConstraint[] constraints;

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public AbstractLzoTransformer(LzoAlgorithm algorithm, LzoConstraint ... constraints) {
        this.algorithm = algorithm;
        this.constraints = constraints;
    }

    public LzoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public LzoConstraint[] getConstraints() {
        return this.constraints;
    }

    public String toErrorString(int code) {
        switch (code) {
            case 0: {
                return "OK";
            }
            case -1: {
                return "Error";
            }
            case -2: {
                return "Out of memory";
            }
            case -3: {
                return "Not compressible";
            }
            case -4: {
                return "Input overrun";
            }
            case -5: {
                return "Output overrun";
            }
            case -6: {
                return "Lookbehind overrun";
            }
            case -7: {
                return "EOF not found";
            }
            case -8: {
                return "Input not consumed";
            }
        }
        return "Unknown-" + code;
    }
}

