/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.port.local;

import com.tplink.smb.eventcenter.api.BaseEvent;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventFuture;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.eventcenter.api.EventV2;
import com.tplink.smb.eventcenter.api.GenericEventFuture;
import com.tplink.smb.eventcenter.api.GenericEventHandler;
import com.tplink.smb.eventcenter.api.constant.EventCenterSendResult;
import com.tplink.smb.eventcenter.api.constant.GenericEventCenterSendResult;
import com.tplink.smb.eventcenter.api.constant.PartitionAssignorMode;
import com.tplink.smb.eventcenter.api.constant.SerializeEnum;
import com.tplink.smb.eventcenter.api.exception.DuplicateGroupIdException;
import com.tplink.smb.eventcenter.core.DataProcessor;
import com.tplink.smb.eventcenter.core.GenericDataProcessor;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class LocalEventCenter
implements EventCenter {
    private static final Logger log = LoggerFactory.getLogger(LocalEventCenter.class);
    private final ConcurrentHashMap<String, AtomicReference<Set<String>>> topicGroupMap = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<String, EventHandler> groupHandlerMap = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<String, ExecutorService> groupExecutorMap = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<String, AtomicReference<Set<String>>> genericTopicGroupMap = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<String, GenericEventHandler<?>> genericGroupHandlerMap = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<String, ExecutorService> genericGroupExecutorMap = new ConcurrentHashMap(4);
    private final String METHOD_NOT_IMPLEMENT = "Method not implement yet, use send instead.";

    public void send(@Nonnull String topic, @Nonnull Event event) {
        this.send(topic, null, null, event, null);
    }

    public void send(@Nonnull String topic, @Nonnull Event event, EventFuture eventFuture) {
        this.send(topic, null, null, event, eventFuture);
    }

    public void send(@Nonnull String topic, String key, @Nonnull Event event) {
        this.send(topic, key, null, event, null);
    }

    public void send(@Nonnull String topic, @Nonnull Integer partition, @Nonnull Event event) {
        this.send(topic, null, partition, event, null);
    }

    public void send(@Nonnull String topic, @Nonnull Integer partition, @Nonnull Event event, EventFuture eventFuture) {
        this.send(topic, null, partition, event, eventFuture);
    }

    public void send(@Nonnull String topic, String key, @Nonnull Event event, EventFuture eventFuture) {
        this.send(topic, key, null, event, eventFuture);
    }

    private void send(@Nonnull String topic, String key, Integer partition, @Nonnull Event event, EventFuture eventFuture) {
        event.setTimeStamp(System.currentTimeMillis());
        if (log.isTraceEnabled()) {
            log.trace("before handle event: {}", (Object)event);
        }
        if (!this.dispatchEvent(topic, event)) {
            log.warn("Failed to knock event, filterKey: {}, topic:{}", (Object)event.getFilterKey(), (Object)topic);
            return;
        }
        if (Objects.nonNull(eventFuture)) {
            EventCenterSendResult eventCenterSendResult = new EventCenterSendResult(topic, key, event, System.currentTimeMillis(), partition);
            eventFuture.onSuccess(eventCenterSendResult);
        }
        if (log.isTraceEnabled()) {
            log.trace("after handle event: {}", (Object)event);
        }
    }

    public void registerBroadcast(@Nonnull String topic, @Nonnull EventHandler handler, @Nonnull ExecutorService executorService) {
        String groupId = UUID.randomUUID().toString();
        this.registerUnicast(topic, groupId, handler, executorService);
    }

    public void registerBroadcast(@Nonnull String topic, @Nonnull EventHandler handler, @Nonnull ExecutorService executorService, PartitionAssignorMode partitionAssignorMode) {
        this.registerBroadcast(topic, handler, executorService);
    }

    public void registerUnicast(@Nonnull String topic, @Nonnull String groupId, @Nonnull EventHandler handler, @Nonnull ExecutorService executorService) {
        this.register(topic, groupId, handler, executorService);
    }

    public void registerUnicast(@Nonnull String topic, @Nonnull String groupId, @Nonnull EventHandler handler, @Nonnull ExecutorService executorService, PartitionAssignorMode partitionAssignorMode) {
        this.registerUnicast(topic, groupId, handler, executorService);
    }

    public void registerBroadcastWithoutThreadPool(@Nonnull String topic, @Nonnull EventHandler handler, PartitionAssignorMode partitionAssignorMode) {
        String groupId = UUID.randomUUID().toString();
        this.registerUnicastWithoutThreadPool(topic, groupId, handler, partitionAssignorMode);
    }

    public void registerUnicastWithoutThreadPool(@Nonnull String topic, @Nonnull String groupId, @Nonnull EventHandler handler, PartitionAssignorMode partitionAssignorMode) {
        this.register(topic, groupId, handler, null);
    }

    public void unregister(@Nonnull String topic, @Nonnull EventHandler handler) {
        boolean haveHandler = false;
        String groupId = null;
        for (Map.Entry<String, EventHandler> entry : this.groupHandlerMap.entrySet()) {
            EventHandler eventHandler = entry.getValue();
            if (!Objects.equals(eventHandler, handler)) continue;
            groupId = entry.getKey();
            haveHandler = true;
            break;
        }
        if (haveHandler) {
            this.groupHandlerMap.remove(groupId);
            this.groupExecutorMap.remove(groupId);
            AtomicReference<Set<String>> atomicReference = this.topicGroupMap.get(topic);
            this.doUnRegister(groupId, atomicReference);
        } else {
            log.warn("No such handler could be found to unregister!");
        }
    }

    public <T> void sendGenerically(@Nonnull String topic, @Nonnull T event) {
        this.sendGenerically(topic, null, null, event, null);
    }

    public <T> void sendGenerically(@Nonnull String topic, @Nonnull T event, GenericEventFuture<T> genericEventFuture) {
        this.sendGenerically(topic, null, null, event, genericEventFuture);
    }

    public <T> void sendGenerically(@Nonnull String topic, String key, @Nonnull T event) {
        this.sendGenerically(topic, key, null, event, null);
    }

    public <T> void sendGenerically(@Nonnull String topic, @Nonnull Integer partition, @Nonnull T event) {
        this.sendGenerically(topic, null, partition, event, null);
    }

    public <T> void sendGenerically(@Nonnull String topic, @Nonnull Integer partition, @Nonnull T event, GenericEventFuture<T> genericEventFuture) {
        this.sendGenerically(topic, null, partition, event, genericEventFuture);
    }

    public <T> void sendGenerically(@Nonnull String topic, String key, @Nonnull T event, GenericEventFuture<T> genericEventFuture) {
        this.sendGenerically(topic, key, null, event, genericEventFuture);
    }

    private <T> void sendGenerically(@Nonnull String topic, String key, Integer partition, @Nonnull T event, GenericEventFuture<T> genericEventFuture) {
        if (log.isTraceEnabled()) {
            log.trace("before handle event: {}", event);
        }
        if (!this.dispatchEvent(topic, event)) {
            log.warn("Failed to knock event, topic: {}, key:{}", (Object)topic, (Object)key);
            return;
        }
        if (Objects.nonNull(genericEventFuture)) {
            GenericEventCenterSendResult genericEventCenterSendResult = new GenericEventCenterSendResult(topic, key, event, System.currentTimeMillis(), partition);
            genericEventFuture.onSuccess(genericEventCenterSendResult);
        }
        if (log.isTraceEnabled()) {
            log.trace("after handle event: {}", event);
        }
    }

    public <T> void registerBroadcastGenerically(@Nonnull String topic, @Nonnull GenericEventHandler<T> handler, @Nonnull ExecutorService executorService, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        String groupId = UUID.randomUUID().toString();
        this.registerUnicastGenerically(topic, groupId, handler, executorService, clazz);
    }

    public <T> void registerBroadcastGenerically(@Nonnull String topic, @Nonnull GenericEventHandler<T> handler, @Nonnull ExecutorService executorService, PartitionAssignorMode partitionAssignorMode, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.registerBroadcastGenerically(topic, handler, executorService, clazz);
    }

    public <T> void registerUnicastGenerically(@Nonnull String topic, @Nonnull String groupId, @Nonnull GenericEventHandler<T> handler, @Nonnull ExecutorService executorService, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.register(topic, groupId, handler, executorService);
    }

    public <T> void registerUnicastGenerically(@Nonnull String topic, @Nonnull String groupId, @Nonnull GenericEventHandler<T> handler, @Nonnull ExecutorService executorService, PartitionAssignorMode partitionAssignorMode, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.registerUnicastGenerically(topic, groupId, handler, executorService, clazz);
    }

    public <T> void registerBroadcastWithoutThreadPoolGenerically(@Nonnull String topic, @Nonnull GenericEventHandler<T> handler, PartitionAssignorMode partitionAssignorMode, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        String groupId = UUID.randomUUID().toString();
        this.registerUnicastWithoutThreadPoolGenerically(topic, groupId, handler, partitionAssignorMode, clazz);
    }

    public <T> void registerUnicastWithoutThreadPoolGenerically(@Nonnull String topic, @Nonnull String groupId, @Nonnull GenericEventHandler<T> handler, PartitionAssignorMode partitionAssignorMode, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.register(topic, groupId, handler, null);
    }

    public <T> void unregisterGenerically(@Nonnull String topic, @Nonnull GenericEventHandler<T> handler) {
        boolean haveHandler = false;
        String groupId = null;
        for (Map.Entry<String, GenericEventHandler<?>> entry : this.genericGroupHandlerMap.entrySet()) {
            GenericEventHandler<?> eventHandler = entry.getValue();
            if (!Objects.equals(eventHandler, handler)) continue;
            groupId = entry.getKey();
            haveHandler = true;
            break;
        }
        if (haveHandler) {
            this.genericGroupHandlerMap.remove(groupId);
            this.genericGroupExecutorMap.remove(groupId);
            AtomicReference<Set<String>> atomicReference = this.genericTopicGroupMap.get(topic);
            this.doUnRegister(groupId, atomicReference);
        } else {
            log.warn("No such handler could be found to unregister!");
        }
    }

    public <T> void unregisterGenerically(@Nonnull String topic, @Nonnull GenericEventHandler<T> handler, boolean isDestroyExecutorService) {
        this.unregisterGenerically(topic, handler);
    }

    public void unregister(@Nonnull String topic, @Nonnull EventHandler eventHandler, boolean isDestroyExecutorService) {
        this.unregister(topic, eventHandler);
    }

    public void unregisterAllTopics() {
        this.destroy();
    }

    @PreDestroy
    public void destroy() {
        this.topicGroupMap.clear();
        this.groupHandlerMap.clear();
        this.groupExecutorMap.clear();
        this.genericTopicGroupMap.clear();
        this.genericGroupHandlerMap.clear();
        this.genericGroupExecutorMap.clear();
    }

    private void doUnRegister(String groupId, AtomicReference<Set<String>> atomicReference) {
        HashSet<Object> newGroups;
        Set<String> oldGroups;
        boolean isUpdate;
        do {
            oldGroups = atomicReference.get();
            newGroups = CollectionUtils.isEmpty((Collection)atomicReference.get()) ? new HashSet() : new HashSet<String>(oldGroups);
            newGroups.remove(groupId);
        } while (!(isUpdate = atomicReference.compareAndSet(oldGroups, newGroups)));
    }

    private boolean dispatchEvent(String topic, Event event) {
        if (!this.topicGroupMap.containsKey(topic)) {
            log.warn("no handlers for topic: {},", (Object)topic);
            return false;
        }
        AtomicReference<Set<String>> atomicReference = this.topicGroupMap.get(topic);
        if (Objects.isNull(atomicReference) || CollectionUtils.isEmpty((Collection)atomicReference.get())) {
            return true;
        }
        for (String groupId : atomicReference.get()) {
            EventHandler eventHandler = this.groupHandlerMap.get(groupId);
            ExecutorService executorService = this.groupExecutorMap.get(groupId);
            log.debug("handlers: {},", eventHandler.getClass());
            if (Objects.nonNull(executorService)) {
                executorService.submit((Runnable)new DataProcessor(event, eventHandler));
                continue;
            }
            this.dataProcessor(event, eventHandler);
        }
        return true;
    }

    private void register(String topic, String groupId, EventHandler handler, ExecutorService executorService) {
        try {
            AtomicReference<Set<String>> atomicReference = this.doRegister(groupId, this.topicGroupMap.computeIfAbsent(topic, k -> new AtomicReference()));
            this.topicGroupMap.put(topic, atomicReference);
            this.groupHandlerMap.put(groupId, handler);
            this.groupExecutorMap.put(groupId, executorService);
        }
        catch (DuplicateGroupIdException duplicateGroupIdException) {
            log.warn("The groupId has been registered! Please check the value of groupId:{}.topic:{}", (Object)groupId, (Object)topic);
        }
    }

    private void dataProcessor(Event event, EventHandler eventHandler) {
        try {
            eventHandler.handleEvent(event);
        }
        catch (Exception e) {
            log.error("Fail to process event, filterKey:{}, handler:{}", new Object[]{event.getFilterKey(), eventHandler, e});
        }
    }

    private <T> boolean dispatchEvent(String topic, T event) {
        if (!this.genericTopicGroupMap.containsKey(topic)) {
            log.warn("no handlers for topic: {},", (Object)topic);
            return false;
        }
        AtomicReference<Set<String>> atomicReference = this.genericTopicGroupMap.get(topic);
        if (Objects.isNull(atomicReference) || CollectionUtils.isEmpty((Collection)atomicReference.get())) {
            return true;
        }
        for (String groupId : atomicReference.get()) {
            GenericEventHandler<?> eventHandler = this.genericGroupHandlerMap.get(groupId);
            ExecutorService executorService = this.genericGroupExecutorMap.get(groupId);
            log.debug("handlers: {},", eventHandler.getClass());
            if (Objects.nonNull(executorService)) {
                executorService.submit((Runnable)new GenericDataProcessor(event, eventHandler));
                continue;
            }
            this.dataProcessor(event, eventHandler);
        }
        return true;
    }

    private <T> void register(String topic, String groupId, GenericEventHandler<T> handler, ExecutorService executorService) {
        try {
            AtomicReference<Set<String>> atomicReference = this.doRegister(groupId, this.genericTopicGroupMap.computeIfAbsent(topic, k -> new AtomicReference()));
            this.genericTopicGroupMap.put(topic, atomicReference);
            this.genericGroupHandlerMap.put(groupId, handler);
            this.genericGroupExecutorMap.put(groupId, executorService);
        }
        catch (DuplicateGroupIdException duplicateGroupIdException) {
            log.warn("The groupId has been registered! Please check the value of groupId:{}.topic:{}", (Object)groupId, (Object)topic);
        }
    }

    private AtomicReference<Set<String>> doRegister(String groupId, AtomicReference<Set<String>> atomicReference) throws DuplicateGroupIdException {
        HashSet<String> newGroups;
        Set<String> oldGroups;
        boolean isUpdate;
        do {
            if (CollectionUtils.isEmpty(oldGroups = atomicReference.get())) {
                newGroups = new HashSet<String>();
            } else {
                if (oldGroups.contains(groupId)) {
                    throw new DuplicateGroupIdException();
                }
                newGroups = new HashSet(atomicReference.get());
            }
            newGroups.add(groupId);
        } while (!(isUpdate = atomicReference.compareAndSet(oldGroups, newGroups)));
        return atomicReference;
    }

    private <T> void dataProcessor(T event, GenericEventHandler<T> eventHandler) {
        try {
            eventHandler.handleEvent(event);
        }
        catch (Exception e) {
            log.error("Fail to process event, handler:{}", eventHandler, (Object)e);
        }
    }

    public void send(@Nonnull String topic, @Nonnull BaseEvent event, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.sendWithKryo(topic, null, null, (EventV2)event, null);
                break;
            }
            default: {
                log.debug("Method not implement yet, use send instead.");
            }
        }
    }

    public void send(@Nonnull String topic, @Nonnull BaseEvent event, GenericEventFuture eventFuture, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.sendWithKryo(topic, null, null, (EventV2)event, eventFuture);
                break;
            }
            default: {
                log.debug("Method not implement yet, use send instead.");
            }
        }
    }

    public void send(@Nonnull String topic, String key, @Nonnull BaseEvent event, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.sendWithKryo(topic, key, null, (EventV2)event, null);
                break;
            }
            default: {
                log.debug("Method not implement yet, use send instead.");
            }
        }
    }

    public void send(@Nonnull String topic, String key, @Nonnull BaseEvent event, GenericEventFuture eventFuture, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.sendWithKryo(topic, key, null, (EventV2)event, eventFuture);
                break;
            }
            default: {
                log.debug("Method not implement yet, use send instead.");
            }
        }
    }

    public void send(@Nonnull String topic, @Nonnull Integer partition, @Nonnull BaseEvent event, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.sendWithKryo(topic, null, partition, (EventV2)event, null);
                break;
            }
            default: {
                log.debug("Method not implement yet, use send instead.");
            }
        }
    }

    public void send(@Nonnull String topic, @Nonnull Integer partition, @Nonnull BaseEvent event, GenericEventFuture eventFuture, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.sendWithKryo(topic, null, partition, (EventV2)event, eventFuture);
                break;
            }
            default: {
                log.debug("Method not implement yet, use send instead.");
            }
        }
    }

    private <T> void sendWithKryo(@Nonnull String topic, String key, Integer partition, @Nonnull EventV2<T> event, GenericEventFuture eventFuture) {
        event.setTimeStamp(System.currentTimeMillis());
        if (log.isTraceEnabled()) {
            log.trace("before handle event: {}", event);
        }
        if (!this.dispatchEvent(topic, event)) {
            log.warn("Failed to knock event, filterKey: {}, topic:{}", (Object)event.getFilterKey(), (Object)topic);
            return;
        }
        if (Objects.nonNull(eventFuture)) {
            GenericEventCenterSendResult genericEventCenterSendResult = new GenericEventCenterSendResult(topic, key, event.getMessage(), System.currentTimeMillis(), partition);
            eventFuture.onSuccess(genericEventCenterSendResult);
        }
        if (log.isTraceEnabled()) {
            log.trace("after handle event: {}", event);
        }
    }

    public void registerBroadcast(@Nonnull String topic, @Nonnull GenericEventHandler handler, @Nonnull ExecutorService executorService, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                String groupId = UUID.randomUUID().toString();
                this.registerUnicast(topic, groupId, handler, executorService, serializeEnum);
                break;
            }
            default: {
                this.registerBroadcastGenerically(topic, handler, executorService, EventV2.class);
            }
        }
    }

    public void registerBroadcast(@Nonnull String topic, @Nonnull GenericEventHandler handler, @Nonnull ExecutorService executorService, PartitionAssignorMode partitionAssignorMode, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                String groupId = UUID.randomUUID().toString();
                this.registerUnicast(topic, groupId, handler, executorService, partitionAssignorMode, serializeEnum);
                break;
            }
            default: {
                this.registerBroadcastGenerically(topic, handler, executorService, partitionAssignorMode, EventV2.class);
            }
        }
    }

    public void registerUnicast(@Nonnull String topic, @Nonnull String groupId, @Nonnull GenericEventHandler handler, @Nonnull ExecutorService executorService, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.registerUnicast(topic, groupId, handler, executorService, null, serializeEnum);
                break;
            }
            default: {
                this.registerUnicastGenerically(topic, groupId, handler, executorService, null, EventV2.class);
            }
        }
    }

    public void registerUnicast(@Nonnull String topic, @Nonnull String groupId, @Nonnull GenericEventHandler handler, @Nonnull ExecutorService executorService, PartitionAssignorMode partitionAssignorMode, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.registerUnicastGenerically(topic, groupId, handler, executorService, EventV2.class);
                break;
            }
            default: {
                this.registerUnicastGenerically(topic, groupId, handler, executorService, partitionAssignorMode, EventV2.class);
            }
        }
    }

    public void registerBroadcastWithoutThreadPool(@Nonnull String topic, @Nonnull GenericEventHandler handler, PartitionAssignorMode partitionAssignorMode, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                String groupId = UUID.randomUUID().toString();
                this.registerUnicastWithoutThreadPoolGenerically(topic, groupId, handler, partitionAssignorMode, EventV2.class);
                break;
            }
            default: {
                this.registerBroadcastWithoutThreadPoolGenerically(topic, handler, partitionAssignorMode, EventV2.class);
            }
        }
    }

    public void registerUnicastWithoutThreadPool(@Nonnull String topic, @Nonnull String groupId, @Nonnull GenericEventHandler handler, PartitionAssignorMode partitionAssignorMode, @Nonnull SerializeEnum serializeEnum) {
        switch (serializeEnum) {
            case KRYO: {
                this.register(topic, groupId, handler, null);
                break;
            }
            default: {
                this.registerUnicastWithoutThreadPoolGenerically(topic, groupId, handler, partitionAssignorMode, EventV2.class);
            }
        }
    }
}

